<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Service
 *
 * @ORM\Table(name="service")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ServiceRepository")
 */
class Service
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="service")
     * @ORM\JoinColumn(name="qrcode_transaction_number_id", referencedColumnName="id")
     */
    private $transactionNumber;

    /**
     * @ORM\ManyToOne(targetEntity="Quittance", inversedBy="service")
     * @ORM\JoinColumn(name="quittance_id", referencedColumnName="id")
     */
    private $quittance;

    /**
     * @var string
     *
     * @ORM\Column(name="sqrId", type="string", length=255)
     */
    private $sqrId;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=50)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="typePiece", type="string", length=50)
     */
    private $typePiece;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone", type="string", length=50)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="pieceNumber", type="string", length=50)
     */
    private $pieceNumber;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateIssued", type="date")
     */
    private $dateIssued;

    /**
     * @var string
     *
     * @ORM\Column(name="placeIssued", type="string", length=50)
     */
    private $placeIssued;

    /**
     * @var float
     *
     * @ORM\Column(name="fees", type="float")
     */
    private $fees;

    /**
     * @var float
     *
     * @ORM\Column(name="total", type="float")
     */
    private $total;

    /**
     * @var bool
     *
     * @ORM\Column(name="isPaid", type="boolean")
     */
    private $isPaid;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="service")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="ServiceArticle", mappedBy="service")
    */
    private $serviceArticle;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->fees = 25; // default date
        $this->isPaid = 0; // 0=non payé paid = 1
        $this->serviceArticle = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set sqrId
     *
     * @param string $sqrId
     *
     * @return Service
     */
    public function setSqrId($sqrId)
    {
        $this->sqrId = $sqrId;

        return $this;
    }

    /**
     * Get sqrId
     *
     * @return string
     */
    public function getSqrId()
    {
        return $this->sqrId;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return Service
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set typePiece
     *
     * @param string $typePiece
     *
     * @return Service
     */
    public function setTypePiece($typePiece)
    {
        $this->typePiece = $typePiece;

        return $this;
    }

    /**
     * Get typePiece
     *
     * @return string
     */
    public function getTypePiece()
    {
        return $this->typePiece;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     *
     * @return Service
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set pieceNumber
     *
     * @param string $pieceNumber
     *
     * @return Service
     */
    public function setPieceNumber($pieceNumber)
    {
        $this->pieceNumber = $pieceNumber;

        return $this;
    }

    /**
     * Get pieceNumber
     *
     * @return string
     */
    public function getPieceNumber()
    {
        return $this->pieceNumber;
    }

    /**
     * Set dateIssued
     *
     * @param \DateTime $dateIssued
     *
     * @return Service
     */
    public function setDateIssued($dateIssued)
    {
        $this->dateIssued = $dateIssued;

        return $this;
    }

    /**
     * Get dateIssued
     *
     * @return \DateTime
     */
    public function getDateIssued()
    {
        return $this->dateIssued;
    }

    /**
     * Set placeIssued
     *
     * @param string $placeIssued
     *
     * @return Service
     */
    public function setPlaceIssued($placeIssued)
    {
        $this->placeIssued = $placeIssued;

        return $this;
    }

    /**
     * Get placeIssued
     *
     * @return string
     */
    public function getPlaceIssued()
    {
        return $this->placeIssued;
    }

    /**
     * Set fees
     *
     * @param float $fees
     *
     * @return Service
     */
    public function setFees($fees)
    {
        $this->fees = $fees;

        return $this;
    }

    /**
     * Get fees
     *
     * @return float
     */
    public function getFees()
    {
        return $this->fees;
    }

    /**
     * Set total
     *
     * @param float $total
     *
     * @return Service
     */
    public function setTotal($total)
    {
        $this->total = $total;

        return $this;
    }

    /**
     * Get total
     *
     * @return float
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * Set isPaid
     *
     * @param boolean $isPaid
     *
     * @return Service
     */
    public function setIsPaid($isPaid)
    {
        $this->isPaid = $isPaid;

        return $this;
    }

    /**
     * Get isPaid
     *
     * @return boolean
     */
    public function getIsPaid()
    {
        return $this->isPaid;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Service
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set transactionNumber
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $transactionNumber
     *
     * @return Service
     */
    public function setTransactionNumber(\AMLA\SqrBundle\Entity\CheckQr $transactionNumber = null)
    {
        $this->transactionNumber = $transactionNumber;

        return $this;
    }

    /**
     * Get transactionNumber
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getTransactionNumber()
    {
        return $this->transactionNumber;
    }

    /**
     * Set quittance
     *
     * @param \AMLA\SqrBundle\Entity\Quittance $quittance
     *
     * @return Service
     */
    public function setQuittance(\AMLA\SqrBundle\Entity\Quittance $quittance = null)
    {
        $this->quittance = $quittance;

        return $this;
    }

    /**
     * Get quittance
     *
     * @return \AMLA\SqrBundle\Entity\Quittance
     */
    public function getQuittance()
    {
        return $this->quittance;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return Service
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Add serviceArticle
     *
     * @param \AMLA\SqrBundle\Entity\ServiceArticle $serviceArticle
     *
     * @return Service
     */
    public function addServiceArticle(\AMLA\SqrBundle\Entity\ServiceArticle $serviceArticle)
    {
        $this->serviceArticle[] = $serviceArticle;

        return $this;
    }

    /**
     * Remove serviceArticle
     *
     * @param \AMLA\SqrBundle\Entity\ServiceArticle $serviceArticle
     */
    public function removeServiceArticle(\AMLA\SqrBundle\Entity\ServiceArticle $serviceArticle)
    {
        $this->serviceArticle->removeElement($serviceArticle);
    }

    /**
     * Get serviceArticle
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getServiceArticle()
    {
        return $this->serviceArticle;
    }
}
