<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Repertoire
 *
 * @ORM\Table(name="repertoire")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\RepertoireRepository")
 */
class Repertoire
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
    
    /**
     * @var string|null
     *
     * @ORM\Column(name="nomRaisonSociale", type="string", length=150, nullable=true)
     */
    private $nomRaisonSociale;
    
    /**
     * @var string
     *
     * @ORM\Column(name="prenomSigle", type="string", length=100, nullable=true)
     */
    private $prenomSigle;
    
    /**
     * @var string|null
     *
     * @ORM\Column(name="niu", type="string", length=15, nullable=true)
     */
    private $niu;
    
    /**
     * @var string|null
     *
     * @ORM\Column(name="telephone", type="string", length=50, nullable=true)
     */
    private $telephone;
    
    /**
     * @var string|null
     *
     * @ORM\Column(name="email", type="string", length=50, nullable=true)
     */
    private $email;
    
    /**
     * @var string|null
     *
     * @ORM\Column(name="adresse", type="string", length=255, nullable=true)
     */
    private $adresse;
    
    /**
     * @var string|null
     *
     * @ORM\Column(name="registreCommerce", type="string", length=50, nullable=true)
     */
    private $registreCommerce;
    
    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="repertoire")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;
    
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;
    
    /**
     * @ORM\OneToMany(targetEntity="AccessInBill", mappedBy="repertoire")
     */
    private $accessInBill;
    
    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;
    
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;  
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nomRaisonSociale.
     *
     * @param string|null $nomRaisonSociale
     *
     * @return Repertoire
     */
    public function setNomRaisonSociale($nomRaisonSociale = null)
    {
        $this->nomRaisonSociale = $nomRaisonSociale;

        return $this;
    }

    /**
     * Get nomRaisonSociale.
     *
     * @return string|null
     */
    public function getNomRaisonSociale()
    {
        return $this->nomRaisonSociale;
    }

    /**
     * Set prenomSigle.
     *
     * @param string $prenomSigle
     *
     * @return Repertoire
     */
    public function setPrenomSigle($prenomSigle)
    {
        $this->prenomSigle = $prenomSigle;

        return $this;
    }

    /**
     * Get prenomSigle.
     *
     * @return string
     */
    public function getPrenomSigle()
    {
        return $this->prenomSigle;
    }

    /**
     * Set niu.
     *
     * @param string|null $niu
     *
     * @return Repertoire
     */
    public function setNiu($niu = null)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu.
     *
     * @return string|null
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set telephone.
     *
     * @param string|null $telephone
     *
     * @return Repertoire
     */
    public function setTelephone($telephone = null)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone.
     *
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set email.
     *
     * @param string|null $email
     *
     * @return Repertoire
     */
    public function setEmail($email = null)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email.
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set adresse.
     *
     * @param string|null $adresse
     *
     * @return Repertoire
     */
    public function setAdresse($adresse = null)
    {
        $this->adresse = $adresse;

        return $this;
    }

    /**
     * Get adresse.
     *
     * @return string|null
     */
    public function getAdresse()
    {
        return $this->adresse;
    }

    /**
     * Set fournisseur.
     *
     * @param int $fournisseur
     *
     * @return Repertoire
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur.
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set dateCreated.
     *
     * @param \DateTime $dateCreated
     *
     * @return Repertoire
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated.
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set status.
     *
     * @param int $status
     *
     * @return Repertoire
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status.
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set registreCommerce.
     *
     * @param string|null $registreCommerce
     *
     * @return Repertoire
     */
    public function setRegistreCommerce($registreCommerce = null)
    {
        $this->registreCommerce = $registreCommerce;

        return $this;
    }

    /**
     * Get registreCommerce.
     *
     * @return string|null
     */
    public function getRegistreCommerce()
    {
        return $this->registreCommerce;
    }

    /**
     * Add accessInBill.
     *
     * @param \AMLA\SqrBundle\Entity\AccessInBill $accessInBill
     *
     * @return Repertoire
     */
    public function addAccessInBill(\AMLA\SqrBundle\Entity\AccessInBill $accessInBill)
    {
        $this->accessInBill[] = $accessInBill;

        return $this;
    }

    /**
     * Remove accessInBill.
     *
     * @param \AMLA\SqrBundle\Entity\AccessInBill $accessInBill
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeAccessInBill(\AMLA\SqrBundle\Entity\AccessInBill $accessInBill)
    {
        return $this->accessInBill->removeElement($accessInBill);
    }

    /**
     * Get accessInBill.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAccessInBill()
    {
        return $this->accessInBill;
    }
}
