<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RemiseGracieuse
 *
 * @ORM\Table(name="remise_gracieuse")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\RemiseGracieuseRepository")
 */
class RemiseGracieuse
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="typeRecour", type="string", length=50)
     */
    private $typeRecour;

    /**
     * @var string
     *
     * @ORM\Column(name="referenceRecour", type="string", length=50)
     */
    private $referenceRecour;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="bonCommandes")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var int
     *
     * @ORM\Column(name="delai", type="integer")
     */
    private $delai;

    /**
     * @var float
     *
     * @ORM\Column(name="montant", type="float")
     */
    private $montant;

    /**
     * @var string
     *
     * @ORM\Column(name="justificatifRecour", type="string", length=255)
     */
    private $justificatifRecour;

    /**
     * @var string
     *
     * @ORM\Column(name="justificatifPaiement", type="string", length=255)
     */
    private $justificatifPaiement;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="integer")
     */
    private $statut;

    /**
     * @var string
     *
     * @ORM\Column(name="motif", type="text")
     */
    private $motif;

    /**
     * @var int
     *
     * @ORM\Column(name="decision", type="integer")
     */
    private $decision;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="remiseGracieuseDecision")
     * @ORM\JoinColumn(name="account_decision_id", referencedColumnName="id")
     */
    private $auteurDecision;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;
    
    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="remiseGracieuse")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set typeRecour
     *
     * @param string $typeRecour
     *
     * @return RemiseGracieuse
     */
    public function setTypeRecour($typeRecour)
    {
        $this->typeRecour = $typeRecour;

        return $this;
    }

    /**
     * Get typeRecour
     *
     * @return string
     */
    public function getTypeRecour()
    {
        return $this->typeRecour;
    }

    /**
     * Set referenceRecour
     *
     * @param string $referenceRecour
     *
     * @return RemiseGracieuse
     */
    public function setReferenceRecour($referenceRecour)
    {
        $this->referenceRecour = $referenceRecour;

        return $this;
    }

    /**
     * Get referenceRecour
     *
     * @return string
     */
    public function getReferenceRecour()
    {
        return $this->referenceRecour;
    }

    /**
     * Set delai
     *
     * @param integer $delai
     *
     * @return RemiseGracieuse
     */
    public function setDelai($delai)
    {
        $this->delai = $delai;

        return $this;
    }

    /**
     * Get delai
     *
     * @return integer
     */
    public function getDelai()
    {
        return $this->delai;
    }

    /**
     * Set montant
     *
     * @param float $montant
     *
     * @return RemiseGracieuse
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return float
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set justificatifRecour
     *
     * @param string $justificatifRecour
     *
     * @return RemiseGracieuse
     */
    public function setJustificatifRecour($justificatifRecour)
    {
        $this->justificatifRecour = $justificatifRecour;

        return $this;
    }

    /**
     * Get justificatifRecour
     *
     * @return string
     */
    public function getJustificatifRecour()
    {
        return $this->justificatifRecour;
    }

    /**
     * Set justificatifPaiement
     *
     * @param string $justificatifPaiement
     *
     * @return RemiseGracieuse
     */
    public function setJustificatifPaiement($justificatifPaiement)
    {
        $this->justificatifPaiement = $justificatifPaiement;

        return $this;
    }

    /**
     * Get justificatifPaiement
     *
     * @return string
     */
    public function getJustificatifPaiement()
    {
        return $this->justificatifPaiement;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return RemiseGracieuse
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set motif
     *
     * @param string $motif
     *
     * @return RemiseGracieuse
     */
    public function setMotif($motif)
    {
        $this->motif = $motif;

        return $this;
    }

    /**
     * Get motif
     *
     * @return string
     */
    public function getMotif()
    {
        return $this->motif;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return RemiseGracieuse
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return RemiseGracieuse
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return RemiseGracieuse
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set decision
     *
     * @param integer $decision
     *
     * @return RemiseGracieuse
     */
    public function setDecision($decision)
    {
        $this->decision = $decision;

        return $this;
    }

    /**
     * Get decision
     *
     * @return integer
     */
    public function getDecision()
    {
        return $this->decision;
    }

    /**
     * Set auteurDecision
     *
     * @param \AMLA\SqrBundle\Entity\Account $auteurDecision
     *
     * @return RemiseGracieuse
     */
    public function setAuteurDecision(\AMLA\SqrBundle\Entity\Account $auteurDecision = null)
    {
        $this->auteurDecision = $auteurDecision;

        return $this;
    }

    /**
     * Get auteurDecision
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAuteurDecision()
    {
        return $this->auteurDecision;
    }
}
