<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RelationAffaire
 *
 * @ORM\Table(name="relation_affaire")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\RelationAffaireRepository")
 */
class RelationAffaire
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="relationContribuableInitial")
     * @ORM\JoinColumn(name="fournissseur_relation_in_id", referencedColumnName="id")
     */
    private $fournisseurInitial;

     /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="relationContribuableEnAffaire")
     * @ORM\JoinColumn(name="fournissseur_relation_out_id", referencedColumnName="id")
     */
    private $fournisseurEnAffaire;

    /**
     * @var string
     *
     * @ORM\Column(name="TypeDeRelation", type="string", length=50, nullable=true)
     */
    private $typeDeRelation;

    /**
     * @var int
     *
     * @ORM\Column(name="isAcceptInitial", type="integer", nullable=true)
     */
    private $isAcceptInitial;

    /**
     * @var int
     *
     * @ORM\Column(name="isAcceptFinal", type="integer", nullable=true)
     */
    private $isAcceptFinal;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer", nullable=true)
     */
    private $status;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default 
        $this->isAcceptInitial = 1; // 0= not actif 1 == actif 
        $this->isAcceptFinal = 0; // 0= not actif 1 == actif 
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fournisseur
     *
     * @param integer $fournisseur
     *
     * @return RelationAffaire
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set fournisseurEnAffaire
     *
     * @param integer $fournisseurEnAffaire
     *
     * @return RelationAffaire
     */
    public function setFournisseurEnAffaire($fournisseurEnAffaire)
    {
        $this->fournisseurEnAffaire = $fournisseurEnAffaire;

        return $this;
    }

    /**
     * Get fournisseurEnAffaire
     *
     * @return int
     */
    public function getFournisseurEnAffaire()
    {
        return $this->fournisseurEnAffaire;
    }

    /**
     * Set typeDeRelation
     *
     * @param string $typeDeRelation
     *
     * @return RelationAffaire
     */
    public function setTypeDeRelation($typeDeRelation)
    {
        $this->typeDeRelation = $typeDeRelation;

        return $this;
    }

    /**
     * Get typeDeRelation
     *
     * @return string
     */
    public function getTypeDeRelation()
    {
        return $this->typeDeRelation;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return RelationAffaire
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set fournisseurInitial
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseurInitial
     *
     * @return RelationAffaire
     */
    public function setFournisseurInitial(\AMLA\SqrBundle\Entity\Fournissseur $fournisseurInitial = null)
    {
        $this->fournisseurInitial = $fournisseurInitial;

        return $this;
    }

    /**
     * Get fournisseurInitial
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseurInitial()
    {
        return $this->fournisseurInitial;
    }

    /**
     * Set isAcceptInitial.
     *
     * @param int|null $isAcceptInitial
     *
     * @return RelationAffaire
     */
    public function setIsAcceptInitial($isAcceptInitial = null)
    {
        $this->isAcceptInitial = $isAcceptInitial;

        return $this;
    }

    /**
     * Get isAcceptInitial.
     *
     * @return int|null
     */
    public function getIsAcceptInitial()
    {
        return $this->isAcceptInitial;
    }

    /**
     * Set isAcceptFinal.
     *
     * @param int|null $isAcceptFinal
     *
     * @return RelationAffaire
     */
    public function setIsAcceptFinal($isAcceptFinal = null)
    {
        $this->isAcceptFinal = $isAcceptFinal;

        return $this;
    }

    /**
     * Get isAcceptFinal.
     *
     * @return int|null
     */
    public function getIsAcceptFinal()
    {
        return $this->isAcceptFinal;
    }

    /**
     * Set status.
     *
     * @param int|null $status
     *
     * @return RelationAffaire
     */
    public function setStatus($status = null)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status.
     *
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
}
