<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ReceptionTravaux
 *
 * @ORM\Table(name="reception_travaux")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ReceptionTravauxRepository")
 */
class ReceptionTravaux
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

     /**
     * @ORM\ManyToOne(targetEntity="BonCommande", inversedBy="receptiontravaux")
     * @ORM\JoinColumn(name="boncommande_id", referencedColumnName="id")
     */
    private $bonCommande;

    /**
     * @var string
     *
     * @ORM\Column(name="type_reception", type="string", length=255)
     */
    private $typeReception;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=100)
     */
    private $reference;

    /**
     * @var int
     *
     * @ORM\Column(name="pourcentage_reception", type="integer", nullable=true)
     */
    private $pourcentageReception;

    /**
     * @var string
     *
     * @ORM\Column(name="commentaire", type="text", nullable=true)
     */
    private $commentaire;

     /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;
    
    /**
     * @var string
     *
     * @ORM\Column(name="reserve", type="string", length=20, nullable=true)
     */
    private $reserve;

     /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCommission", type="datetime", nullable=true)
     */
    private $dateCommission;

    /**
     * @var string
     *
     * @ORM\Column(name="memberList", type="text", nullable=true)
     */
    private $memberList;
    
    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @ORM\OneToMany(targetEntity="Facture", mappedBy="receptionTravaux")
     */
    private $facture;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="receptionTravaux")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var string
     *
     * @ORM\Column(name="pv_reception", type="string", length=150, nullable=true)
     */
    private $pvReception;

    /**
     * @var string
     *
     * @ORM\Column(name="pv_travaux", type="string", length=150, nullable=true)
     */
    private $pvTravaux;

    function __construct(){
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0; // 0=Reception Crée// 1 Reception Validée // 2 Facture generée // 3 Reception rejeté
        $this->pourcentageReception = 0;
        $this->reference = 'RCPT_'.$this->randomString();
    }

    
    /*
     * Create a random string
     * @author	Cedric Rio
     * @param $length the length of the string to create
     * @return $str the string
     */
    function randomString($length = 3)
    {
        $str = "";
        //$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
        $characters = array_merge(range('A','Z'), range('0','9'));
        $max = count($characters) - 1;

        date_default_timezone_set('Africa/Douala');
        $date = date('hiy', time());

        for ($i = 0; $i < $length; $i++)
        {
            $rand = mt_rand(0, $max);
            $str .= $characters[$rand];
        }
        $codeUnique=$str.''.$date;
        return $codeUnique;
    }
    
    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set bonCommande
     *
     * @param string $bonCommande
     *
     * @return ReceptionTravaux
     */
    public function setBonCommande($bonCommande)
    {
        $this->bonCommande = $bonCommande;

        return $this;
    }

    /**
     * Get bonCommande
     *
     * @return string
     */
    public function getBonCommande()
    {
        return $this->bonCommande;
    }

    /**
     * Set typeReception
     *
     * @param string $typeReception
     *
     * @return ReceptionTravaux
     */
    public function setTypeReception($typeReception)
    {
        $this->typeReception = $typeReception;

        return $this;
    }

    /**
     * Get typeReception
     *
     * @return string
     */
    public function getTypeReception()
    {
        return $this->typeReception;
    }

    /**
     * Set pourcentageReception
     *
     * @param integer $pourcentageReception
     *
     * @return ReceptionTravaux
     */
    public function setPourcentageReception($pourcentageReception)
    {
        $this->pourcentageReception = $pourcentageReception;

        return $this;
    }

    /**
     * Get pourcentageReception
     *
     * @return integer
     */
    public function getPourcentageReception()
    {
        return $this->pourcentageReception;
    }

    /**
     * Set commentaire
     *
     * @param string $commentaire
     *
     * @return ReceptionTravaux
     */
    public function setCommentaire($commentaire)
    {
        $this->commentaire = $commentaire;

        return $this;
    }

    /**
     * Get commentaire
     *
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return ReceptionTravaux
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return ReceptionTravaux
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set reserve
     *
     * @param integer $reserve
     *
     * @return ReceptionTravaux
     */
    public function setReserve($reserve)
    {
        $this->reserve = $reserve;

        return $this;
    }

    /**
     * Get reserve
     *
     * @return integer
     */
    public function getReserve()
    {
        return $this->reserve;
    }

    /**
     * Add facture
     *
     * @param \AMLA\SqrBundle\Entity\Facture $facture
     *
     * @return ReceptionTravaux
     */
    public function addFacture(\AMLA\SqrBundle\Entity\Facture $facture)
    {
        $this->facture[] = $facture;

        return $this;
    }

    /**
     * Remove facture
     *
     * @param \AMLA\SqrBundle\Entity\Facture $facture
     */
    public function removeFacture(\AMLA\SqrBundle\Entity\Facture $facture)
    {
        $this->facture->removeElement($facture);
    }

    /**
     * Get facture
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFacture()
    {
        return $this->facture;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return ReceptionTravaux
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set dateCommission
     *
     * @param \DateTime $dateCommission
     *
     * @return ReceptionTravaux
     */
    public function setDateCommission($dateCommission)
    {
        $this->dateCommission = $dateCommission;

        return $this;
    }

    /**
     * Get dateCommission
     *
     * @return \DateTime
     */
    public function getDateCommission()
    {
        return $this->dateCommission;
    }

    /**
     * Set memberList
     *
     * @param string $memberList
     *
     * @return ReceptionTravaux
     */
    public function setMemberList($memberList)
    {
        $this->memberList = $memberList;

        return $this;
    }

    /**
     * Get memberList
     *
     * @return string
     */
    public function getMemberList()
    {
        return $this->memberList;
    }

    /**
     * Set pdf
     *
     * @param string $pdf
     *
     * @return ReceptionTravaux
     */
    public function setPdf($pdf)
    {
        $this->pdf = $pdf;

        return $this;
    }

    /**
     * Get pdf
     *
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return ReceptionTravaux
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set pvReception
     *
     * @param string $pvReception
     *
     * @return ReceptionTravaux
     */
    public function setPvReception($pvReception)
    {
        $this->pvReception = $pvReception;

        return $this;
    }

    /**
     * Get pvReception
     *
     * @return string
     */
    public function getPvReception()
    {
        return $this->pvReception;
    }

    /**
     * Set pvTravaux
     *
     * @param string $pvTravaux
     *
     * @return ReceptionTravaux
     */
    public function setPvTravaux($pvTravaux)
    {
        $this->pvTravaux = $pvTravaux;

        return $this;
    }

    /**
     * Get pvTravaux
     *
     * @return string
     */
    public function getPvTravaux()
    {
        return $this->pvTravaux;
    }
}
