<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Quittance
 *
 * @ORM\Table(name="quittance")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\QuittanceRepository")
 */
class Quittance
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
    
    /**
     * @var bool
     *
     * @ORM\Column(name="is_secured", type="boolean", nullable=true)
     */
    private $isSecured; //1=reporté 0 = new

    /**
     * @var float
     *
     * @ORM\Column(name="montant", type="float")
     */
    private $montant;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="quittance")
     * @ORM\JoinColumn(name="qrcode_transaction_number_id", referencedColumnName="id")
     */
    private $transactionNumber;

    /**
     * @ORM\ManyToOne(targetEntity="FactureSpontane", inversedBy="quittance")
     * @ORM\JoinColumn(name="facture_spontane_id", referencedColumnName="id")
     */
    private $factureSpontane;    

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="quittance")
     * @ORM\JoinColumn(name="account_sender_id", referencedColumnName="id")
     */
    private $sender;
    

    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=255)
     */
    private $pdf;

    /**
     * @var string
     *
     * @ORM\Column(name="reason", type="text", nullable=true)
     */
    private $reason;

    /**
     * @var string
     *
     * @ORM\Column(name="phoneNumber", type="string", length=20, nullable=true)
     */
    private $phoneNumber;

    /**
     * @var string
     *
     * @ORM\Column(name="montantLettre", type="text", nullable=true)
     */
    private $montantLettre;

    /**
     * @var string
     *
     * @ORM\Column(name="placeCreated", type="string", length=255, nullable=true)
     */
    private $placeCreated;

    /**
     * @var string
     *
     * @ORM\Column(name="receiverNiu", type="string", length=50, nullable=true)
     */
    private $receiverNiu;

    /**
     * @var string
     *
     * @ORM\Column(name="receiverSqrId", type="string", length=50, nullable=true)
     */
    private $receiverSqrId;

    /**
     * @var string
     *
     * @ORM\Column(name="receiverEmail", type="string", length=50, nullable=true)
     */
    private $receiverEmail;

    /**
     * @var string
     *
     * @ORM\Column(name="receiverSocialReason", type="string", length=255, nullable=true)
     */
    private $receiverSocialReason;

    /**
     * @var string
     *
     * @ORM\Column(name="receiptNumber", type="string", length=255, nullable=true)
     */
    private $receiptNumber;

    /**
     * @ORM\OneToMany(targetEntity="Fine", mappedBy="quittance")
    */
    private $fine;

    /**
     * @ORM\OneToMany(targetEntity="Service", mappedBy="quittance")
    */
    private $service;

    /**
     * @var string
     *
     * @ORM\Column(name="modeReglement", type="string", length=20, length=20, nullable=true)
     */
    private $modeReglement;// ESPECE momo

    /**
     * @var string
     *
     * @ORM\Column(name="telephoneMomoReglement", type="string", length=20, nullable=true)
     */
    private $telephoneMomoReglement;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=255, nullable=true)
     */
    private $reference;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->fine = new \Doctrine\Common\Collections\ArrayCollection();
        $this->service = new \Doctrine\Common\Collections\ArrayCollection();
        $this->reason="N/A";
        $this->reference="N/A";
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set montant
     *
     * @param float $montant
     *
     * @return Quittance
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return float
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set transactionNumber
     *
     * @param integer $transactionNumber
     *
     * @return Quittance
     */
    public function setTransactionNumber($transactionNumber)
    {
        $this->transactionNumber = $transactionNumber;

        return $this;
    }

    /**
     * Get transactionNumber
     *
     * @return integer
     */
    public function getTransactionNumber()
    {
        return $this->transactionNumber;
    }

    /**
     * Set sender
     *
     * @param integer $sender
     *
     * @return Quittance
     */
    public function setSender($sender)
    {
        $this->sender = $sender;

        return $this;
    }

    /**
     * Get sender
     *
     * @return integer
     */
    public function getSender()
    {
        return $this->sender;
    }

    /**
     * Set reason
     *
     * @param string $reason
     *
     * @return Quittance
     */
    public function setReason($reason)
    {
        $this->reason = $reason;

        return $this;
    }

    /**
     * Get reason
     *
     * @return string
     */
    public function getReason()
    {
        return $this->reason;
    }

    /**
     * Set phoneNumber
     *
     * @param string $phoneNumber
     *
     * @return Quittance
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;

        return $this;
    }

    /**
     * Get phoneNumber
     *
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }

    /**
     * Set montantLettre
     *
     * @param string $montantLettre
     *
     * @return Quittance
     */
    public function setMontantLettre($montantLettre)
    {
        $this->montantLettre = $montantLettre;

        return $this;
    }

    /**
     * Get montantLettre
     *
     * @return string
     */
    public function getMontantLettre()
    {
        return $this->montantLettre;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Quittance
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set placeCreated
     *
     * @param string $placeCreated
     *
     * @return Quittance
     */
    public function setPlaceCreated($placeCreated)
    {
        $this->placeCreated = $placeCreated;

        return $this;
    }

    /**
     * Get placeCreated
     *
     * @return string
     */
    public function getPlaceCreated()
    {
        return $this->placeCreated;
    }

    /**
     * Set receiverNiu
     *
     * @param string $receiverNiu
     *
     * @return Quittance
     */
    public function setReceiverNiu($receiverNiu)
    {
        $this->receiverNiu = $receiverNiu;

        return $this;
    }

    /**
     * Get receiverNiu
     *
     * @return string
     */
    public function getReceiverNiu()
    {
        return $this->receiverNiu;
    }

    /**
     * Set receiptNumber
     *
     * @param string $receiptNumber
     *
     * @return Quittance
     */
    public function setReceiptNumber($receiptNumber)
    {
        $this->receiptNumber = $receiptNumber;

        return $this;
    }

    /**
     * Get receiptNumber
     *
     * @return string
     */
    public function getReceiptNumber()
    {
        return $this->receiptNumber;
    }

    /**
     * Add fine
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fine
     *
     * @return Quittance
     */
    public function addFine(\AMLA\SqrBundle\Entity\Fine $fine)
    {
        $this->fine[] = $fine;

        return $this;
    }

    /**
     * Remove fine
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fine
     */
    public function removeFine(\AMLA\SqrBundle\Entity\Fine $fine)
    {
        $this->fine->removeElement($fine);
    }

    /**
     * Get fine
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFine()
    {
        return $this->fine;
    }

    /**
     * Add service
     *
     * @param \AMLA\SqrBundle\Entity\Service $service
     *
     * @return Quittance
     */
    public function addService(\AMLA\SqrBundle\Entity\Service $service)
    {
        $this->service[] = $service;

        return $this;
    }

    /**
     * Remove service
     *
     * @param \AMLA\SqrBundle\Entity\Service $service
     */
    public function removeService(\AMLA\SqrBundle\Entity\Service $service)
    {
        $this->service->removeElement($service);
    }

    /**
     * Get service
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * Set modeReglement
     *
     * @param string $modeReglement
     *
     * @return Quittance
     */
    public function setModeReglement($modeReglement)
    {
        $this->modeReglement = $modeReglement;

        return $this;
    }

    /**
     * Get modeReglement
     *
     * @return string
     */
    public function getModeReglement()
    {
        return $this->modeReglement;
    }

    /**
     * Set telephoneMomoReglement
     *
     * @param string $telephoneMomoReglement
     *
     * @return Quittance
     */
    public function setTelephoneMomoReglement($telephoneMomoReglement)
    {
        $this->telephoneMomoReglement = $telephoneMomoReglement;

        return $this;
    }

    /**
     * Get telephoneMomoReglement
     *
     * @return string
     */
    public function getTelephoneMomoReglement()
    {
        return $this->telephoneMomoReglement;
    }

    /**
     * Set isSecured
     *
     * @param boolean $isSecured
     *
     * @return Quittance
     */
    public function setIsSecured($isSecured)
    {
        $this->isSecured = $isSecured;

        return $this;
    }

    /**
     * Get isSecured
     *
     * @return boolean
     */
    public function getIsSecured()
    {
        return $this->isSecured;
    }

    /**
     * Set factureSpontane
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return Quittance
     */
    public function setFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane = null)
    {
        $this->factureSpontane = $factureSpontane;

        return $this;
    }

    /**
     * Get factureSpontane
     *
     * @return \AMLA\SqrBundle\Entity\FactureSpontane
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return Quittance
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set pdf
     *
     * @param string $pdf
     *
     * @return Quittance
     */
    public function setPdf($pdf)
    {
        $this->pdf = $pdf;

        return $this;
    }

    /**
     * Get pdf
     *
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * Set receiverSqrId.
     *
     * @param string $receiverSqrId
     *
     * @return Quittance
     */
    public function setReceiverSqrId($receiverSqrId)
    {
        $this->receiverSqrId = $receiverSqrId;

        return $this;
    }

    /**
     * Get receiverSqrId.
     *
     * @return string
     */
    public function getReceiverSqrId()
    {
        return $this->receiverSqrId;
    }

    /**
     * Set receiverEmail.
     *
     * @param string $receiverEmail
     *
     * @return Quittance
     */
    public function setReceiverEmail($receiverEmail)
    {
        $this->receiverEmail = $receiverEmail;

        return $this;
    }

    /**
     * Get receiverEmail.
     *
     * @return string
     */
    public function getReceiverEmail()
    {
        return $this->receiverEmail;
    }

    /**
     * Set receiverSocialReason.
     *
     * @param string|null $receiverSocialReason
     *
     * @return Quittance
     */
    public function setReceiverSocialReason($receiverSocialReason = null)
    {
        $this->receiverSocialReason = $receiverSocialReason;

        return $this;
    }

    /**
     * Get receiverSocialReason.
     *
     * @return string|null
     */
    public function getReceiverSocialReason()
    {
        return $this->receiverSocialReason;
    }
}
