<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Preselection
 *
 * @ORM\Table(name="preselection")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\PreselectionRepository")
 */
class Preselection
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Offre", inversedBy="preselection")
     * @ORM\JoinColumn(name="offre_id", referencedColumnName="id")
     */
    private $offre;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="preselection")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

     /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    public function __construct()
    {
        date_default_timezone_set( 'Africa/Douala' );
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 1;
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return Preselection
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Preselection
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set offre
     *
     * @param \AMLA\SqrBundle\Entity\Offre $offre
     *
     * @return Preselection
     */
    public function setOffre(\AMLA\SqrBundle\Entity\Offre $offre = null)
    {
        $this->offre = $offre;

        return $this;
    }

    /**
     * Get offre
     *
     * @return \AMLA\SqrBundle\Entity\Offre
     */
    public function getOffre()
    {
        return $this->offre;
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return Preselection
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }
}
