<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PlanifierPaiement
 *
 * @ORM\Table(name="planifier_paiement")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\PlanifierPaiementRepository")
 */
class PlanifierPaiement
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="datePaiement", type="datetime")
     */
    private $datePaiement;

    /**
     * @var float
     *
     * @ORM\Column(name="montant", type="float")
     */
    private $montant;

    /**
     * @var int
     *
     * @ORM\Column(name="facture", type="integer")
     */
    private $facture;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\ManyToOne(targetEntity="FactureSpontane", inversedBy="planifierPaiement")
     * @ORM\JoinColumn(name="facture_spontane_id", referencedColumnName="id")
     */
    private $factureSpontane;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="planifierPaiement")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set datePaiement
     *
     * @param \DateTime $datePaiement
     *
     * @return PlanifierPaiement
     */
    public function setDatePaiement($datePaiement)
    {
        $this->datePaiement = $datePaiement;

        return $this;
    }

    /**
     * Get datePaiement
     *
     * @return \DateTime
     */
    public function getDatePaiement()
    {
        return $this->datePaiement;
    }

    /**
     * Set montant
     *
     * @param float $montant
     *
     * @return PlanifierPaiement
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return float
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set facture
     *
     * @param integer $facture
     *
     * @return PlanifierPaiement
     */
    public function setFacture($facture)
    {
        $this->facture = $facture;

        return $this;
    }

    /**
     * Get facture
     *
     * @return integer
     */
    public function getFacture()
    {
        return $this->facture;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return PlanifierPaiement
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set factureSpontane
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return PlanifierPaiement
     */
    public function setFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane = null)
    {
        $this->factureSpontane = $factureSpontane;

        return $this;
    }

    /**
     * Get factureSpontane
     *
     * @return \AMLA\SqrBundle\Entity\FactureSpontane
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }

    /**
     * Set account.
     *
     * @param \AMLA\SqrBundle\Entity\Account|null $account
     *
     * @return PlanifierPaiement
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account.
     *
     * @return \AMLA\SqrBundle\Entity\Account|null
     */
    public function getAccount()
    {
        return $this->account;
    }
}
