<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * OrganismeFinancement
 *
 * @ORM\Table(name="organisme_financement")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\OrganismeFinancementRepository")
 */
class OrganismeFinancement
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="idorganisme", type="string", length=255)
     */
    private $idorganisme;

    /**
     * @var string
     *
     * @ORM\Column(name="libelle", type="string", length=255)
     */
    private $libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="sigle", type="string", length=255)
     */
    private $sigle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="Contrat", mappedBy="idOrganismeFinancement")
     */
    private $contrat;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
    }



    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idorganisme
     *
     * @param string $idorganisme
     *
     * @return OrganismeFinancement
     */
    public function setIdorganisme($idorganisme)
    {
        $this->idorganisme = $idorganisme;

        return $this;
    }

    /**
     * Get idorganisme
     *
     * @return string
     */
    public function getIdorganisme()
    {
        return $this->idorganisme;
    }

    /**
     * Set libelle
     *
     * @param string $libelle
     *
     * @return OrganismeFinancement
     */
    public function setLibelle($libelle)
    {
        $this->libelle = $libelle;

        return $this;
    }

    /**
     * Get libelle
     *
     * @return string
     */
    public function getLibelle()
    {
        return $this->libelle;
    }

    /**
     * Set sigle
     *
     * @param string $sigle
     *
     * @return OrganismeFinancement
     */
    public function setSigle($sigle)
    {
        $this->sigle = $sigle;

        return $this;
    }

    /**
     * Get sigle
     *
     * @return string
     */
    public function getSigle()
    {
        return $this->sigle;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return OrganismeFinancement
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Add contrat
     *
     * @param \AMLA\SqrBundle\Entity\Contrat $contrat
     *
     * @return OrganismeFinancement
     */
    public function addContrat(\AMLA\SqrBundle\Entity\Contrat $contrat)
    {
        $this->contrat[] = $contrat;

        return $this;
    }

    /**
     * Remove contrat
     *
     * @param \AMLA\SqrBundle\Entity\Contrat $contrat
     */
    public function removeContrat(\AMLA\SqrBundle\Entity\Contrat $contrat)
    {
        $this->contrat->removeElement($contrat);
    }

    /**
     * Get contrat
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getContrat()
    {
        return $this->contrat;
    }
}
