<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * OperateurConformiteCategoryElement
 *
 * @ORM\Table(name="operateur_conformite_category_element")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\OperateurConformiteCategoryElementRepository")
 */
class OperateurConformiteCategoryElement
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="sigle", type="string", length=255)
     */
    private $sigle;

    /**
     * @ORM\ManyToOne(targetEntity="OperateurConformiteCategory", inversedBy="operateurConformiteCategoryElement")
     * @ORM\JoinColumn(name="operateur_conformite_category_id", referencedColumnName="id")
     */
    private $operateurConformiteCategory;
 
    /**
     * @ORM\OneToMany(targetEntity="Conformite", mappedBy="operateurConformiteCategoryElement")
     */
    private $conformite;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return OperateurConformiteCategoryElement
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set operateurConformiteCategory
     *
     * @param integer $operateurConformiteCategory
     *
     * @return OperateurConformiteCategoryElement
     */
    public function setOperateurConformiteCategory($operateurConformiteCategory)
    {
        $this->operateurConformiteCategory = $operateurConformiteCategory;

        return $this;
    }

    /**
     * Get operateurConformiteCategory
     *
     * @return int
     */
    public function getOperateurConformiteCategory()
    {
        return $this->operateurConformiteCategory;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->conformite = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add conformite
     *
     * @param \AMLA\SqrBundle\Entity\Conformite $conformite
     *
     * @return OperateurConformiteCategoryElement
     */
    public function addConformite(\AMLA\SqrBundle\Entity\Conformite $conformite)
    {
        $this->conformite[] = $conformite;

        return $this;
    }

    /**
     * Remove conformite
     *
     * @param \AMLA\SqrBundle\Entity\Conformite $conformite
     */
    public function removeConformite(\AMLA\SqrBundle\Entity\Conformite $conformite)
    {
        $this->conformite->removeElement($conformite);
    }

    /**
     * Get conformite
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getConformite()
    {
        return $this->conformite;
    }

    /**
     * Set sigle
     *
     * @param string $sigle
     *
     * @return OperateurConformiteCategoryElement
     */
    public function setSigle($sigle)
    {
        $this->sigle = $sigle;

        return $this;
    }

    /**
     * Get sigle
     *
     * @return string
     */
    public function getSigle()
    {
        return $this->sigle;
    }
}
