<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * OperateurConformiteCategory
 *
 * @ORM\Table(name="operateur_conformite_category")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\OperateurConformiteCategoryRepository")
 */
class OperateurConformiteCategory
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="Conformite", mappedBy="operateurConformiteCategory")
     */
    private $conformite;

    /**
     * @ORM\OneToMany(targetEntity="OperateurConformiteCategoryElement", mappedBy="operateurConformiteCategory")
     */
    private $operateurConformiteCategoryElement;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return OperateurConformiteCategory
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->conformite = new \Doctrine\Common\Collections\ArrayCollection();
        $this->operateurConformiteCategoryElement = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Add conformite
     *
     * @param \AMLA\SqrBundle\Entity\Conformite $conformite
     *
     * @return OperateurConformiteCategory
     */
    public function addConformite(\AMLA\SqrBundle\Entity\Conformite $conformite)
    {
        $this->conformite[] = $conformite;

        return $this;
    }

    /**
     * Remove conformite
     *
     * @param \AMLA\SqrBundle\Entity\Conformite $conformite
     */
    public function removeConformite(\AMLA\SqrBundle\Entity\Conformite $conformite)
    {
        $this->conformite->removeElement($conformite);
    }

    /**
     * Get conformite
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getConformite()
    {
        return $this->conformite;
    }

    /**
     * Add operateurConformiteCategoryElement
     *
     * @param \AMLA\SqrBundle\Entity\operateurConformiteCategoryElement $operateurConformiteCategoryElement
     *
     * @return OperateurConformiteCategory
     */
    public function addOperateurConformiteCategoryElement(\AMLA\SqrBundle\Entity\operateurConformiteCategoryElement $operateurConformiteCategoryElement)
    {
        $this->operateurConformiteCategoryElement[] = $operateurConformiteCategoryElement;

        return $this;
    }

    /**
     * Remove operateurConformiteCategoryElement
     *
     * @param \AMLA\SqrBundle\Entity\operateurConformiteCategoryElement $operateurConformiteCategoryElement
     */
    public function removeOperateurConformiteCategoryElement(\AMLA\SqrBundle\Entity\operateurConformiteCategoryElement $operateurConformiteCategoryElement)
    {
        $this->operateurConformiteCategoryElement->removeElement($operateurConformiteCategoryElement);
    }

    /**
     * Get operateurConformiteCategoryElement
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOperateurConformiteCategoryElement()
    {
        return $this->operateurConformiteCategoryElement;
    }
}
