<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * OffreFournisseur
 *
 * @ORM\Table(name="offre_fournisseur")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\OffreFournisseurRepository")
 */
class OffreFournisseur
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /** 
     * @ORM\ManyToOne(targetEntity="Offre", inversedBy="offrefournisseur", cascade={"persist"})
     * @ORM\JoinColumn(name="offre_id", referencedColumnName="id")
     */
    private $offre;

    /** 
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="offrefournisseur", cascade={"persist"})
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="offrefournisseurSpon", cascade={"persist"})
     * @ORM\JoinColumn(name="fournisseur_spon_id", referencedColumnName="id", nullable=true)
     */
    private $fournisseurSpon;
    
    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return OffreFournisseur
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return int
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return OffreFournisseur
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set offre
     *
     * @param \AMLA\SqrBundle\Entity\Offre $offre
     *
     * @return OffreFournisseur
     */
    public function setOffre(\AMLA\SqrBundle\Entity\Offre $offre = null)
    {
        $this->offre = $offre;

        return $this;
    }

    /**
     * Get offre
     *
     * @return \AMLA\SqrBundle\Entity\Offre
     */
    public function getOffre()
    {
        return $this->offre;
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return OffreFournisseur
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set fournisseurSpon
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseurSpon
     *
     * @return OffreFournisseur
     */
    public function setFournisseurSpon(\AMLA\SqrBundle\Entity\Fournissseur $fournisseurSpon = null)
    {
        $this->fournisseurSpon = $fournisseurSpon;

        return $this;
    }

    /**
     * Get fournisseurSpon
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseurSpon()
    {
        return $this->fournisseurSpon;
    }
}
