<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Offre
 *
 * @ORM\Table(name="offre")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\OffreRepository")
 */
class Offre
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="offre")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @var string
     *
     * @ORM\Column(name="objet", type="string", length=255)
     */
    private $objet;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=255)
     */
    private $reference;

    /**
     * @ORM\ManyToOne(targetEntity="Categorie", inversedBy="offre")
     * @ORM\JoinColumn(name="categorie_id", referencedColumnName="id")
     */
    private $categorie;


    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="offre")
     */
    private $cahierCharge;

    /**
     * @var int
     *
     * @ORM\Column(name="prix", type="integer",nullable=true)
     */
    private $prix;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_offre", type="string", length=100)
     */
    private $numeroOffre;

    /**
     * @ORM\OneToMany(targetEntity="SoummissionOffre", mappedBy="offre")
     */
    private $soumissionoffre;

    /**
     * @ORM\OneToMany(targetEntity="OffreFournisseur", mappedBy="offre")
     */
    private $offrefournisseur;

    /**
     * @ORM\OneToMany(targetEntity="Preselection", mappedBy="offre")
     */
    private $preselection;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_publication", type="datetime")
     */
    private $datePublication;

    /**
     * @var boolean
     *
     * @ORM\Column(name="restreint", type="smallint")
     */
    private $restreint;


    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     * {0 = non publié, 1 = en cours}
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_limite", type="datetime")
     */
    private $dateLimite;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->dateLimite = new \Datetime('+2day'); // default date
        $this->numeroOffre = $this->randomString();
        $this->statut = 0;
    }

    /*
     * Create a random string
     * @author	Cedric Rio
     * @param $length the length of the string to create
     * @return $str the string
     */
    function randomString($length = 3)
    {
        $str = "";
        //$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
        $characters = array_merge(range('A','Z'), range('0','9'));
        $max = count($characters) - 1;

        date_default_timezone_set('Africa/Douala');
        $date = date('hiy', time());

        for ($i = 0; $i < $length; $i++)
        {
            $rand = mt_rand(0, $max);
            $str .= $characters[$rand];
        }
        $codeUnique=$str.''.$date;
        return $codeUnique;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fournisseur
     *
     * @param integer $fournisseur
     *
     * @return Offre
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Offre
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set numeroOffre
     *
     * @param string $numeroOffre
     *
     * @return Offre
     */
    public function setNumeroOffre($numeroOffre)
    {
        $this->numeroOffre = $numeroOffre;

        return $this;
    }

    /**
     * Get numeroOffre
     *
     * @return string
     */
    public function getNumeroOffre()
    {
        return $this->numeroOffre;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Offre
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set objet
     *
     * @param string $objet
     *
     * @return Offre
     */
    public function setObjet($objet)
    {
        $this->objet = $objet;

        return $this;
    }

    /**
     * Get objet
     *
     * @return string
     */
    public function getObjet()
    {
        return $this->objet;
    }

    /**
     * Add soumissionoffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre
     *
     * @return Offre
     */
    public function addSoumissionoffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre)
    {
        $this->soumissionoffre[] = $soumissionoffre;

        return $this;
    }

    /**
     * Remove soumissionoffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre
     */
    public function removeSoumissionoffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre)
    {
        $this->soumissionoffre->removeElement($soumissionoffre);
    }

    /**
     * Get soumissionoffre
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSoumissionoffre()
    {
        return $this->soumissionoffre;
    }

    /**
     * Set dateLimite
     *
     * @param \DateTime $dateLimite
     *
     * @return Offre
     */
    public function setDateLimite($dateLimite)
    {
        $this->dateLimite = $dateLimite;

        return $this;
    }

    /**
     * Get dateLimite
     *
     * @return \DateTime
     */
    public function getDateLimite()
    {
        return $this->dateLimite;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return Offre
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Add preselection
     *
     * @param \AMLA\SqrBundle\Entity\Preselection $preselection
     *
     * @return Offre
     */
    public function addPreselection(\AMLA\SqrBundle\Entity\Preselection $preselection)
    {
        $this->preselection[] = $preselection;

        return $this;
    }

    /**
     * Remove preselection
     *
     * @param \AMLA\SqrBundle\Entity\Preselection $preselection
     */
    public function removePreselection(\AMLA\SqrBundle\Entity\Preselection $preselection)
    {
        $this->preselection->removeElement($preselection);
    }

    /**
     * Get preselection
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPreselection()
    {
        return $this->preselection;
    }

    /**
     * Set libelleMarche
     *
     * @param string $libelleMarche
     *
     * @return Offre
     */
    public function setLibelleMarche($libelleMarche)
    {
        $this->libelleMarche = $libelleMarche;

        return $this;
    }

    /**
     * Get libelleMarche
     *
     * @return string
     */
    public function getLibelleMarche()
    {
        return $this->libelleMarche;
    }

    /**
     * Set termeReference
     *
     * @param string $termeReference
     *
     * @return Offre
     */
    public function setTermeReference($termeReference)
    {
        $this->termeReference = $termeReference;

        return $this;
    }

    /**
     * Get termeReference
     *
     * @return string
     */
    public function getTermeReference()
    {
        return $this->termeReference;
    }

    /**
     * Set termePaiement
     *
     * @param string $termePaiement
     *
     * @return Offre
     */
    public function setTermePaiement($termePaiement)
    {
        $this->termePaiement = $termePaiement;

        return $this;
    }

    /**
     * Get termePaiement
     *
     * @return string
     */
    public function getTermePaiement()
    {
        return $this->termePaiement;
    }

    /**
     * Set prix
     *
     * @param integer $prix
     *
     * @return Offre
     */
    public function setPrix($prix)
    {
        $this->prix = $prix;

        return $this;
    }

    /**
     * Get prix
     *
     * @return integer
     */
    public function getPrix()
    {
        return $this->prix;
    }

    /**
     * Set datePublication
     *
     * @param \DateTime $datePublication
     *
     * @return Offre
     */
    public function setDatePublication($datePublication)
    {
        $this->datePublication = $datePublication;

        return $this;
    }

    /**
     * Get datePublication
     *
     * @return \DateTime
     */
    public function getDatePublication()
    {
        return $this->datePublication;
    }

    /**
     * Set ouvert
     *
     * @param integer $ouvert
     *
     * @return Offre
     */
    public function setOuvert($ouvert)
    {
        $this->ouvert = $ouvert;

        return $this;
    }

    /**
     * Get ouvert
     *
     * @return integer
     */
    public function getOuvert()
    {
        return $this->ouvert;
    }

    /**
     * Set cautionnement
     *
     * @param integer $cautionnement
     *
     * @return Offre
     */
    public function setCautionnement($cautionnement)
    {
        $this->cautionnement = $cautionnement;

        return $this;
    }

    /**
     * Get cautionnement
     *
     * @return integer
     */
    public function getCautionnement()
    {
        return $this->cautionnement;
    }

    /**
     * Set prixCautionnement
     *
     * @param integer $prixCautionnement
     *
     * @return Offre
     */
    public function setPrixCautionnement($prixCautionnement)
    {
        $this->prixCautionnement = $prixCautionnement;

        return $this;
    }

    /**
     * Get prixCautionnement
     *
     * @return integer
     */
    public function getPrixCautionnement()
    {
        return $this->prixCautionnement;
    }

    /**
     * Add cahierCharge
     *
     * @param \AMLA\SqrBundle\Entity\Document $cahierCharge
     *
     * @return Offre
     */
    public function addCahierCharge(\AMLA\SqrBundle\Entity\Document $cahierCharge)
    {
        $this->cahierCharge[] = $cahierCharge;

        return $this;
    }

    /**
     * Remove cahierCharge
     *
     * @param \AMLA\SqrBundle\Entity\Document $cahierCharge
     */
    public function removeCahierCharge(\AMLA\SqrBundle\Entity\Document $cahierCharge)
    {
        $this->cahierCharge->removeElement($cahierCharge);
    }

    /**
     * Get cahierCharge
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCahierCharge()
    {
        return $this->cahierCharge;
    }

    /**
     * Add offrefournisseur
     *
     * @param \AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseur
     *
     * @return Offre
     */
    public function addOffrefournisseur(\AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseur)
    {
        $this->offrefournisseur[] = $offrefournisseur;

        return $this;
    }

    /**
     * Remove offrefournisseur
     *
     * @param \AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseur
     */
    public function removeOffrefournisseur(\AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseur)
    {
        $this->offrefournisseur->removeElement($offrefournisseur);
    }

    /**
     * Get offrefournisseur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOffrefournisseur()
    {
        return $this->offrefournisseur;
    }

    /**
     * Set categorie
     *
     * @param \AMLA\SqrBundle\Entity\Categorie $categorie
     *
     * @return Offre
     */
    public function setCategorie(\AMLA\SqrBundle\Entity\Categorie $categorie = null)
    {
        $this->categorie = $categorie;

        return $this;
    }

    /**
     * Get categorie
     *
     * @return \AMLA\SqrBundle\Entity\Categorie
     */
    public function getCategorie()
    {
        return $this->categorie;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return Offre
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set restreint
     *
     * @param integer $restreint
     *
     * @return Offre
     */
    public function setRestreint($restreint)
    {
        $this->restreint = $restreint;

        return $this;
    }

    /**
     * Get restreint
     *
     * @return integer
     */
    public function getRestreint()
    {
        return $this->restreint;
    }
}
