<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * NoteAvoir
 *
 * @ORM\Table(name="note_avoir")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\NoteAvoirRepository")
 */
class NoteAvoir
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="noteAvoirEmetteur")
     * @ORM\JoinColumn(name="fournisseur_emetteur_id", referencedColumnName="id")
     */
    private $fournisseurEmetteur;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="noteAvoirRecepteur")
     * @ORM\JoinColumn(name="fournisseur_recepteur_id", referencedColumnName="id")
     */
    private $fournisseurRecepteur;

    /**
     * @var int
     *
     * @ORM\Column(name="referenceFacture", type="integer")
     */
    private $referenceFacture;

    /**
     * @var float
     *
     * @ORM\Column(name="montant", type="float")
     */
    private $montant;

    /**
     * @var string
     *
     * @ORM\Column(name="commentaire", type="text")
     */
    private $commentaire;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="noteAvoir")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var int
     *
     * @ORM\Column(name="typeFacture", type="integer")
     */
    private $typeFacture; //1= Facture Simple 2=facture integré

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;//1=non traité 1 traité
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set referenceFacture
     *
     * @param integer $referenceFacture
     *
     * @return NoteAvoir
     */
    public function setReferenceFacture($referenceFacture)
    {
        $this->referenceFacture = $referenceFacture;

        return $this;
    }

    /**
     * Get referenceFacture
     *
     * @return integer
     */
    public function getReferenceFacture()
    {
        return $this->referenceFacture;
    }

    /**
     * Set montant
     *
     * @param float $montant
     *
     * @return NoteAvoir
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return float
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set commentaire
     *
     * @param string $commentaire
     *
     * @return NoteAvoir
     */
    public function setCommentaire($commentaire)
    {
        $this->commentaire = $commentaire;

        return $this;
    }


    /**
     * Get commentaire
     *
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * Set typeFacture
     *
     * @param integer $typeFacture
     *
     * @return NoteAvoir
     */
    public function setTypeFacture($typeFacture)
    {
        $this->typeFacture = $typeFacture;

        return $this;
    }

    /**
     * Get typeFacture
     *
     * @return integer
     */
    public function getTypeFacture()
    {
        return $this->typeFacture;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return NoteAvoir
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return NoteAvoir
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set fournisseurEmetteur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseurEmetteur
     *
     * @return NoteAvoir
     */
    public function setFournisseurEmetteur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseurEmetteur = null)
    {
        $this->fournisseurEmetteur = $fournisseurEmetteur;

        return $this;
    }

    /**
     * Get fournisseurEmetteur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseurEmetteur()
    {
        return $this->fournisseurEmetteur;
    }

    /**
     * Set fournisseurRecepteur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseurRecepteur
     *
     * @return NoteAvoir
     */
    public function setFournisseurRecepteur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseurRecepteur = null)
    {
        $this->fournisseurRecepteur = $fournisseurRecepteur;

        return $this;
    }

    /**
     * Get fournisseurRecepteur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseurRecepteur()
    {
        return $this->fournisseurRecepteur;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return NoteAvoir
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }
}
