<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * MouvementAtd
 *
 * @ORM\Table(name="mouvement_atd")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\MouvementAtdRepository")
 */
class MouvementAtd
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /** 
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="atdemeteur")
     * @ORM\JoinColumn(name="emeteur_id", referencedColumnName="id")
     */
    private $emetteur;

     /** 
     * @ORM\ManyToOne(targetEntity="Atd", inversedBy="mouvements")
     * @ORM\JoinColumn(name="atd_id", referencedColumnName="id")
     */
    private $atd;


    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateDecision", type="datetime", nullable=true)
     */
    private $dateDecision;

    /**
     * @var string
     *
     * @ORM\Column(name="juridiction", type="string", length=255, nullable=true)
     */
    private $juridiction;

    /**
     * @var string
     *
     * @ORM\Column(name="ville", type="string", length=255, nullable=true)
     */
    private $ville;

    /**
     * @var int
     *
     * @ORM\Column(name="montant_init", type="integer")
     */
    private $montantInit;

    /**
     * @var int
     *
     * @ORM\Column(name="montant_curr", type="integer")
     */
    private $montantCurrent;

    /**
     * @var string
     *
     * @ORM\Column(name="justificatif", type="string", length=255, nullable=true)
     */
    private $justificatif;

    /**
     * @var string
     *
     * @ORM\Column(name="certificateNonAppel", type="string", length=255, nullable=true)
     */
    private $certificateNonAppel;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCertificatNonAppel", type="datetime", nullable=true)
     */
    private $dateCertificatNonAppel;

    /**
     * @var string
     *
     * @ORM\Column(name="decisionJustice", type="string", length=255, nullable=true)
     */
    private $decisionJustice;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;


    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=150, nullable=true)
     */
    private $pdf;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="mouvementAtd")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    function __construct(){
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime();
        $this->statut = 0; // 0=émission atd | 1= approvisionement |  
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set emetteur
     *
     * @param string $emetteur
     *
     * @return MouvementAtd
     */
    public function setEmetteur($emetteur)
    {
        $this->emetteur = $emetteur;

        return $this;
    }

    /**
     * Get emetteur
     *
     * @return string
     */
    public function getEmetteur()
    {
        return $this->emetteur;
    }

    /**
     * Set misencause
     *
     * @param string $misencause
     *
     * @return MouvementAtd
     */
    public function setMisencause($misencause)
    {
        $this->misencause = $misencause;

        return $this;
    }

    /**
     * Get misencause
     *
     * @return string
     */
    public function getMisencause()
    {
        return $this->misencause;
    }

    /**
     * Set dateDecision
     *
     * @param \DateTime $dateDecision
     *
     * @return MouvementAtd
     */
    public function setDateDecision($dateDecision)
    {
        $this->dateDecision = $dateDecision;

        return $this;
    }

    /**
     * Get dateDecision
     *
     * @return \DateTime
     */
    public function getDateDecision()
    {
        return $this->dateDecision;
    }

    /**
     * Set juridiction
     *
     * @param string $juridiction
     *
     * @return MouvementAtd
     */
    public function setJuridiction($juridiction)
    {
        $this->juridiction = $juridiction;

        return $this;
    }

    /**
     * Get juridiction
     *
     * @return string
     */
    public function getJuridiction()
    {
        return $this->juridiction;
    }

    /**
     * Set ville
     *
     * @param string $ville
     *
     * @return MouvementAtd
     */
    public function setVille($ville)
    {
        $this->ville = $ville;

        return $this;
    }

    /**
     * Get ville
     *
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * Set montant
     *
     * @param integer $montant
     *
     * @return MouvementAtd
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return int
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set justificatif
     *
     * @param string $justificatif
     *
     * @return MouvementAtd
     */
    public function setJustificatif($justificatif)
    {
        $this->justificatif = $justificatif;

        return $this;
    }

    /**
     * Get justificatif
     *
     * @return string
     */
    public function getJustificatif()
    {
        return $this->justificatif;
    }

    /**
     * Set certificateNonAppel
     *
     * @param string $certificateNonAppel
     *
     * @return MouvementAtd
     */
    public function setCertificateNonAppel($certificateNonAppel)
    {
        $this->certificateNonAppel = $certificateNonAppel;

        return $this;
    }

    /**
     * Get certificateNonAppel
     *
     * @return string
     */
    public function getCertificateNonAppel()
    {
        return $this->certificateNonAppel;
    }

    /**
     * Set dateCertificatNonAppel
     *
     * @param \DateTime $dateCertificatNonAppel
     *
     * @return MouvementAtd
     */
    public function setDateCertificatNonAppel($dateCertificatNonAppel)
    {
        $this->dateCertificatNonAppel = $dateCertificatNonAppel;

        return $this;
    }

    /**
     * Get dateCertificatNonAppel
     *
     * @return \DateTime
     */
    public function getDateCertificatNonAppel()
    {
        return $this->dateCertificatNonAppel;
    }

    /**
     * Set decisionJustice
     *
     * @param string $decisionJustice
     *
     * @return MouvementAtd
     */
    public function setDecisionJustice($decisionJustice)
    {
        $this->decisionJustice = $decisionJustice;

        return $this;
    }

    /**
     * Get decisionJustice
     *
     * @return string
     */
    public function getDecisionJustice()
    {
        return $this->decisionJustice;
    }

    /**
     * Set montantInit
     *
     * @param integer $montantInit
     *
     * @return MouvementAtd
     */
    public function setMontantInit($montantInit)
    {
        $this->montantInit = $montantInit;

        return $this;
    }

    /**
     * Get montantInit
     *
     * @return integer
     */
    public function getMontantInit()
    {
        return $this->montantInit;
    }

    /**
     * Set montantCurrent
     *
     * @param integer $montantCurrent
     *
     * @return MouvementAtd
     */
    public function setMontantCurrent($montantCurrent)
    {
        $this->montantCurrent = $montantCurrent;

        return $this;
    }

    /**
     * Get montantCurrent
     *
     * @return integer
     */
    public function getMontantCurrent()
    {
        return $this->montantCurrent;
    }

    /**
     * Set atd
     *
     * @param \AMLA\SqrBundle\Entity\Atd $atd
     *
     * @return MouvementAtd
     */
    public function setAtd(\AMLA\SqrBundle\Entity\Atd $atd = null)
    {
        $this->atd = $atd;

        return $this;
    }

    /**
     * Get atd
     *
     * @return \AMLA\SqrBundle\Entity\Atd
     */
    public function getAtd()
    {
        return $this->atd;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return MouvementAtd
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return MouvementAtd
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set pdf
     *
     * @param string $pdf
     *
     * @return MouvementAtd
     */
    public function setPdf($pdf)
    {
        $this->pdf = $pdf;

        return $this;
    }

    /**
     * Get pdf
     *
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return MouvementAtd
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }
}
