<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * MoratoireInstallment
 *
 * @ORM\Table(name="moratoire_installment")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\MoratoireInstallmentRepository")
 */
class MoratoireInstallment
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Moratoire", inversedBy="moratoireInstallment")
     * @ORM\JoinColumn(name="moratoire_id", referencedColumnName="id")
     */
    private $moratoire;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="paymentDate", type="date")
     */
    private $paymentDate;

    /**
     * @var float
     *
     * @ORM\Column(name="amount", type="float")
     */
    private $amount;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set moratoire
     *
     * @param integer $moratoire
     *
     * @return MoratoireInstallment
     */
    public function setMoratoire($moratoire)
    {
        $this->moratoire = $moratoire;

        return $this;
    }

    /**
     * Get moratoire
     *
     * @return int
     */
    public function getMoratoire()
    {
        return $this->moratoire;
    }

    /**
     * Set paymentDate
     *
     * @param \DateTime $paymentDate
     *
     * @return MoratoireInstallment
     */
    public function setPaymentDate($paymentDate)
    {
        $this->paymentDate = $paymentDate;

        return $this;
    }

    /**
     * Get paymentDate
     *
     * @return \DateTime
     */
    public function getPaymentDate()
    {
        return $this->paymentDate;
    }

    /**
     * Set amount
     *
     * @param float $amount
     *
     * @return MoratoireInstallment
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return MoratoireInstallment
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
}
