<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * MoratoireComment
 *
 * @ORM\Table(name="moratoire_comment")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\MoratoireCommentRepository")
 */
class MoratoireComment
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Moratoire", inversedBy="moratoireComment")
     * @ORM\JoinColumn(name="moratoire_id", referencedColumnName="id")
     */
    private $moratoire;

    /**
     * @var string
     *
     * @ORM\Column(name="comment", type="text")
     */
    private $comment;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var int
     *
     * @ORM\Column(name="account", type="integer")
     */
    private $account;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set moratoire
     *
     * @param integer $moratoire
     *
     * @return MoratoireComment
     */
    public function setMoratoire($moratoire)
    {
        $this->moratoire = $moratoire;

        return $this;
    }

    /**
     * Get moratoire
     *
     * @return int
     */
    public function getMoratoire()
    {
        return $this->moratoire;
    }

    /**
     * Set comment
     *
     * @param string $comment
     *
     * @return MoratoireComment
     */
    public function setComment($comment)
    {
        $this->comment = $comment;

        return $this;
    }

    /**
     * Get comment
     *
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return MoratoireComment
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set account
     *
     * @param integer $account
     *
     * @return MoratoireComment
     */
    public function setAccount($account)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return int
     */
    public function getAccount()
    {
        return $this->account;
    }
}
