<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Moratoire
 *
 * @ORM\Table(name="moratoire")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\MoratoireRepository")
 */
class Moratoire
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
    
    /**
     * @var string
     *
     * @ORM\Column(name="typeMoratoire", type="string", length=50)
     */
    private $typeMoratoire;

    /**
     * @var string
     *
     * @ORM\Column(name="referenceTypeMoratoire", type="string", length=50)
     */
    private $referenceTypeMoratoire;

    /** 
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="moratoireDemandeur")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $auteurDemandeur;

    /**
     * @var
     *
     * @ORM\Column(name="pourcentage", type="integer")
     */
    private $pourcentage;

    /**
     * @var int
     *
     * @ORM\Column(name="dureeMois", type="integer")
     */
    private $dureeMois;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="$dateDecision", type="datetime")
     */
    private $dateDecision;

    /**
     * @var int
     *
     * @ORM\Column(name="decision", type="integer")
     */
    private $decision;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="moratoireDecision")
     * @ORM\JoinColumn(name="account_decision_id", referencedColumnName="id")
     */
    private $auteurDecision;

    /**
     * @var string
     *
     * @ORM\Column(name="commentaire", type="text", nullable=true)
     */
    private $commentaire;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="moratoire")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;
    
    /**
     * @ORM\OneToMany(targetEntity="MoratoireInstallment", mappedBy="moratoire",cascade={"persist"}, orphanRemoval=true)
    */
    private $moratoireInstallment;
    
    /**
     * @ORM\OneToMany(targetEntity="MoratoireComment", mappedBy="moratoire",cascade={"persist"}, orphanRemoval=true)
    */
    private $moratoireComment;
    
    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->decision = 0;// 0=En attente // 1= accepté // 2=rejetée (avec ou sans motif)
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set pourcentage
     *
     * @param integer $pourcentage
     *
     * @return Moratoire
     */
    public function setPourcentage($pourcentage)
    {
        $this->pourcentage = $pourcentage;

        return $this;
    }

    /**
     * Get pourcentage
     *
     * @return integer
     */
    public function getPourcentage()
    {
        return $this->pourcentage;
    }

    /**
     * Set dureeMois
     *
     * @param integer $dureeMois
     *
     * @return Moratoire
     */
    public function setDureeMois($dureeMois)
    {
        $this->dureeMois = $dureeMois;

        return $this;
    }

    /**
     * Get dureeMois
     *
     * @return integer
     */
    public function getDureeMois()
    {
        return $this->dureeMois;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Moratoire
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set decision
     *
     * @param integer $decision
     *
     * @return Moratoire
     */
    public function setDecision($decision)
    {
        $this->decision = $decision;

        return $this;
    }

    /**
     * Get decision
     *
     * @return integer
     */
    public function getDecision()
    {
        return $this->decision;
    }

    /**
     * Set commentaire
     *
     * @param string $commentaire
     *
     * @return Moratoire
     */
    public function setCommentaire($commentaire)
    {
        $this->commentaire = $commentaire;

        return $this;
    }

    /**
     * Get commentaire
     *
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * Set atd
     *
     * @param \AMLA\SqrBundle\Entity\Atd $atd
     *
     * @return Moratoire
     */
    public function setAtd(\AMLA\SqrBundle\Entity\Atd $atd = null)
    {
        $this->atd = $atd;

        return $this;
    }

    /**
     * Get atd
     *
     * @return \AMLA\SqrBundle\Entity\Atd
     */
    public function getAtd()
    {
        return $this->atd;
    }

    /**
     * Set auteurDemandeur
     *
     * @param \AMLA\SqrBundle\Entity\Account $auteurDemandeur
     *
     * @return Moratoire
     */
    public function setAuteurDemandeur(\AMLA\SqrBundle\Entity\Account $auteurDemandeur = null)
    {
        $this->auteurDemandeur = $auteurDemandeur;

        return $this;
    }

    /**
     * Get auteurDemandeur
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAuteurDemandeur()
    {
        return $this->auteurDemandeur;
    }

    /**
     * Set auteurDecision
     *
     * @param \AMLA\SqrBundle\Entity\Account $auteurDecision
     *
     * @return Moratoire
     */
    public function setAuteurDecision(\AMLA\SqrBundle\Entity\Account $auteurDecision = null)
    {
        $this->auteurDecision = $auteurDecision;

        return $this;
    }

    /**
     * Get auteurDecision
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAuteurDecision()
    {
        return $this->auteurDecision;
    }

    /**
     * Set dateDecision
     *
     * @param \DateTime $dateDecision
     *
     * @return Moratoire
     */
    public function setDateDecision($dateDecision)
    {
        $this->dateDecision = $dateDecision;

        return $this;
    }

    /**
     * Get dateDecision
     *
     * @return \DateTime
     */
    public function getDateDecision()
    {
        return $this->dateDecision;
    }

    /**
     * Set typeMoratoire
     *
     * @param string $typeMoratoire
     *
     * @return Moratoire
     */
    public function setTypeMoratoire($typeMoratoire)
    {
        $this->typeMoratoire = $typeMoratoire;

        return $this;
    }

    /**
     * Get typeMoratoire
     *
     * @return string
     */
    public function getTypeMoratoire()
    {
        return $this->typeMoratoire;
    }

    /**
     * Set referenceTypeMoratoire
     *
     * @param string $referenceTypeMoratoire
     *
     * @return Moratoire
     */
    public function setReferenceTypeMoratoire($referenceTypeMoratoire)
    {
        $this->referenceTypeMoratoire = $referenceTypeMoratoire;

        return $this;
    }

    /**
     * Get referenceTypeMoratoire
     *
     * @return string
     */
    public function getReferenceTypeMoratoire()
    {
        return $this->referenceTypeMoratoire;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return Moratoire
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Add moratoireInstallment
     *
     * @param \AMLA\SqrBundle\Entity\MoratoireInstallment $moratoireInstallment
     *
     * @return Moratoire
     */
    public function addMoratoireInstallment(\AMLA\SqrBundle\Entity\MoratoireInstallment $moratoireInstallment)
    {
        $this->moratoireInstallment[] = $moratoireInstallment;

        return $this;
    }

    /**
     * Remove moratoireInstallment
     *
     * @param \AMLA\SqrBundle\Entity\MoratoireInstallment $moratoireInstallment
     */
    public function removeMoratoireInstallment(\AMLA\SqrBundle\Entity\MoratoireInstallment $moratoireInstallment)
    {
        $this->moratoireInstallment->removeElement($moratoireInstallment);
    }

    /**
     * Get moratoireInstallment
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMoratoireInstallment()
    {
        return $this->moratoireInstallment;
    }

    /**
     * Add moratoireComment
     *
     * @param \AMLA\SqrBundle\Entity\MoratoireComment $moratoireComment
     *
     * @return Moratoire
     */
    public function addMoratoireComment(\AMLA\SqrBundle\Entity\MoratoireComment $moratoireComment)
    {
        $this->moratoireComment[] = $moratoireComment;

        return $this;
    }

    /**
     * Remove moratoireComment
     *
     * @param \AMLA\SqrBundle\Entity\MoratoireComment $moratoireComment
     */
    public function removeMoratoireComment(\AMLA\SqrBundle\Entity\MoratoireComment $moratoireComment)
    {
        $this->moratoireComment->removeElement($moratoireComment);
    }

    /**
     * Get moratoireComment
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMoratoireComment()
    {
        return $this->moratoireComment;
    }
}
