<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Messagerie
 *
 * @ORM\Table(name="messagerie")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\MessagerieRepository")
 */
class Messagerie
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=255)
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="message", type="text")
     */
    private $message;

    /**
     * @var string
     *
     * @ORM\Column(name="attachement", type="string", length=255)
     */
    private $attachement;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var int
     *
     * @ORM\Column(name="isRead", type="integer")
     */
    private $isRead;  

    /** 
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="messagerieSender", cascade={"persist"})
     * @ORM\JoinColumn(name="fournisseur_sender_id", referencedColumnName="id")
     */
    private $fournisseurSend;

    /** 
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="messagerieReceiver", cascade={"persist"})
     * @ORM\JoinColumn(name="fournisseur_receiver_id", referencedColumnName="id")
     */
    private $fournisseurReceiver;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0; // 0=normal // 1= archive
        $this->isRead = 0; // 0=non //1 = read
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set title
     *
     * @param string $title
     *
     * @return Messagerie
     */
    public function setTitle($title)
    {
        $this->title = $title;

        return $this;
    }

    /**
     * Get title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Set message
     *
     * @param string $message
     *
     * @return Messagerie
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }

    /**
     * Get message
     *
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * Set fournisseurSend
     *
     * @param integer $fournisseurSend
     *
     * @return Messagerie
     */
    public function setFournisseurSend($fournisseurSend)
    {
        $this->fournisseurSend = $fournisseurSend;

        return $this;
    }

    /**
     * Get fournisseurSend
     *
     * @return int
     */
    public function getFournisseurSend()
    {
        return $this->fournisseurSend;
    }

    /**
     * Set fournisseurReceive
     *
     * @param integer $fournisseurReceive
     *
     * @return Messagerie
     */
    public function setFournisseurReceive($fournisseurReceive)
    {
        $this->fournisseurReceive = $fournisseurReceive;

        return $this;
    }

    /**
     * Get fournisseurReceive
     *
     * @return int
     */
    public function getFournisseurReceive()
    {
        return $this->fournisseurReceive;
    }

    /**
     * Set attachement
     *
     * @param string $attachement
     *
     * @return Messagerie
     */
    public function setAttachement($attachement)
    {
        $this->attachement = $attachement;

        return $this;
    }

    /**
     * Get attachement
     *
     * @return string
     */
    public function getAttachement()
    {
        return $this->attachement;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return Messagerie
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Messagerie
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set isRead
     *
     * @param integer $isRead
     *
     * @return Messagerie
     */
    public function setIsRead($isRead)
    {
        $this->isRead = $isRead;

        return $this;
    }

    /**
     * Get isRead
     *
     * @return int
     */
    public function getIsRead()
    {
        return $this->isRead;
    }

    /**
     * Set fournisseurReceiver
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseurReceiver
     *
     * @return Messagerie
     */
    public function setFournisseurReceiver(\AMLA\SqrBundle\Entity\Fournissseur $fournisseurReceiver = null)
    {
        $this->fournisseurReceiver = $fournisseurReceiver;

        return $this;
    }

    /**
     * Get fournisseurReceiver
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseurReceiver()
    {
        return $this->fournisseurReceiver;
    }
}
