<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * MaitreOuvrage
 *
 * @ORM\Table(name="maitre_ouvrage")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\MaitreOuvrageRepository")
 */
class MaitreOuvrage
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="idstructure", type="string", length=255)
     */
    private $idstructure;

    /**
     * @var string
     *
     * @ORM\Column(name="libelle", type="string", length=255)
     */
    private $libelle;

    /**
     * @var string
     *
     * @ORM\Column(name="sigle", type="string", length=255)
     */
    private $sigle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="Contrat", mappedBy="idMaitreOuvrage")
     */
    private $contrat;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set idstructure
     *
     * @param string $idstructure
     *
     * @return MaitreOuvrage
     */
    public function setIdstructure($idstructure)
    {
        $this->idstructure = $idstructure;

        return $this;
    }

    /**
     * Get idstructure
     *
     * @return string
     */
    public function getIdstructure()
    {
        return $this->idstructure;
    }

    /**
     * Set libelle
     *
     * @param string $libelle
     *
     * @return MaitreOuvrage
     */
    public function setLibelle($libelle)
    {
        $this->libelle = $libelle;

        return $this;
    }

    /**
     * Get libelle
     *
     * @return string
     */
    public function getLibelle()
    {
        return $this->libelle;
    }

    /**
     * Set sigle
     *
     * @param string $sigle
     *
     * @return MaitreOuvrage
     */
    public function setSigle($sigle)
    {
        $this->sigle = $sigle;

        return $this;
    }

    /**
     * Get sigle
     *
     * @return string
     */
    public function getSigle()
    {
        return $this->sigle;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return MaitreOuvrage
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Add contrat
     *
     * @param \AMLA\SqrBundle\Entity\Contrat $contrat
     *
     * @return MaitreOuvrage
     */
    public function addContrat(\AMLA\SqrBundle\Entity\Contrat $contrat)
    {
        $this->contrat[] = $contrat;

        return $this;
    }

    /**
     * Remove contrat
     *
     * @param \AMLA\SqrBundle\Entity\Contrat $contrat
     */
    public function removeContrat(\AMLA\SqrBundle\Entity\Contrat $contrat)
    {
        $this->contrat->removeElement($contrat);
    }

    /**
     * Get contrat
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getContrat()
    {
        return $this->contrat;
    }
}
