<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * MTN
 *
 * @ORM\Table(name="m_t_n")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\MTNRepository")
 */
class MTN
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="amount", type="float")
     */
    private $amount;

     /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="mtn")
     * @ORM\JoinColumn(name="checkqr_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
    * @ORM\ManyToOne(targetEntity="Atd", inversedBy="mtn")
    * @ORM\JoinColumn(name="atd_id", referencedColumnName="id")
    */
    private $atd;

    /**
     * @var string
     *
     * @ORM\Column(name="phonenumber", type="string", length=50)
     */
    private $phonenumber;

     /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="mtn")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;
 
    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status; //0=bad 1=good   

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        //$this->statut = 0;// 0=En attente // 1= validée // 2=rejetée (avec ou sans motif)
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set amount
     *
     * @param float $amount
     *
     * @return MTN
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;
        return $this;
    }

    /**
     * Get amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set qrCode
     *
     * @param string $qrCode
     *
     * @return MTN
     */
    public function setQrCode($qrCode)
    {
        $this->qrCode = $qrCode;
        return $this;
    }

    /**
     * Get qrCode
     *
     * @return string
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set phonenumber
     *
     * @param string $phonenumber
     *
     * @return MTN
     */
    public function setPhonenumber($phonenumber)
    {
        $this->phonenumber = $phonenumber;
        return $this;
    }

    /**
     * Get phonenumber
     *
     * @return string
     */
    public function getPhonenumber()
    {
        return $this->phonenumber;
    }

    /**
     * Set account
     *
     * @param integer $account
     *
     * @return MTN
     */
    public function setAccount($account)
    {
        $this->account = $account;
        return $this;
    }

    /**
     * Get account
     *
     * @return int
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return MTN
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * Get status
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set atd
     *
     * @param \AMLA\SqrBundle\Entity\Atd $atd
     *
     * @return MTN
     */
    public function setAtd(\AMLA\SqrBundle\Entity\Atd $atd = null)
    {
        $this->atd = $atd;
        return $this;
    }

    /**
     * Get atd
     *
     * @return \AMLA\SqrBundle\Entity\Atd
     */
    public function getAtd()
    {
        return $this->atd;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return MTN
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
}
