<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * IsParam
 *
 * @ORM\Table(name="is_param")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\IsParamRepository")
 */
class IsParam
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="isRate", type="float")
     */
    private $isRate;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetimetz")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set isRate
     *
     * @param float $isRate
     *
     * @return IsParam
     */
    public function setIsRate($isRate)
    {
        $this->isRate = $isRate;

        return $this;
    }

    /**
     * Get isRate
     *
     * @return float
     */
    public function getIsRate()
    {
        return $this->isRate;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return IsParam
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
}
