<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * InstitutionBancaire
 *
 * @ORM\Table(name="institution_bancaire")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\InstitutionBancaireRepository")
 */
class InstitutionBancaire
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nom_banque", type="string", length=255)
     */
    private $nomBanque;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @ORM\OneToMany(targetEntity="BanqueAssocie", mappedBy="institutionBancaire")
     */
    private $banqueAssocie;

    /**
     * @var string
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    function __construct(){
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nomBanque
     *
     * @param string $nomBanque
     *
     * @return InstitutionBancaire
     */
    public function setNomBanque($nomBanque)
    {
        $this->nomBanque = $nomBanque;
        return $this;
    }

    /**
     * Get nomBanque
     *
     * @return string
     */
    public function getNomBanque()
    {
        return $this->nomBanque;
    }

    /**
     * Set dateCreated
     *
     * @param string $dateCreated
     *
     * @return InstitutionBancaire
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return string
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Add banqueAssocie
     *
     * @param \AMLA\SqrBundle\Entity\BanqueAssocie $banqueAssocie
     *
     * @return InstitutionBancaire
     */
    public function addBanqueAssocie(\AMLA\SqrBundle\Entity\BanqueAssocie $banqueAssocie)
    {
        $this->banqueAssocie[] = $banqueAssocie;
        return $this;
    }

    /**
     * Remove banqueAssocie
     *
     * @param \AMLA\SqrBundle\Entity\BanqueAssocie $banqueAssocie
     */
    public function removeBanqueAssocie(\AMLA\SqrBundle\Entity\BanqueAssocie $banqueAssocie)
    {
        $this->banqueAssocie->removeElement($banqueAssocie);
    }

    /**
     * Get banqueAssocie
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getBanqueAssocie()
    {
        return $this->banqueAssocie;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return InstitutionBancaire
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;
        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }
}
