<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * InBill
 *
 * @ORM\Table(name="in_bill")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\InBillRepository")
 */
class InBill
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\OneToMany(targetEntity="Fournissseur", mappedBy="inBill")
     */
    private $fournisseur; // la collection inbill pour un fournisseur

    /**
     * @ORM\OneToMany(targetEntity="FactureSpontane", mappedBy="inBill")
    */
    private $factureSpontane;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateDebut", type="datetime")
     */
    private $dateDebut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateFin", type="datetime")
     */
    private $dateFin;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * @ORM\OneToMany(targetEntity="SubscriptionInbill", mappedBy="inbill")
     */
    private $subscriptionInbill;

    /**
     * @var boolean
     *
     * @ORM\Column(name="isInBillOnly", type="smallint", nullable=true)
     */
    private $isInBillOnly; // configuration permettant à un utilisateur de dire s'il veut être facturé par inbill uniquement ou pas

    /**
     * @var string
     *
     * @ORM\Column(name="isInBillLanguage", type="string", length=20, nullable=true) // langue parametré du in bill
     */
    private $isInBillLanguage;

    /**
     * @var int
     *
     * @ORM\Column(name="isInbillOnlyDevis", type="integer", nullable=true) // parametres du in bill pour les devis
     */
    private $isInbillOnlyDevis;
    
    /**
     * @var int
     *
     * @ORM\Column(name="isInbillOnlyFacture", type="integer", nullable=true) // parametres du in bill pour les factures
     */
    private $isInbillOnlyFacture;
    
    /**
     * @var int
     *
     * @ORM\Column(name="isInbillAccess", type="integer", nullable=true) // parametres du in bill pour les factures
     */
    private $isInbillAccess;// à qui donner acccès à mon in bill

    /**
     * @ORM\OneToMany(targetEntity="AccessInBill", mappedBy="inBill")
     */
    private $accessInBill;
    
    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;//0=En attente // 1= Payée // 2=rejetée (avec ou sans motif)
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fournisseur.
     *
     * @param int $fournisseur
     *
     * @return InBill
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur.
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set dateDebut.
     *
     * @param \DateTime $dateDebut
     *
     * @return InBill
     */
    public function setDateDebut($dateDebut)
    {
        $this->dateDebut = $dateDebut;

        return $this;
    }

    /**
     * Get dateDebut.
     *
     * @return \DateTime
     */
    public function getDateDebut()
    {
        return $this->dateDebut;
    }

    /**
     * Set dateFin.
     *
     * @param \DateTime $dateFin
     *
     * @return InBill
     */
    public function setDateFin($dateFin)
    {
        $this->dateFin = $dateFin;

        return $this;
    }

    /**
     * Get dateFin.
     *
     * @return \DateTime
     */
    public function getDateFin()
    {
        return $this->dateFin;
    }

    /**
     * Set statut.
     *
     * @param int $statut
     *
     * @return InBill
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut.
     *
     * @return int
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set status.
     *
     * @param int $status
     *
     * @return InBill
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status.
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Add subscriptionInbill.
     *
     * @param \AMLA\SqrBundle\Entity\SubscriptionInbill $subscriptionInbill
     *
     * @return InBill
     */
    public function addSubscriptionInbill(\AMLA\SqrBundle\Entity\SubscriptionInbill $subscriptionInbill)
    {
        $this->subscriptionInbill[] = $subscriptionInbill;

        return $this;
    }

    /**
     * Remove subscriptionInbill.
     *
     * @param \AMLA\SqrBundle\Entity\SubscriptionInbill $subscriptionInbill
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeSubscriptionInbill(\AMLA\SqrBundle\Entity\SubscriptionInbill $subscriptionInbill)
    {
        return $this->subscriptionInbill->removeElement($subscriptionInbill);
    }

    /**
     * Get subscriptionInbill.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSubscriptionInbill()
    {
        return $this->subscriptionInbill;
    }

    /**
     * Add factureSpontane.
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return InBill
     */
    public function addFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane)
    {
        $this->factureSpontane[] = $factureSpontane;

        return $this;
    }

    /**
     * Remove factureSpontane.
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane)
    {
        return $this->factureSpontane->removeElement($factureSpontane);
    }

    /**
     * Get factureSpontane.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }

    /**
     * Set isInBillOnly.
     *
     * @param int|null $isInBillOnly
     *
     * @return InBill
     */
    public function setIsInBillOnly($isInBillOnly = null)
    {
        $this->isInBillOnly = $isInBillOnly;

        return $this;
    }

    /**
     * Get isInBillOnly.
     *
     * @return int|null
     */
    public function getIsInBillOnly()
    {
        return $this->isInBillOnly;
    }

    /**
     * Set isInBillLanguage.
     *
     * @param string $isInBillLanguage
     *
     * @return InBill
     */
    public function setIsInBillLanguage($isInBillLanguage)
    {
        $this->isInBillLanguage = $isInBillLanguage;

        return $this;
    }

    /**
     * Get isInBillLanguage.
     *
     * @return string
     */
    public function getIsInBillLanguage()
    {
        return $this->isInBillLanguage;
    }

    /**
     * Set isInbillOnlyDevis.
     *
     * @param int|null $isInbillOnlyDevis
     *
     * @return InBill
     */
    public function setIsInbillOnlyDevis($isInbillOnlyDevis = null)
    {
        $this->isInbillOnlyDevis = $isInbillOnlyDevis;

        return $this;
    }

    /**
     * Get isInbillOnlyDevis.
     *
     * @return int|null
     */
    public function getIsInbillOnlyDevis()
    {
        return $this->isInbillOnlyDevis;
    }

    /**
     * Set isInbillOnlyFacture.
     *
     * @param int|null $isInbillOnlyFacture
     *
     * @return InBill
     */
    public function setIsInbillOnlyFacture($isInbillOnlyFacture = null)
    {
        $this->isInbillOnlyFacture = $isInbillOnlyFacture;

        return $this;
    }

    /**
     * Get isInbillOnlyFacture.
     *
     * @return int|null
     */
    public function getIsInbillOnlyFacture()
    {
        return $this->isInbillOnlyFacture;
    }

    /**
     * Add fournisseur.
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return InBill
     */
    public function addFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur)
    {
        $this->fournisseur[] = $fournisseur;

        return $this;
    }

    /**
     * Remove fournisseur.
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur)
    {
        return $this->fournisseur->removeElement($fournisseur);
    }

    /**
     * Set isInbillAccess.
     *
     * @param int|null $isInbillAccess
     *
     * @return InBill
     */
    public function setIsInbillAccess($isInbillAccess = null)
    {
        $this->isInbillAccess = $isInbillAccess;

        return $this;
    }

    /**
     * Get isInbillAccess.
     *
     * @return int|null
     */
    public function getIsInbillAccess()
    {
        return $this->isInbillAccess;
    }

    /**
     * Add accessInBill.
     *
     * @param \AMLA\SqrBundle\Entity\AccessInBill $accessInBill
     *
     * @return InBill
     */
    public function addAccessInBill(\AMLA\SqrBundle\Entity\AccessInBill $accessInBill)
    {
        $this->accessInBill[] = $accessInBill;

        return $this;
    }

    /**
     * Remove accessInBill.
     *
     * @param \AMLA\SqrBundle\Entity\AccessInBill $accessInBill
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeAccessInBill(\AMLA\SqrBundle\Entity\AccessInBill $accessInBill)
    {
        return $this->accessInBill->removeElement($accessInBill);
    }

    /**
     * Get accessInBill.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAccessInBill()
    {
        return $this->accessInBill;
    }
}
