<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ImpotVerify
 *
 * @ORM\Table(name="impot_verify")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ImpotVerifyRepository")
 */
class ImpotVerify
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="impotVerify")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @var string
     *
     * @ORM\Column(name="checktatoo_niu_ref", type="string", length=20)
     */
    private $checktatooNiuRef;

    /**
     * @var string
     *
     * @ORM\Column(name="checktatoo_sqr_ref", type="string", length=100)
     */
    private $checktatooSqrRef;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="checktatoo_date_generated", type="datetime")
     */
    private $checktatooDateGenerated;

    /**
     * @var string
     *
     * @ORM\Column(name="verification_type", type="string", length=20)
     */
    private $verificationType;

    /**
     * @var string
     *
     * @ORM\Column(name="data_to_verify", type="string", length=255)
     */
    private $dataToVerify;

    /**
     * @var string
     *
     * @ORM\Column(name="criteria", type="string", length=255)
     */
    private $criteria;

    /**
     * @var string
     *
     * @ORM\Column(name="impot_reference", type="string", length=255)
     */
    private $impotReference;
    
    /**
     * @var string
     *
     * @ORM\Column(name="impot_date_generated", type="string", length=255)
     */
    private $impotDateGenerated;      

    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=150, nullable=true)
     */
    private $pdf;     

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=50, nullable=true)
     */
    private $niu;     

    /**
     * @var string
     *
     * @ORM\Column(name="atd", type="string", length=50, nullable=true)
     */
    private $atd;      

    /**
     * @var string
     *
     * @ORM\Column(name="anr", type="string", length=50, nullable=true)
     */
    private $anr;    

    /**
     * @var string
     *
     * @ORM\Column(name="etat", type="string", length=50, nullable=true)
     */
    private $etat;   

    /**
     * @var string
     *
     * @ORM\Column(name="sigle", type="string", length=100, nullable=true)
     */
    private $sigle;

    /**
     * @var string
     *
     * @ORM\Column(name="raison_sociale", type="string", length=100, nullable=true)
     */
    private $raisonSociale;

    /**
     * @var string
     *
     * @ORM\Column(name="activite_principale", type="string", length=100, nullable=true)
     */
    private $activitePrincipale;

    /**
     * @var string
     *
     * @ORM\Column(name="classe_actvite", type="string", length=100, nullable=true)
     */
    private $classeActvite;

    /**
     * @var string
     *
     * @ORM\Column(name="regime_fiscal", type="string", length=100, nullable=true)
     */
    private $regimeFiscal;

    /**
     * @var string
     *
     * @ORM\Column(name="forme_juridique", type="string", length=100, nullable=true)
     */
    private $formeJuridique;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone", type="string", length=100, nullable=true)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="centre_impot", type="string", length=100, nullable=true)
     */
    private $centreImpot;

    /**
     * @var string
     *
     * @ORM\Column(name="centre_regional", type="string", length=100, nullable=true)
     */
    private $centreRegional;

    /**
     * @var string
     *
     * @ORM\Column(name="boite_postale", type="string", length=100, nullable=true)
     */
    private $boitePostale;

    /**
     * @var string
     *
     * @ORM\Column(name="ville", type="string", length=100, nullable=true)
     */
    private $ville;

    /**
     * @var string
     *
     * @ORM\Column(name="commune", type="string", length=100, nullable=true)
     */
    private $commune;

    /**
     * @var string
     *
     * @ORM\Column(name="quartier", type="string", length=100, nullable=true)
     */
    private $quartier;

    /**
     * @var string
     *
     * @ORM\Column(name="lieu_dit", type="string", length=100, nullable=true)
     */
    private $lieuDit;

    /**
     * @var string
     *
     * @ORM\Column(name="date_delivrance", type="string", length=100, nullable=true)
     */
    private $dateDelivrance;

    /**
     * @var string
     *
     * @ORM\Column(name="date_insertion", type="string", length=100, nullable=true)
     */
    private $dateInsertion;

    /**
     * @var string
     *
     * @ORM\Column(name="date_expiration", type="string", length=100, nullable=true)
     */
    private $dateExpiration;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_cantonne", type="string", length=100, nullable=true)
     */
    private $montantCantonne;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_du", type="string", length=100, nullable=true)
     */
    private $montantDu;

    /**
     * @var string
     *
     * @ORM\Column(name="montant_paye", type="string", length=100, nullable=true)
     */
    private $montantPaye;

    /**
     * @var string
     *
     * @ORM\Column(name="reste_paye", type="string", length=100, nullable=true)
     */
    private $restePaye;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="impotVerify")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->checktatooDateGenerated = new \Datetime(); // default date
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set checktatooNiuRef
     *
     * @param string $checktatooNiuRef
     *
     * @return ImpotVerify
     */
    public function setChecktatooNiuRef($checktatooNiuRef)
    {
        $this->checktatooNiuRef = $checktatooNiuRef;

        return $this;
    }

    /**
     * Get checktatooNiuRef
     *
     * @return string
     */
    public function getChecktatooNiuRef()
    {
        return $this->checktatooNiuRef;
    }

    /**
     * Set checktatooSqrRef
     *
     * @param string $checktatooSqrRef
     *
     * @return ImpotVerify
     */
    public function setChecktatooSqrRef($checktatooSqrRef)
    {
        $this->checktatooSqrRef = $checktatooSqrRef;

        return $this;
    }

    /**
     * Get checktatooSqrRef
     *
     * @return string
     */
    public function getChecktatooSqrRef()
    {
        return $this->checktatooSqrRef;
    }

    /**
     * Set checktatooDateGenerated
     *
     * @param \DateTime $checktatooDateGenerated
     *
     * @return ImpotVerify
     */
    public function setChecktatooDateGenerated($checktatooDateGenerated)
    {
        $this->checktatooDateGenerated = $checktatooDateGenerated;

        return $this;
    }

    /**
     * Get checktatooDateGenerated
     *
     * @return \DateTime
     */
    public function getChecktatooDateGenerated()
    {
        return $this->checktatooDateGenerated;
    }

    /**
     * Set verificationType
     *
     * @param string $verificationType
     *
     * @return ImpotVerify
     */
    public function setVerificationType($verificationType)
    {
        $this->verificationType = $verificationType;

        return $this;
    }

    /**
     * Get verificationType
     *
     * @return string
     */
    public function getVerificationType()
    {
        return $this->verificationType;
    }

    /**
     * Set dataToVerify
     *
     * @param string $dataToVerify
     *
     * @return ImpotVerify
     */
    public function setDataToVerify($dataToVerify)
    {
        $this->dataToVerify = $dataToVerify;

        return $this;
    }

    /**
     * Get dataToVerify
     *
     * @return string
     */
    public function getDataToVerify()
    {
        return $this->dataToVerify;
    }

    /**
     * Set criteria
     *
     * @param string $criteria
     *
     * @return ImpotVerify
     */
    public function setCriteria($criteria)
    {
        $this->criteria = $criteria;

        return $this;
    }

    /**
     * Get criteria
     *
     * @return string
     */
    public function getCriteria()
    {
        return $this->criteria;
    }

    /**
     * Set impotReference
     *
     * @param string $impotReference
     *
     * @return ImpotVerify
     */
    public function setImpotReference($impotReference)
    {
        $this->impotReference = $impotReference;

        return $this;
    }

    /**
     * Get impotReference
     *
     * @return string
     */
    public function getImpotReference()
    {
        return $this->impotReference;
    }

    /**
     * Set impotDateGenerated
     *
     * @param string $impotDateGenerated
     *
     * @return ImpotVerify
     */
    public function setImpotDateGenerated($impotDateGenerated)
    {
        $this->impotDateGenerated = $impotDateGenerated;

        return $this;
    }

    /**
     * Get impotDateGenerated
     *
     * @return string
     */
    public function getImpotDateGenerated()
    {
        return $this->impotDateGenerated;
    }

    /**
     * Set pdf
     *
     * @param string $pdf
     *
     * @return ImpotVerify
     */
    public function setPdf($pdf)
    {
        $this->pdf = $pdf;

        return $this;
    }

    /**
     * Get pdf
     *
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return ImpotVerify
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return ImpotVerify
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return ImpotVerify
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set etat
     *
     * @param string $etat
     *
     * @return ImpotVerify
     */
    public function setEtat($etat)
    {
        $this->etat = $etat;

        return $this;
    }

    /**
     * Get etat
     *
     * @return string
     */
    public function getEtat()
    {
        return $this->etat;
    }

    /**
     * Set raisonSociale
     *
     * @param string $raisonSociale
     *
     * @return ImpotVerify
     */
    public function setRaisonSociale($raisonSociale)
    {
        $this->raisonSociale = $raisonSociale;

        return $this;
    }

    /**
     * Get raisonSociale
     *
     * @return string
     */
    public function getRaisonSociale()
    {
        return $this->raisonSociale;
    }

    /**
     * Set activitePrincipale
     *
     * @param string $activitePrincipale
     *
     * @return ImpotVerify
     */
    public function setActivitePrincipale($activitePrincipale)
    {
        $this->activitePrincipale = $activitePrincipale;

        return $this;
    }

    /**
     * Get activitePrincipale
     *
     * @return string
     */
    public function getActivitePrincipale()
    {
        return $this->activitePrincipale;
    }

    /**
     * Set classeActvite
     *
     * @param string $classeActvite
     *
     * @return ImpotVerify
     */
    public function setClasseActvite($classeActvite)
    {
        $this->classeActvite = $classeActvite;

        return $this;
    }

    /**
     * Get classeActvite
     *
     * @return string
     */
    public function getClasseActvite()
    {
        return $this->classeActvite;
    }

    /**
     * Set regimeFiscal
     *
     * @param string $regimeFiscal
     *
     * @return ImpotVerify
     */
    public function setRegimeFiscal($regimeFiscal)
    {
        $this->regimeFiscal = $regimeFiscal;

        return $this;
    }

    /**
     * Get regimeFiscal
     *
     * @return string
     */
    public function getRegimeFiscal()
    {
        return $this->regimeFiscal;
    }

    /**
     * Set formeJuridique
     *
     * @param string $formeJuridique
     *
     * @return ImpotVerify
     */
    public function setFormeJuridique($formeJuridique)
    {
        $this->formeJuridique = $formeJuridique;

        return $this;
    }

    /**
     * Get formeJuridique
     *
     * @return string
     */
    public function getFormeJuridique()
    {
        return $this->formeJuridique;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     *
     * @return ImpotVerify
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set centreImpot
     *
     * @param string $centreImpot
     *
     * @return ImpotVerify
     */
    public function setCentreImpot($centreImpot)
    {
        $this->centreImpot = $centreImpot;

        return $this;
    }

    /**
     * Get centreImpot
     *
     * @return string
     */
    public function getCentreImpot()
    {
        return $this->centreImpot;
    }

    /**
     * Set centreRegional
     *
     * @param string $centreRegional
     *
     * @return ImpotVerify
     */
    public function setCentreRegional($centreRegional)
    {
        $this->centreRegional = $centreRegional;

        return $this;
    }

    /**
     * Get centreRegional
     *
     * @return string
     */
    public function getCentreRegional()
    {
        return $this->centreRegional;
    }

    /**
     * Set boitePostale
     *
     * @param string $boitePostale
     *
     * @return ImpotVerify
     */
    public function setBoitePostale($boitePostale)
    {
        $this->boitePostale = $boitePostale;

        return $this;
    }

    /**
     * Get boitePostale
     *
     * @return string
     */
    public function getBoitePostale()
    {
        return $this->boitePostale;
    }

    /**
     * Set ville
     *
     * @param string $ville
     *
     * @return ImpotVerify
     */
    public function setVille($ville)
    {
        $this->ville = $ville;

        return $this;
    }

    /**
     * Get ville
     *
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * Set commune
     *
     * @param string $commune
     *
     * @return ImpotVerify
     */
    public function setCommune($commune)
    {
        $this->commune = $commune;

        return $this;
    }

    /**
     * Get commune
     *
     * @return string
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * Set quartier
     *
     * @param string $quartier
     *
     * @return ImpotVerify
     */
    public function setQuartier($quartier)
    {
        $this->quartier = $quartier;

        return $this;
    }

    /**
     * Get quartier
     *
     * @return string
     */
    public function getQuartier()
    {
        return $this->quartier;
    }

    /**
     * Set lieuDit
     *
     * @param string $lieuDit
     *
     * @return ImpotVerify
     */
    public function setLieuDit($lieuDit)
    {
        $this->lieuDit = $lieuDit;

        return $this;
    }

    /**
     * Get lieuDit
     *
     * @return string
     */
    public function getLieuDit()
    {
        return $this->lieuDit;
    }

    /**
     * Set atd
     *
     * @param string $atd
     *
     * @return ImpotVerify
     */
    public function setAtd($atd)
    {
        $this->atd = $atd;

        return $this;
    }

    /**
     * Get atd
     *
     * @return string
     */
    public function getAtd()
    {
        return $this->atd;
    }

    /**
     * Set anr
     *
     * @param string $anr
     *
     * @return ImpotVerify
     */
    public function setAnr($anr)
    {
        $this->anr = $anr;

        return $this;
    }

    /**
     * Get anr
     *
     * @return string
     */
    public function getAnr()
    {
        return $this->anr;
    }

    /**
     * Set dateDelivrance
     *
     * @param string $dateDelivrance
     *
     * @return ImpotVerify
     */
    public function setDateDelivrance($dateDelivrance)
    {
        $this->dateDelivrance = $dateDelivrance;

        return $this;
    }

    /**
     * Get dateDelivrance
     *
     * @return string
     */
    public function getDateDelivrance()
    {
        return $this->dateDelivrance;
    }

    /**
     * Set dateExpiration
     *
     * @param string $dateExpiration
     *
     * @return ImpotVerify
     */
    public function setDateExpiration($dateExpiration)
    {
        $this->dateExpiration = $dateExpiration;

        return $this;
    }

    /**
     * Get dateExpiration
     *
     * @return string
     */
    public function getDateExpiration()
    {
        return $this->dateExpiration;
    }

    /**
     * Set montantCantonne
     *
     * @param string $montantCantonne
     *
     * @return ImpotVerify
     */
    public function setMontantCantonne($montantCantonne)
    {
        $this->montantCantonne = $montantCantonne;

        return $this;
    }

    /**
     * Get montantCantonne
     *
     * @return string
     */
    public function getMontantCantonne()
    {
        return $this->montantCantonne;
    }

    /**
     * Set montantDu
     *
     * @param string $montantDu
     *
     * @return ImpotVerify
     */
    public function setMontantDu($montantDu)
    {
        $this->montantDu = $montantDu;

        return $this;
    }

    /**
     * Get montantDu
     *
     * @return string
     */
    public function getMontantDu()
    {
        return $this->montantDu;
    }

    /**
     * Set montantPaye
     *
     * @param string $montantPaye
     *
     * @return ImpotVerify
     */
    public function setMontantPaye($montantPaye)
    {
        $this->montantPaye = $montantPaye;

        return $this;
    }

    /**
     * Get montantPaye
     *
     * @return string
     */
    public function getMontantPaye()
    {
        return $this->montantPaye;
    }

    /**
     * Set restePaye
     *
     * @param string $restePaye
     *
     * @return ImpotVerify
     */
    public function setRestePaye($restePaye)
    {
        $this->restePaye = $restePaye;

        return $this;
    }

    /**
     * Get restePaye
     *
     * @return string
     */
    public function getRestePaye()
    {
        return $this->restePaye;
    }

    /**
     * Set sigle
     *
     * @param string $sigle
     *
     * @return ImpotVerify
     */
    public function setSigle($sigle)
    {
        $this->sigle = $sigle;

        return $this;
    }

    /**
     * Get sigle
     *
     * @return string
     */
    public function getSigle()
    {
        return $this->sigle;
    }

    /**
     * Set dateInsertion
     *
     * @param string $dateInsertion
     *
     * @return ImpotVerify
     */
    public function setDateInsertion($dateInsertion)
    {
        $this->dateInsertion = $dateInsertion;

        return $this;
    }

    /**
     * Get dateInsertion
     *
     * @return string
     */
    public function getDateInsertion()
    {
        return $this->dateInsertion;
    }
}
