<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Freevending
 *
 * @ORM\Table(name="freevending")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FreevendingRepository")
 */
class Freevending
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="balance", type="float")
     */
    private $balance;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="freevending")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dernierDebit", type="datetime")
     */
    private $dernierDebit;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dernierCredit", type="datetime")
     */
    private $dernierCredit;
    
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dernierDebit = new \Datetime(); // default date
        $this->dernierCredit = new \Datetime(); // default date
        $this->balance = 0;
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set balance
     *
     * @param float $balance
     *
     * @return Freevending
     */
    public function setBalance($balance)
    {
        $this->balance = $balance;

        return $this;
    }

    /**
     * Get balance
     *
     * @return float
     */
    public function getBalance()
    {
        return $this->balance;
    }

    /**
     * Set dernierDebit
     *
     * @param \DateTime $dernierDebit
     *
     * @return Freevending
     */
    public function setDernierDebit($dernierDebit)
    {
        $this->dernierDebit = $dernierDebit;

        return $this;
    }

    /**
     * Get dernierDebit
     *
     * @return \DateTime
     */
    public function getDernierDebit()
    {
        return $this->dernierDebit;
    }

    /**
     * Set dernierCredit
     *
     * @param \DateTime $dernierCredit
     *
     * @return Freevending
     */
    public function setDernierCredit($dernierCredit)
    {
        $this->dernierCredit = $dernierCredit;

        return $this;
    }

    /**
     * Get dernierCredit
     *
     * @return \DateTime
     */
    public function getDernierCredit()
    {
        return $this->dernierCredit;
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return Freevending
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }
}
