<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Fournissseur
 *
 * @ORM\Table(name="fournissseur")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FournissseurRepository")
 */
class Fournissseur
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="raison_sociale", type="string", length=255)
     */
    private $raisonSociale;

    /**
     * @var string
     *
     * @ORM\Column(name="sigle", type="string", length=255)
     */
    private $sigle;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=255)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_registre_commerce", type="string", length=255)
     */
    private $numeroRegistreCommerce;

    /**
     * @var string
     *
     * @ORM\Column(name="quartier", type="string", length=100, nullable=true)
     */
    private $quartier;

    /**
     * @var string
     *
     * @ORM\Column(name="lieu_dit", type="string", length=100, nullable=true)
     */
    private $lieuDit;

    /**
     * @var string
     *
     * @ORM\Column(name="personne_a_contacter", type="string", length=100)
     */
    private $personneAContacter;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone_mobile", type="string", length=50)
     */
    private $telephoneMobile;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone_fixe", type="string", length=50, nullable=true)
     */
    private $telephoneFixe;

    /**
     * @var string
     *
     * @ORM\Column(name="adresse_email", type="string", length=50)
     */
    private $adresseEmail;

    /**
     * @var string
     *
     * @ORM\Column(name="boite_postale", type="string", length=50, nullable=true)
     */
    private $boitePostale;

    /**
     * @var string
     *
     * @ORM\Column(name="ville", type="string", length=50, nullable=true)
     */
    private $ville;

    /**
     * @var string
     *
     * @ORM\Column(name="site_web", type="string", length=50, nullable=true)
     */
    private $siteWeb;

    /**
     * @var string
     *
     * @ORM\Column(name="logo", type="string", length=100, nullable=true)
     */
    private $logo;

    /**
     * @var int
     *
     * @ORM\Column(name="activite_principale", type="integer", nullable=true)
     */
    private $activitePrincipale;

    /**
     * @var string
     *
     * @ORM\Column(name="statutAtd", type="string", length=100, nullable=true)
     */
    private $statutAtd;// Absence ATD  existence atd

    /**
     * @var string
     *
     * @ORM\Column(name="statutAmr", type="string", length=100, nullable=true)
     */
    private $statutAmr; // rien a signaler notifié

    /**
     * @var string
     *
     * @ORM\Column(name="statutAnr", type="string", length=100, nullable=true)
     */
    private $statutAnr;// non disponible valide non valide

    /**
     * @var string
     *
     * @ORM\Column(name="statutContribuable", type="string", length=100, nullable=true)
     */
    private $statutContribuable; // actif inactif

    /**
     * @ORM\ManyToOne(targetEntity="statutJuridique", inversedBy="fournisseur")
     * @ORM\JoinColumn(name="forme_juridique_id", referencedColumnName="id")
     */
    private $formeJuridique;

    /**
     * @ORM\ManyToOne(targetEntity="RegimeFiscal", inversedBy="fournisseur")
     * @ORM\JoinColumn(name="regime_fiscal_id", referencedColumnName="id")
     */
    private $regimeFiscal;

    /**
     * @ORM\ManyToOne(targetEntity="CentreRattachement", inversedBy="fournisseur")
     * @ORM\JoinColumn(name="centre_de_rattachement_id", referencedColumnName="id")
     */
    private $centrerattachement;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="parentCompagnies")
     * @ORM\JoinColumn(name="parent_compagny_id", referencedColumnName="id")
     */
    private $parentCompagny;

    /**
     * @ORM\OneToMany(targetEntity="Fournissseur", mappedBy="parentCompagny")
     */
    private $parentCompagnies;

    /**
     * @ORM\OneToMany(targetEntity="Freevending", mappedBy="fournisseur")
     */
    private $freevending;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @var boolean
     *
     * @ORM\Column(name="canCollectTax", type="smallint", nullable=true)
     */
    private $canCollectTax;//0=no 1=yes

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var string
     *
     * @ORM\Column(name="pays", type="string", nullable=true)
     */
    private $pays;

    /**
     * @var string
     *
     * @ORM\Column(name="capital", type="string", nullable=true)
     */
    private $capital;
    
    /**
     * @ORM\OneToMany(targetEntity="FournisseurBanque", mappedBy="fournisseur")
     */
    private $fournisseurbanque;

    /**
     * @ORM\OneToMany(targetEntity="FournisseurBanqueAccess", mappedBy="banque")
     */
    private $fournisseurBanqueAccessBanque;

    /**
     * @ORM\OneToMany(targetEntity="FournisseurBanqueAccess", mappedBy="fournisseur")
     */
    private $fournisseurBanqueAccessFournisseur;

    /**
     * @ORM\OneToMany(targetEntity="FournisseurMoa", mappedBy="fournisseur")
     */
    private $fournisseurMoa;

    /**
     * @ORM\OneToMany(targetEntity="FournisseurMoa", mappedBy="moa")
     */
    private $fournissseurMoa;

    /**
     * @ORM\OneToMany(targetEntity="Offre", mappedBy="fournisseur")
     */
    private $offre;

    /**
     * @ORM\OneToMany(targetEntity="SoummissionOffre", mappedBy="fournisseur")
     */
    private $soumissionoffre;

    /**
     * @ORM\OneToMany(targetEntity="OffreFournisseur", mappedBy="fournisseurSpon")
     */
    private $offrefournisseurSpon;

    /**
     * @ORM\OneToMany(targetEntity="OffreFournisseur", mappedBy="fournisseur")
     */
    private $offrefournisseur;

    /**
     * @ORM\OneToMany(targetEntity="Preselection", mappedBy="fournisseur")
     */
    private $preselection;

     /**
     * @ORM\OneToMany(targetEntity="AttestationVerification", mappedBy="fournisseur")
     */
    private $attestationVerif;

     /**
     * @ORM\OneToMany(targetEntity="AttestationVerification", mappedBy="verificateur")
     */
    private $attestationVerifV;

     /**
     * @ORM\OneToMany(targetEntity="Account", mappedBy="compagnyId")
     */
    private $compagnyUsers;

    /** 
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="fournisseurs", cascade={"persist"})
     * @ORM\JoinColumn(name="compte_utilisateur", referencedColumnName="id")
     */
    private $account;

    /** 
     * @ORM\ManyToOne(targetEntity="Commune", inversedBy="fournisseur", cascade={"persist"})
     * @ORM\JoinColumn(name="commune_id", referencedColumnName="id")
     */
    private $commune;

    /** 
     * @ORM\ManyToOne(targetEntity="Activite", inversedBy="fournisseur", cascade={"persist"})
     * @ORM\JoinColumn(name="activite_id", referencedColumnName="id")
     */
    private $activite;
    
    /**
     * @ORM\OneToMany(targetEntity="Anr", mappedBy="fournisseur")
     */
    private $anr;

    /**
     * @ORM\OneToMany(targetEntity="MouvementAtd", mappedBy="emetteur")
     */
    private $atdemeteur; 

    /**
     * @ORM\OneToMany(targetEntity="Messagerie", mappedBy="fournisseurSend")
     */
    private $messagerieSender;

    /**
     * @ORM\OneToMany(targetEntity="Messagerie", mappedBy="fournisseurReceiver")
     */
    private $messagerieReceiver;    
    
    /**
     * @ORM\OneToMany(targetEntity="SecretariatPublic", mappedBy="fournisseur")
     */
    private $secretariatPublic; 
    
    /**
     * @ORM\OneToMany(targetEntity="Notification", mappedBy="fournisseur")
     */
    private $notification;

    /**
     * @ORM\OneToMany(targetEntity="RelationAffaire", mappedBy="fournisseurInitial")
     */
    private $relationContribuableInitial;

    /**
     * @ORM\OneToMany(targetEntity="RelationAffaire", mappedBy="fournisseurEnAffaire")
     */
    private $relationContribuableEnAffaire;
    
    /**
     * @ORM\OneToMany(targetEntity="Debour", mappedBy="fournisseurRecepteur")
     */
    private $debourRecepteur;  
    
    /**
     * @ORM\OneToMany(targetEntity="Debour", mappedBy="fournisseurEmetteur")
     */
    private $debourEmetteur;

    /**
     * @ORM\OneToMany(targetEntity="NoteAvoir", mappedBy="fournisseurEmetteur")
     */
    private $noteAvoirEmetteur;

    /**
     * @ORM\OneToMany(targetEntity="NoteAvoir", mappedBy="fournisseurRecepteur")
     */
    private $noteAvoirRecepteur;

    /**
     * @ORM\OneToMany(targetEntity="Exchange", mappedBy="fournisseur")
     */
    private $exchange;

    /**
     * @ORM\OneToMany(targetEntity="Approvisionner", mappedBy="fournisseur")
     */
    private $approvisionner;

    /**
     * @ORM\OneToMany(targetEntity="FactureSpontane", mappedBy="fournisseur")
     */
    private $factureSpontane;

    /**
     * @ORM\OneToMany(targetEntity="Tva", mappedBy="fournisseur")
     */
    private $tva;

    /**
     * @ORM\OneToMany(targetEntity="TvaHistory", mappedBy="fournisseur")
     */
    private $tvaHistory;

    /**
     * @ORM\OneToMany(targetEntity="RemiseGracieuse", mappedBy="fournisseur")
     */
    private $remiseGracieuse;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalFactureTtc", type="float", nullable=true)
     */
    private $montantGlobalFactureTtc;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalFactureHt", type="float", nullable=true)
     */
    private $montantGlobalFactureHt;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISFacture", type="float", nullable=true)
     */
    private $montantGlobalISFacture;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVAFacture", type="float", nullable=true)
     */
    private $montantGlobalTVAFacture;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISEncaise", type="float", nullable=true)
     */
    private $montantGlobalISEncaise;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVAEncaise", type="float", nullable=true)
     */
    private $montantGlobalTVAEncaise;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISRetenu", type="float", nullable=true)
     */
    private $montantGlobalISRetenu;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVARetenu", type="float", nullable=true)
     */
    private $montantGlobalTVARetenu;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISPaye", type="float", nullable=true)
     */
    private $montantGlobalISPaye;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVAPaye", type="float", nullable=true)
     */
    private $montantGlobalTVAPaye;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalTVAFacturerejete", type="float", nullable=true)
     */
    private $montantGlobalTVAFactureRejete;

    /**
     * @var float
     *
     * @ORM\Column(name="montantGlobalISFacturerejete", type="float", nullable=true)
     */
    private $montantGlobalISFactureRejete;

    /**
     * @ORM\ManyToOne(targetEntity="InBill", inversedBy="fournisseur")
     * @ORM\JoinColumn(name="in_bill_id", referencedColumnName="id")
     */
    private $inBill;    

    /**
     * @var boolean
     *
     * @ORM\Column(name="isInBill", type="smallint", nullable=true)
     */
    private $isInBill; // si un fournisseur a souscrit au service in bill

    /**
     * @ORM\OneToMany(targetEntity="Repertoire", mappedBy="fournisseur")
     */
    private $repertoire;
    
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
        $this->statutContribuable = null;
        $this->statutAnr = null;
        $this->statutAmr = null;
        $this->statutAtd = null;
        $this->canCollectTax = 0;
        $this->isInBill = 0;
        //$this->isInBillOnly = 0; //0 pour non 1 pour oui        
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set raisonSociale
     *
     * @param string $raisonSociale
     *
     * @return Fournissseur
     */
    public function setRaisonSociale($raisonSociale)
    {
        $this->raisonSociale = $raisonSociale;

        return $this;
    }

    /**
     * Get raisonSociale
     *
     * @return string
     */
    public function getRaisonSociale()
    {
        return $this->raisonSociale;
    }

    /**
     * Set sigle
     *
     * @param string $sigle
     *
     * @return Fournissseur
     */
    public function setSigle($sigle)
    {
        $this->sigle = $sigle;

        return $this;
    }

    /**
     * Get sigle
     *
     * @return string
     */
    public function getSigle()
    {
        return $this->sigle;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return Fournissseur
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set numeroRegistreCommerce
     *
     * @param string $numeroRegistreCommerce
     *
     * @return Fournissseur
     */
    public function setNumeroRegistreCommerce($numeroRegistreCommerce)
    {
        $this->numeroRegistreCommerce = $numeroRegistreCommerce;

        return $this;
    }

    /**
     * Get numeroRegistreCommerce
     *
     * @return string
     */
    public function getNumeroRegistreCommerce()
    {
        return $this->numeroRegistreCommerce;
    }

    /**
     * Set quartier
     *
     * @param string $quartier
     *
     * @return Fournissseur
     */
    public function setQuartier($quartier)
    {
        $this->quartier = $quartier;

        return $this;
    }

    /**
     * Get quartier
     *
     * @return string
     */
    public function getQuartier()
    {
        return $this->quartier;
    }

    /**
     * Set lieuDit
     *
     * @param string $lieuDit
     *
     * @return Fournissseur
     */
    public function setLieuDit($lieuDit)
    {
        $this->lieuDit = $lieuDit;

        return $this;
    }

    /**
     * Get lieuDit
     *
     * @return string
     */
    public function getLieuDit()
    {
        return $this->lieuDit;
    }

    /**
     * Set personneAContacter
     *
     * @param string $personneAContacter
     *
     * @return Fournissseur
     */
    public function setPersonneAContacter($personneAContacter)
    {
        $this->personneAContacter = $personneAContacter;

        return $this;
    }

    /**
     * Get personneAContacter
     *
     * @return string
     */
    public function getPersonneAContacter()
    {
        return $this->personneAContacter;
    }

    /**
     * Set telephoneMobile
     *
     * @param string $telephoneMobile
     *
     * @return Fournissseur
     */
    public function setTelephoneMobile($telephoneMobile)
    {
        $this->telephoneMobile = $telephoneMobile;

        return $this;
    }

    /**
     * Get telephoneMobile
     *
     * @return string
     */
    public function getTelephoneMobile()
    {
        return $this->telephoneMobile;
    }

    /**
     * Set telephoneFixe
     *
     * @param string $telephoneFixe
     *
     * @return Fournissseur
     */
    public function setTelephoneFixe($telephoneFixe)
    {
        $this->telephoneFixe = $telephoneFixe;

        return $this;
    }

    /**
     * Get telephoneFixe
     *
     * @return string
     */
    public function getTelephoneFixe()
    {
        return $this->telephoneFixe;
    }

    /**
     * Set adresseEmail
     *
     * @param string $adresseEmail
     *
     * @return Fournissseur
     */
    public function setAdresseEmail($adresseEmail)
    {
        $this->adresseEmail = $adresseEmail;

        return $this;
    }

    /**
     * Get adresseEmail
     *
     * @return string
     */
    public function getAdresseEmail()
    {
        return $this->adresseEmail;
    }

    /**
     * Set boitePostale
     *
     * @param string $boitePostale
     *
     * @return Fournissseur
     */
    public function setBoitePostale($boitePostale)
    {
        $this->boitePostale = $boitePostale;

        return $this;
    }

    /**
     * Get boitePostale
     *
     * @return string
     */
    public function getBoitePostale()
    {
        return $this->boitePostale;
    }

    /**
     * Set ville
     *
     * @param string $ville
     *
     * @return Fournissseur
     */
    public function setVille($ville)
    {
        $this->ville = $ville;

        return $this;
    }

    /**
     * Get ville
     *
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * Set siteWeb
     *
     * @param string $siteWeb
     *
     * @return Fournissseur
     */
    public function setSiteWeb($siteWeb)
    {
        $this->siteWeb = $siteWeb;

        return $this;
    }

    /**
     * Get siteWeb
     *
     * @return string
     */
    public function getSiteWeb()
    {
        return $this->siteWeb;
    }

    /**
     * Set logo
     *
     * @param string $logo
     *
     * @return Fournissseur
     */
    public function setLogo($logo)
    {
        $this->logo = $logo;

        return $this;
    }

    /**
     * Get logo
     *
     * @return string
     */
    public function getLogo()
    {
        return $this->logo;
    }

    /**
     * Set activitePrincipale
     *
     * @param integer $activitePrincipale
     *
     * @return Fournissseur
     */
    public function setActivitePrincipale($activitePrincipale)
    {
        $this->activitePrincipale = $activitePrincipale;

        return $this;
    }

    /**
     * Get activitePrincipale
     *
     * @return integer
     */
    public function getActivitePrincipale()
    {
        return $this->activitePrincipale;
    }

    /**
     * Set statutAtd
     *
     * @param string $statutAtd
     *
     * @return Fournissseur
     */
    public function setStatutAtd($statutAtd)
    {
        $this->statutAtd = $statutAtd;

        return $this;
    }

    /**
     * Get statutAtd
     *
     * @return string
     */
    public function getStatutAtd()
    {
        return $this->statutAtd;
    }

    /**
     * Set statutAmr
     *
     * @param string $statutAmr
     *
     * @return Fournissseur
     */
    public function setStatutAmr($statutAmr)
    {
        $this->statutAmr = $statutAmr;

        return $this;
    }

    /**
     * Get statutAmr
     *
     * @return string
     */
    public function getStatutAmr()
    {
        return $this->statutAmr;
    }

    /**
     * Set statutAnr
     *
     * @param string $statutAnr
     *
     * @return Fournissseur
     */
    public function setStatutAnr($statutAnr)
    {
        $this->statutAnr = $statutAnr;

        return $this;
    }

    /**
     * Get statutAnr
     *
     * @return string
     */
    public function getStatutAnr()
    {
        return $this->statutAnr;
    }

    /**
     * Set statutContribuable
     *
     * @param string $statutContribuable
     *
     * @return Fournissseur
     */
    public function setStatutContribuable($statutContribuable)
    {
        $this->statutContribuable = $statutContribuable;

        return $this;
    }

    /**
     * Get statutContribuable
     *
     * @return string
     */
    public function getStatutContribuable()
    {
        return $this->statutContribuable;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return Fournissseur
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Fournissseur
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set pays
     *
     * @param string $pays
     *
     * @return Fournissseur
     */
    public function setPays($pays)
    {
        $this->pays = $pays;

        return $this;
    }

    /**
     * Get pays
     *
     * @return string
     */
    public function getPays()
    {
        return $this->pays;
    }

    /**
     * Set capital
     *
     * @param string $capital
     *
     * @return Fournissseur
     */
    public function setCapital($capital)
    {
        $this->capital = $capital;

        return $this;
    }

    /**
     * Get capital
     *
     * @return string
     */
    public function getCapital()
    {
        return $this->capital;
    }

    /**
     * Set formeJuridique
     *
     * @param \AMLA\SqrBundle\Entity\statutJuridique $formeJuridique
     *
     * @return Fournissseur
     */
    public function setFormeJuridique(\AMLA\SqrBundle\Entity\statutJuridique $formeJuridique = null)
    {
        $this->formeJuridique = $formeJuridique;

        return $this;
    }

    /**
     * Get formeJuridique
     *
     * @return \AMLA\SqrBundle\Entity\statutJuridique
     */
    public function getFormeJuridique()
    {
        return $this->formeJuridique;
    }

    /**
     * Set regimeFiscal
     *
     * @param \AMLA\SqrBundle\Entity\RegimeFiscal $regimeFiscal
     *
     * @return Fournissseur
     */
    public function setRegimeFiscal(\AMLA\SqrBundle\Entity\RegimeFiscal $regimeFiscal = null)
    {
        $this->regimeFiscal = $regimeFiscal;

        return $this;
    }

    /**
     * Get regimeFiscal
     *
     * @return \AMLA\SqrBundle\Entity\RegimeFiscal
     */
    public function getRegimeFiscal()
    {
        return $this->regimeFiscal;
    }

    /**
     * Set centrerattachement
     *
     * @param \AMLA\SqrBundle\Entity\CentreRattachement $centrerattachement
     *
     * @return Fournissseur
     */
    public function setCentrerattachement(\AMLA\SqrBundle\Entity\CentreRattachement $centrerattachement = null)
    {
        $this->centrerattachement = $centrerattachement;

        return $this;
    }

    /**
     * Get centrerattachement
     *
     * @return \AMLA\SqrBundle\Entity\CentreRattachement
     */
    public function getCentrerattachement()
    {
        return $this->centrerattachement;
    }

    /**
     * Add fournisseurbanque
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurBanque $fournisseurbanque
     *
     * @return Fournissseur
     */
    public function addFournisseurbanque(\AMLA\SqrBundle\Entity\FournisseurBanque $fournisseurbanque)
    {
        $this->fournisseurbanque[] = $fournisseurbanque;

        return $this;
    }

    /**
     * Remove fournisseurbanque
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurBanque $fournisseurbanque
     */
    public function removeFournisseurbanque(\AMLA\SqrBundle\Entity\FournisseurBanque $fournisseurbanque)
    {
        $this->fournisseurbanque->removeElement($fournisseurbanque);
    }

    /**
     * Get fournisseurbanque
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseurbanque()
    {
        return $this->fournisseurbanque;
    }

    /**
     * Add fournisseurMoa
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurMoa $fournisseurMoa
     *
     * @return Fournissseur
     */
    public function addFournisseurMoa(\AMLA\SqrBundle\Entity\FournisseurMoa $fournisseurMoa)
    {
        $this->fournisseurMoa[] = $fournisseurMoa;

        return $this;
    }

    /**
     * Remove fournisseurMoa
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurMoa $fournisseurMoa
     */
    public function removeFournisseurMoa(\AMLA\SqrBundle\Entity\FournisseurMoa $fournisseurMoa)
    {
        $this->fournisseurMoa->removeElement($fournisseurMoa);
    }

    /**
     * Get fournisseurMoa
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseurMoa()
    {
        return $this->fournisseurMoa;
    }

    /**
     * Add fournissseurMoa
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurMoa $fournissseurMoa
     *
     * @return Fournissseur
     */
    public function addFournissseurMoa(\AMLA\SqrBundle\Entity\FournisseurMoa $fournissseurMoa)
    {
        $this->fournissseurMoa[] = $fournissseurMoa;

        return $this;
    }

    /**
     * Remove fournissseurMoa
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurMoa $fournissseurMoa
     */
    public function removeFournissseurMoa(\AMLA\SqrBundle\Entity\FournisseurMoa $fournissseurMoa)
    {
        $this->fournissseurMoa->removeElement($fournissseurMoa);
    }

    /**
     * Get fournissseurMoa
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournissseurMoa()
    {
        return $this->fournissseurMoa;
    }

    /**
     * Add offre
     *
     * @param \AMLA\SqrBundle\Entity\Offre $offre
     *
     * @return Fournissseur
     */
    public function addOffre(\AMLA\SqrBundle\Entity\Offre $offre)
    {
        $this->offre[] = $offre;

        return $this;
    }

    /**
     * Remove offre
     *
     * @param \AMLA\SqrBundle\Entity\Offre $offre
     */
    public function removeOffre(\AMLA\SqrBundle\Entity\Offre $offre)
    {
        $this->offre->removeElement($offre);
    }

    /**
     * Get offre
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOffre()
    {
        return $this->offre;
    }

    /**
     * Add soumissionoffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre
     *
     * @return Fournissseur
     */
    public function addSoumissionoffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre)
    {
        $this->soumissionoffre[] = $soumissionoffre;

        return $this;
    }

    /**
     * Remove soumissionoffre
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre
     */
    public function removeSoumissionoffre(\AMLA\SqrBundle\Entity\SoummissionOffre $soumissionoffre)
    {
        $this->soumissionoffre->removeElement($soumissionoffre);
    }

    /**
     * Get soumissionoffre
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSoumissionoffre()
    {
        return $this->soumissionoffre;
    }

    /**
     * Add offrefournisseurSpon
     *
     * @param \AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseurSpon
     *
     * @return Fournissseur
     */
    public function addOffrefournisseurSpon(\AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseurSpon)
    {
        $this->offrefournisseurSpon[] = $offrefournisseurSpon;

        return $this;
    }

    /**
     * Remove offrefournisseurSpon
     *
     * @param \AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseurSpon
     */
    public function removeOffrefournisseurSpon(\AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseurSpon)
    {
        $this->offrefournisseurSpon->removeElement($offrefournisseurSpon);
    }

    /**
     * Get offrefournisseurSpon
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOffrefournisseurSpon()
    {
        return $this->offrefournisseurSpon;
    }

    /**
     * Add offrefournisseur
     *
     * @param \AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseur
     *
     * @return Fournissseur
     */
    public function addOffrefournisseur(\AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseur)
    {
        $this->offrefournisseur[] = $offrefournisseur;

        return $this;
    }

    /**
     * Remove offrefournisseur
     *
     * @param \AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseur
     */
    public function removeOffrefournisseur(\AMLA\SqrBundle\Entity\OffreFournisseur $offrefournisseur)
    {
        $this->offrefournisseur->removeElement($offrefournisseur);
    }

    /**
     * Get offrefournisseur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getOffrefournisseur()
    {
        return $this->offrefournisseur;
    }

    /**
     * Add preselection
     *
     * @param \AMLA\SqrBundle\Entity\Preselection $preselection
     *
     * @return Fournissseur
     */
    public function addPreselection(\AMLA\SqrBundle\Entity\Preselection $preselection)
    {
        $this->preselection[] = $preselection;

        return $this;
    }

    /**
     * Remove preselection
     *
     * @param \AMLA\SqrBundle\Entity\Preselection $preselection
     */
    public function removePreselection(\AMLA\SqrBundle\Entity\Preselection $preselection)
    {
        $this->preselection->removeElement($preselection);
    }

    /**
     * Get preselection
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPreselection()
    {
        return $this->preselection;
    }

    /**
     * Add attestationVerif
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif
     *
     * @return Fournissseur
     */
    public function addAttestationVerif(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif)
    {
        $this->attestationVerif[] = $attestationVerif;

        return $this;
    }

    /**
     * Remove attestationVerif
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif
     */
    public function removeAttestationVerif(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerif)
    {
        $this->attestationVerif->removeElement($attestationVerif);
    }

    /**
     * Get attestationVerif
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAttestationVerif()
    {
        return $this->attestationVerif;
    }

    /**
     * Add attestationVerifV
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerifV
     *
     * @return Fournissseur
     */
    public function addAttestationVerifV(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerifV)
    {
        $this->attestationVerifV[] = $attestationVerifV;

        return $this;
    }

    /**
     * Remove attestationVerifV
     *
     * @param \AMLA\SqrBundle\Entity\AttestationVerification $attestationVerifV
     */
    public function removeAttestationVerifV(\AMLA\SqrBundle\Entity\AttestationVerification $attestationVerifV)
    {
        $this->attestationVerifV->removeElement($attestationVerifV);
    }

    /**
     * Get attestationVerifV
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAttestationVerifV()
    {
        return $this->attestationVerifV;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return Fournissseur
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set commune
     *
     * @param \AMLA\SqrBundle\Entity\Commune $commune
     *
     * @return Fournissseur
     */
    public function setCommune(\AMLA\SqrBundle\Entity\Commune $commune = null)
    {
        $this->commune = $commune;

        return $this;
    }

    /**
     * Get commune
     *
     * @return \AMLA\SqrBundle\Entity\Commune
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * Set activite
     *
     * @param \AMLA\SqrBundle\Entity\Activite $activite
     *
     * @return Fournissseur
     */
    public function setActivite(\AMLA\SqrBundle\Entity\Activite $activite = null)
    {
        $this->activite = $activite;

        return $this;
    }

    /**
     * Get activite
     *
     * @return \AMLA\SqrBundle\Entity\Activite
     */
    public function getActivite()
    {
        return $this->activite;
    }

    /**
     * Add anr
     *
     * @param \AMLA\SqrBundle\Entity\Anr $anr
     *
     * @return Fournissseur
     */
    public function addAnr(\AMLA\SqrBundle\Entity\Anr $anr)
    {
        $this->anr[] = $anr;

        return $this;
    }

    /**
     * Remove anr
     *
     * @param \AMLA\SqrBundle\Entity\Anr $anr
     */
    public function removeAnr(\AMLA\SqrBundle\Entity\Anr $anr)
    {
        $this->anr->removeElement($anr);
    }

    /**
     * Get anr
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAnr()
    {
        return $this->anr;
    }

    /**
     * Add atdemeteur
     *
     * @param \AMLA\SqrBundle\Entity\MouvementAtd $atdemeteur
     *
     * @return Fournissseur
     */
    public function addAtdemeteur(\AMLA\SqrBundle\Entity\MouvementAtd $atdemeteur)
    {
        $this->atdemeteur[] = $atdemeteur;

        return $this;
    }

    /**
     * Remove atdemeteur
     *
     * @param \AMLA\SqrBundle\Entity\MouvementAtd $atdemeteur
     */
    public function removeAtdemeteur(\AMLA\SqrBundle\Entity\MouvementAtd $atdemeteur)
    {
        $this->atdemeteur->removeElement($atdemeteur);
    }

    /**
     * Get atdemeteur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getAtdemeteur()
    {
        return $this->atdemeteur;
    }

    /**
     * Add messagerieSender
     *
     * @param \AMLA\SqrBundle\Entity\Messagerie $messagerieSender
     *
     * @return Fournissseur
     */
    public function addMessagerieSender(\AMLA\SqrBundle\Entity\Messagerie $messagerieSender)
    {
        $this->messagerieSender[] = $messagerieSender;

        return $this;
    }

    /**
     * Remove messagerieSender
     *
     * @param \AMLA\SqrBundle\Entity\Messagerie $messagerieSender
     */
    public function removeMessagerieSender(\AMLA\SqrBundle\Entity\Messagerie $messagerieSender)
    {
        $this->messagerieSender->removeElement($messagerieSender);
    }

    /**
     * Get messagerieSender
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessagerieSender()
    {
        return $this->messagerieSender;
    }

    /**
     * Add messagerieReceiver
     *
     * @param \AMLA\SqrBundle\Entity\Messagerie $messagerieReceiver
     *
     * @return Fournissseur
     */
    public function addMessagerieReceiver(\AMLA\SqrBundle\Entity\Messagerie $messagerieReceiver)
    {
        $this->messagerieReceiver[] = $messagerieReceiver;

        return $this;
    }

    /**
     * Remove messagerieReceiver
     *
     * @param \AMLA\SqrBundle\Entity\Messagerie $messagerieReceiver
     */
    public function removeMessagerieReceiver(\AMLA\SqrBundle\Entity\Messagerie $messagerieReceiver)
    {
        $this->messagerieReceiver->removeElement($messagerieReceiver);
    }

    /**
     * Get messagerieReceiver
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getMessagerieReceiver()
    {
        return $this->messagerieReceiver;
    }

    /**
     * Add secretariatPublic
     *
     * @param \AMLA\SqrBundle\Entity\SecretariatPublic $secretariatPublic
     *
     * @return Fournissseur
     */
    public function addSecretariatPublic(\AMLA\SqrBundle\Entity\SecretariatPublic $secretariatPublic)
    {
        $this->secretariatPublic[] = $secretariatPublic;

        return $this;
    }

    /**
     * Remove secretariatPublic
     *
     * @param \AMLA\SqrBundle\Entity\SecretariatPublic $secretariatPublic
     */
    public function removeSecretariatPublic(\AMLA\SqrBundle\Entity\SecretariatPublic $secretariatPublic)
    {
        $this->secretariatPublic->removeElement($secretariatPublic);
    }

    /**
     * Get secretariatPublic
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSecretariatPublic()
    {
        return $this->secretariatPublic;
    }

    /**
     * Add notification
     *
     * @param \AMLA\SqrBundle\Entity\Notification $notification
     *
     * @return Fournissseur
     */
    public function addNotification(\AMLA\SqrBundle\Entity\Notification $notification)
    {
        $this->notification[] = $notification;

        return $this;
    }

    /**
     * Remove notification
     *
     * @param \AMLA\SqrBundle\Entity\Notification $notification
     */
    public function removeNotification(\AMLA\SqrBundle\Entity\Notification $notification)
    {
        $this->notification->removeElement($notification);
    }

    /**
     * Get notification
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNotification()
    {
        return $this->notification;
    }

    /**
     * Add relationContribuableInitial
     *
     * @param \AMLA\SqrBundle\Entity\RelationAffaire $relationContribuableInitial
     *
     * @return Fournissseur
     */
    public function addRelationContribuableInitial(\AMLA\SqrBundle\Entity\RelationAffaire $relationContribuableInitial)
    {
        $this->relationContribuableInitial[] = $relationContribuableInitial;

        return $this;
    }

    /**
     * Remove relationContribuableInitial
     *
     * @param \AMLA\SqrBundle\Entity\RelationAffaire $relationContribuableInitial
     */
    public function removeRelationContribuableInitial(\AMLA\SqrBundle\Entity\RelationAffaire $relationContribuableInitial)
    {
        $this->relationContribuableInitial->removeElement($relationContribuableInitial);
    }

    /**
     * Get relationContribuableInitial
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRelationContribuableInitial()
    {
        return $this->relationContribuableInitial;
    }

    /**
     * Add relationContribuableEnAffaire
     *
     * @param \AMLA\SqrBundle\Entity\RelationAffaire $relationContribuableEnAffaire
     *
     * @return Fournissseur
     */
    public function addRelationContribuableEnAffaire(\AMLA\SqrBundle\Entity\RelationAffaire $relationContribuableEnAffaire)
    {
        $this->relationContribuableEnAffaire[] = $relationContribuableEnAffaire;

        return $this;
    }

    /**
     * Remove relationContribuableEnAffaire
     *
     * @param \AMLA\SqrBundle\Entity\RelationAffaire $relationContribuableEnAffaire
     */
    public function removeRelationContribuableEnAffaire(\AMLA\SqrBundle\Entity\RelationAffaire $relationContribuableEnAffaire)
    {
        $this->relationContribuableEnAffaire->removeElement($relationContribuableEnAffaire);
    }

    /**
     * Get relationContribuableEnAffaire
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRelationContribuableEnAffaire()
    {
        return $this->relationContribuableEnAffaire;
    }

    /**
     * Add debourRecepteur
     *
     * @param \AMLA\SqrBundle\Entity\Debour $debourRecepteur
     *
     * @return Fournissseur
     */
    public function addDebourRecepteur(\AMLA\SqrBundle\Entity\Debour $debourRecepteur)
    {
        $this->debourRecepteur[] = $debourRecepteur;

        return $this;
    }

    /**
     * Remove debourRecepteur
     *
     * @param \AMLA\SqrBundle\Entity\Debour $debourRecepteur
     */
    public function removeDebourRecepteur(\AMLA\SqrBundle\Entity\Debour $debourRecepteur)
    {
        $this->debourRecepteur->removeElement($debourRecepteur);
    }

    /**
     * Get debourRecepteur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDebourRecepteur()
    {
        return $this->debourRecepteur;
    }

    /**
     * Add debourEmetteur
     *
     * @param \AMLA\SqrBundle\Entity\Debour $debourEmetteur
     *
     * @return Fournissseur
     */
    public function addDebourEmetteur(\AMLA\SqrBundle\Entity\Debour $debourEmetteur)
    {
        $this->debourEmetteur[] = $debourEmetteur;

        return $this;
    }

    /**
     * Remove debourEmetteur
     *
     * @param \AMLA\SqrBundle\Entity\Debour $debourEmetteur
     */
    public function removeDebourEmetteur(\AMLA\SqrBundle\Entity\Debour $debourEmetteur)
    {
        $this->debourEmetteur->removeElement($debourEmetteur);
    }

    /**
     * Get debourEmetteur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDebourEmetteur()
    {
        return $this->debourEmetteur;
    }

    /**
     * Add noteAvoirEmetteur
     *
     * @param \AMLA\SqrBundle\Entity\NoteAvoir $noteAvoirEmetteur
     *
     * @return Fournissseur
     */
    public function addNoteAvoirEmetteur(\AMLA\SqrBundle\Entity\NoteAvoir $noteAvoirEmetteur)
    {
        $this->noteAvoirEmetteur[] = $noteAvoirEmetteur;

        return $this;
    }

    /**
     * Remove noteAvoirEmetteur
     *
     * @param \AMLA\SqrBundle\Entity\NoteAvoir $noteAvoirEmetteur
     */
    public function removeNoteAvoirEmetteur(\AMLA\SqrBundle\Entity\NoteAvoir $noteAvoirEmetteur)
    {
        $this->noteAvoirEmetteur->removeElement($noteAvoirEmetteur);
    }

    /**
     * Get noteAvoirEmetteur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNoteAvoirEmetteur()
    {
        return $this->noteAvoirEmetteur;
    }

    /**
     * Add noteAvoirRecepteur
     *
     * @param \AMLA\SqrBundle\Entity\NoteAvoir $noteAvoirRecepteur
     *
     * @return Fournissseur
     */
    public function addNoteAvoirRecepteur(\AMLA\SqrBundle\Entity\NoteAvoir $noteAvoirRecepteur)
    {
        $this->noteAvoirRecepteur[] = $noteAvoirRecepteur;

        return $this;
    }

    /**
     * Remove noteAvoirRecepteur
     *
     * @param \AMLA\SqrBundle\Entity\NoteAvoir $noteAvoirRecepteur
     */
    public function removeNoteAvoirRecepteur(\AMLA\SqrBundle\Entity\NoteAvoir $noteAvoirRecepteur)
    {
        $this->noteAvoirRecepteur->removeElement($noteAvoirRecepteur);
    }

    /**
     * Get noteAvoirRecepteur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getNoteAvoirRecepteur()
    {
        return $this->noteAvoirRecepteur;
    }

    /**
     * Add tva
     *
     * @param \AMLA\SqrBundle\Entity\Tva $tva
     *
     * @return Fournissseur
     */
    public function addTva(\AMLA\SqrBundle\Entity\Tva $tva)
    {
        $this->tva[] = $tva;

        return $this;
    }

    /**
     * Remove tva
     *
     * @param \AMLA\SqrBundle\Entity\Tva $tva
     */
    public function removeTva(\AMLA\SqrBundle\Entity\Tva $tva)
    {
        $this->tva->removeElement($tva);
    }

    /**
     * Get tva
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getTva()
    {
        return $this->tva;
    }

    /**
     * Add tvaHistory
     *
     * @param \AMLA\SqrBundle\Entity\TvaHistory $tvaHistory
     *
     * @return Fournissseur
     */
    public function addTvaHistory(\AMLA\SqrBundle\Entity\TvaHistory $tvaHistory)
    {
        $this->tvaHistory[] = $tvaHistory;

        return $this;
    }

    /**
     * Remove tvaHistory
     *
     * @param \AMLA\SqrBundle\Entity\TvaHistory $tvaHistory
     */
    public function removeTvaHistory(\AMLA\SqrBundle\Entity\TvaHistory $tvaHistory)
    {
        $this->tvaHistory->removeElement($tvaHistory);
    }

    /**
     * Get tvaHistory
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getTvaHistory()
    {
        return $this->tvaHistory;
    }

    /**
     * Add remiseGracieuse
     *
     * @param \AMLA\SqrBundle\Entity\RemiseGracieuse $remiseGracieuse
     *
     * @return Fournissseur
     */
    public function addRemiseGracieuse(\AMLA\SqrBundle\Entity\RemiseGracieuse $remiseGracieuse)
    {
        $this->remiseGracieuse[] = $remiseGracieuse;

        return $this;
    }

    /**
     * Remove remiseGracieuse
     *
     * @param \AMLA\SqrBundle\Entity\RemiseGracieuse $remiseGracieuse
     */
    public function removeRemiseGracieuse(\AMLA\SqrBundle\Entity\RemiseGracieuse $remiseGracieuse)
    {
        $this->remiseGracieuse->removeElement($remiseGracieuse);
    }

    /**
     * Get remiseGracieuse
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRemiseGracieuse()
    {
        return $this->remiseGracieuse;
    }

    /**
     * Add fournisseurBanqueAccessBanque
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurBanqueAccess $fournisseurBanqueAccessBanque
     *
     * @return Fournissseur
     */
    public function addFournisseurBanqueAccessBanque(\AMLA\SqrBundle\Entity\FournisseurBanqueAccess $fournisseurBanqueAccessBanque)
    {
        $this->fournisseurBanqueAccessBanque[] = $fournisseurBanqueAccessBanque;

        return $this;
    }

    /**
     * Remove fournisseurBanqueAccessBanque
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurBanqueAccess $fournisseurBanqueAccessBanque
     */
    public function removeFournisseurBanqueAccessBanque(\AMLA\SqrBundle\Entity\FournisseurBanqueAccess $fournisseurBanqueAccessBanque)
    {
        $this->fournisseurBanqueAccessBanque->removeElement($fournisseurBanqueAccessBanque);
    }

    /**
     * Get fournisseurBanqueAccessBanque
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseurBanqueAccessBanque()
    {
        return $this->fournisseurBanqueAccessBanque;
    }

    /**
     * Add fournisseurBanqueAccessFournisseur
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurBanqueAccess $fournisseurBanqueAccessFournisseur
     *
     * @return Fournissseur
     */
    public function addFournisseurBanqueAccessFournisseur(\AMLA\SqrBundle\Entity\FournisseurBanqueAccess $fournisseurBanqueAccessFournisseur)
    {
        $this->fournisseurBanqueAccessFournisseur[] = $fournisseurBanqueAccessFournisseur;

        return $this;
    }

    /**
     * Remove fournisseurBanqueAccessFournisseur
     *
     * @param \AMLA\SqrBundle\Entity\FournisseurBanqueAccess $fournisseurBanqueAccessFournisseur
     */
    public function removeFournisseurBanqueAccessFournisseur(\AMLA\SqrBundle\Entity\FournisseurBanqueAccess $fournisseurBanqueAccessFournisseur)
    {
        $this->fournisseurBanqueAccessFournisseur->removeElement($fournisseurBanqueAccessFournisseur);
    }

    /**
     * Get fournisseurBanqueAccessFournisseur
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFournisseurBanqueAccessFournisseur()
    {
        return $this->fournisseurBanqueAccessFournisseur;
    }


    /**
     * Set canCollectTax.
     *
     * @param int|null $canCollectTax
     *
     * @return Fournissseur
     */
    public function setCanCollectTax($canCollectTax = null)
    {
        $this->canCollectTax = $canCollectTax;

        return $this;
    }

    /**
     * Get canCollectTax.
     *
     * @return int|null
     */
    public function getCanCollectTax()
    {
        return $this->canCollectTax;
    }

    /**
     * Set montantGlobalFactureTtc.
     *
     * @param float|null $montantGlobalFactureTtc
     *
     * @return Fournissseur
     */
    public function setMontantGlobalFactureTtc($montantGlobalFactureTtc = null)
    {
        $this->montantGlobalFactureTtc = $montantGlobalFactureTtc;

        return $this;
    }

    /**
     * Get montantGlobalFactureTtc.
     *
     * @return float|null
     */
    public function getMontantGlobalFactureTtc()
    {
        return $this->montantGlobalFactureTtc;
    }

    /**
     * Set montantGlobalFactureHt.
     *
     * @param float|null $montantGlobalFactureHt
     *
     * @return Fournissseur
     */
    public function setMontantGlobalFactureHt($montantGlobalFactureHt = null)
    {
        $this->montantGlobalFactureHt = $montantGlobalFactureHt;

        return $this;
    }

    /**
     * Get montantGlobalFactureHt.
     *
     * @return float|null
     */
    public function getMontantGlobalFactureHt()
    {
        return $this->montantGlobalFactureHt;
    }

    /**
     * Set montantGlobalISFacture.
     *
     * @param float|null $montantGlobalISFacture
     *
     * @return Fournissseur
     */
    public function setMontantGlobalISFacture($montantGlobalISFacture = null)
    {
        $this->montantGlobalISFacture = $montantGlobalISFacture;

        return $this;
    }

    /**
     * Get montantGlobalISFacture.
     *
     * @return float|null
     */
    public function getMontantGlobalISFacture()
    {
        return $this->montantGlobalISFacture;
    }

    /**
     * Set montantGlobalTVAFacture.
     *
     * @param float|null $montantGlobalTVAFacture
     *
     * @return Fournissseur
     */
    public function setMontantGlobalTVAFacture($montantGlobalTVAFacture = null)
    {
        $this->montantGlobalTVAFacture = $montantGlobalTVAFacture;

        return $this;
    }

    /**
     * Get montantGlobalTVAFacture.
     *
     * @return float|null
     */
    public function getMontantGlobalTVAFacture()
    {
        return $this->montantGlobalTVAFacture;
    }

    /**
     * Set montantGlobalISEncaise.
     *
     * @param float|null $montantGlobalISEncaise
     *
     * @return Fournissseur
     */
    public function setMontantGlobalISEncaise($montantGlobalISEncaise = null)
    {
        $this->montantGlobalISEncaise = $montantGlobalISEncaise;

        return $this;
    }

    /**
     * Get montantGlobalISEncaise.
     *
     * @return float|null
     */
    public function getMontantGlobalISEncaise()
    {
        return $this->montantGlobalISEncaise;
    }

    /**
     * Set montantGlobalTVAEncaise.
     *
     * @param float|null $montantGlobalTVAEncaise
     *
     * @return Fournissseur
     */
    public function setMontantGlobalTVAEncaise($montantGlobalTVAEncaise = null)
    {
        $this->montantGlobalTVAEncaise = $montantGlobalTVAEncaise;

        return $this;
    }

    /**
     * Get montantGlobalTVAEncaise.
     *
     * @return float|null
     */
    public function getMontantGlobalTVAEncaise()
    {
        return $this->montantGlobalTVAEncaise;
    }

    /**
     * Set montantGlobalISRetenu.
     *
     * @param float|null $montantGlobalISRetenu
     *
     * @return Fournissseur
     */
    public function setMontantGlobalISRetenu($montantGlobalISRetenu = null)
    {
        $this->montantGlobalISRetenu = $montantGlobalISRetenu;

        return $this;
    }

    /**
     * Get montantGlobalISRetenu.
     *
     * @return float|null
     */
    public function getMontantGlobalISRetenu()
    {
        return $this->montantGlobalISRetenu;
    }

    /**
     * Set montantGlobalTVARetenu.
     *
     * @param float|null $montantGlobalTVARetenu
     *
     * @return Fournissseur
     */
    public function setMontantGlobalTVARetenu($montantGlobalTVARetenu = null)
    {
        $this->montantGlobalTVARetenu = $montantGlobalTVARetenu;

        return $this;
    }

    /**
     * Get montantGlobalTVARetenu.
     *
     * @return float|null
     */
    public function getMontantGlobalTVARetenu()
    {
        return $this->montantGlobalTVARetenu;
    }

    /**
     * Set montantGlobalISPaye.
     *
     * @param float|null $montantGlobalISPaye
     *
     * @return Fournissseur
     */
    public function setMontantGlobalISPaye($montantGlobalISPaye = null)
    {
        $this->montantGlobalISPaye = $montantGlobalISPaye;

        return $this;
    }

    /**
     * Get montantGlobalISPaye.
     *
     * @return float|null
     */
    public function getMontantGlobalISPaye()
    {
        return $this->montantGlobalISPaye;
    }

    /**
     * Set montantGlobalTVAPaye.
     *
     * @param float|null $montantGlobalTVAPaye
     *
     * @return Fournissseur
     */
    public function setMontantGlobalTVAPaye($montantGlobalTVAPaye = null)
    {
        $this->montantGlobalTVAPaye = $montantGlobalTVAPaye;

        return $this;
    }

    /**
     * Get montantGlobalTVAPaye.
     *
     * @return float|null
     */
    public function getMontantGlobalTVAPaye()
    {
        return $this->montantGlobalTVAPaye;
    }

    /**
     * Set montantGlobalTVAFactureRejete.
     *
     * @param float|null $montantGlobalTVAFactureRejete
     *
     * @return Fournissseur
     */
    public function setMontantGlobalTVAFactureRejete($montantGlobalTVAFactureRejete = null)
    {
        $this->montantGlobalTVAFactureRejete = $montantGlobalTVAFactureRejete;

        return $this;
    }

    /**
     * Get montantGlobalTVAFactureRejete.
     *
     * @return float|null
     */
    public function getMontantGlobalTVAFactureRejete()
    {
        return $this->montantGlobalTVAFactureRejete;
    }

    /**
     * Set montantGlobalISFactureRejete.
     *
     * @param float|null $montantGlobalISFactureRejete
     *
     * @return Fournissseur
     */
    public function setMontantGlobalISFactureRejete($montantGlobalISFactureRejete = null)
    {
        $this->montantGlobalISFactureRejete = $montantGlobalISFactureRejete;

        return $this;
    }

    /**
     * Get montantGlobalISFactureRejete.
     *
     * @return float|null
     */
    public function getMontantGlobalISFactureRejete()
    {
        return $this->montantGlobalISFactureRejete;
    }

    /**
     * Set isInBill.
     *
     * @param int|null $isInBill
     *
     * @return Fournissseur
     */
    public function setIsInBill($isInBill = null)
    {
        $this->isInBill = $isInBill;

        return $this;
    }

    /**
     * Get isInBill.
     *
     * @return int|null
     */
    public function getIsInBill()
    {
        return $this->isInBill;
    }

    /**
     * Set parentCompagny.
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur|null $parentCompagny
     *
     * @return Fournissseur
     */
    public function setParentCompagny(\AMLA\SqrBundle\Entity\Fournissseur $parentCompagny = null)
    {
        $this->parentCompagny = $parentCompagny;

        return $this;
    }

    /**
     * Get parentCompagny.
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur|null
     */
    public function getParentCompagny()
    {
        return $this->parentCompagny;
    }

    /**
     * Add parentCompagny.
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $parentCompagny
     *
     * @return Fournissseur
     */
    public function addParentCompagny(\AMLA\SqrBundle\Entity\Fournissseur $parentCompagny)
    {
        $this->parentCompagnies[] = $parentCompagny;

        return $this;
    }

    /**
     * Remove parentCompagny.
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $parentCompagny
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeParentCompagny(\AMLA\SqrBundle\Entity\Fournissseur $parentCompagny)
    {
        return $this->parentCompagnies->removeElement($parentCompagny);
    }

    /**
     * Get parentCompagnies.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getParentCompagnies()
    {
        return $this->parentCompagnies;
    }

    /**
     * Add freevending.
     *
     * @param \AMLA\SqrBundle\Entity\Freevending $freevending
     *
     * @return Fournissseur
     */
    public function addFreevending(\AMLA\SqrBundle\Entity\Freevending $freevending)
    {
        $this->freevending[] = $freevending;

        return $this;
    }

    /**
     * Remove freevending.
     *
     * @param \AMLA\SqrBundle\Entity\Freevending $freevending
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeFreevending(\AMLA\SqrBundle\Entity\Freevending $freevending)
    {
        return $this->freevending->removeElement($freevending);
    }

    /**
     * Get freevending.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFreevending()
    {
        return $this->freevending;
    }

    /**
     * Add compagnyUser.
     *
     * @param \AMLA\SqrBundle\Entity\Account $compagnyUser
     *
     * @return Fournissseur
     */
    public function addCompagnyUser(\AMLA\SqrBundle\Entity\Account $compagnyUser)
    {
        $this->compagnyUsers[] = $compagnyUser;

        return $this;
    }

    /**
     * Remove compagnyUser.
     *
     * @param \AMLA\SqrBundle\Entity\Account $compagnyUser
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeCompagnyUser(\AMLA\SqrBundle\Entity\Account $compagnyUser)
    {
        return $this->compagnyUsers->removeElement($compagnyUser);
    }

    /**
     * Get compagnyUsers.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getCompagnyUsers()
    {
        return $this->compagnyUsers;
    }

    /**
     * Add exchange.
     *
     * @param \AMLA\SqrBundle\Entity\Exchange $exchange
     *
     * @return Fournissseur
     */
    public function addExchange(\AMLA\SqrBundle\Entity\Exchange $exchange)
    {
        $this->exchange[] = $exchange;

        return $this;
    }

    /**
     * Remove exchange.
     *
     * @param \AMLA\SqrBundle\Entity\Exchange $exchange
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeExchange(\AMLA\SqrBundle\Entity\Exchange $exchange)
    {
        return $this->exchange->removeElement($exchange);
    }

    /**
     * Get exchange.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getExchange()
    {
        return $this->exchange;
    }

    /**
     * Add approvisionner.
     *
     * @param \AMLA\SqrBundle\Entity\Approvisionner $approvisionner
     *
     * @return Fournissseur
     */
    public function addApprovisionner(\AMLA\SqrBundle\Entity\Approvisionner $approvisionner)
    {
        $this->approvisionner[] = $approvisionner;

        return $this;
    }

    /**
     * Remove approvisionner.
     *
     * @param \AMLA\SqrBundle\Entity\Approvisionner $approvisionner
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeApprovisionner(\AMLA\SqrBundle\Entity\Approvisionner $approvisionner)
    {
        return $this->approvisionner->removeElement($approvisionner);
    }

    /**
     * Get approvisionner.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getApprovisionner()
    {
        return $this->approvisionner;
    }

    /**
     * Add factureSpontane.
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return Fournissseur
     */
    public function addFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane)
    {
        $this->factureSpontane[] = $factureSpontane;

        return $this;
    }

    /**
     * Remove factureSpontane.
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane)
    {
        return $this->factureSpontane->removeElement($factureSpontane);
    }

    /**
     * Get factureSpontane.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }

    /**
     * Set inBill.
     *
     * @param \AMLA\SqrBundle\Entity\InBill|null $inBill
     *
     * @return Fournissseur
     */
    public function setInBill(\AMLA\SqrBundle\Entity\InBill $inBill = null)
    {
        $this->inBill = $inBill;

        return $this;
    }

    /**
     * Get inBill.
     *
     * @return \AMLA\SqrBundle\Entity\InBill|null
     */
    public function getInBill()
    {
        return $this->inBill;
    }

    /**
     * Add repertoire.
     *
     * @param \AMLA\SqrBundle\Entity\Repertoire $repertoire
     *
     * @return Fournissseur
     */
    public function addRepertoire(\AMLA\SqrBundle\Entity\Repertoire $repertoire)
    {
        $this->repertoire[] = $repertoire;

        return $this;
    }

    /**
     * Remove repertoire.
     *
     * @param \AMLA\SqrBundle\Entity\Repertoire $repertoire
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeRepertoire(\AMLA\SqrBundle\Entity\Repertoire $repertoire)
    {
        return $this->repertoire->removeElement($repertoire);
    }

    /**
     * Get repertoire.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRepertoire()
    {
        return $this->repertoire;
    }
}
