<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FournisseurMoa
 *
 * @ORM\Table(name="fournisseur_moa")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FournisseurMoaRepository")
 */
class FournisseurMoa
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="fournisseurMoa")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="fournissseurMoa")
     * @ORM\JoinColumn(name="moa_id", referencedColumnName="id")
     */
    private $moa;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fournisseur
     *
     * @param integer $fournisseur
     *
     * @return FournisseurMoa
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set moa
     *
     * @param integer $moa
     *
     * @return FournisseurMoa
     */
    public function setMoa($moa)
    {
        $this->moa = $moa;

        return $this;
    }

    /**
     * Get moa
     *
     * @return int
     */
    public function getMoa()
    {
        return $this->moa;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return FournisseurMoa
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }
}
