<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FournisseurHabilite
 *
 * @ORM\Table(name="fournisseur_habilite")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FournisseurHabiliteRepository")
 */
class FournisseurHabilite
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="raisonSociale", type="string", length=150)
     */
    private $raisonSociale;

    /**
     * @var string
     *
     * @ORM\Column(name="sigle", type="string", length=100, nullable=true)
     */
    private $sigle;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=50)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="activitePrincipale", type="string", length=150)
     */
    private $activitePrincipale;

    /**
     * @var string
     *
     * @ORM\Column(name="regime", type="string", length=50)
     */
    private $regime;

    /**
     * @var string
     *
     * @ORM\Column(name="boitePostale", type="string", length=50, nullable=true)
     */
    private $boitePostale;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone", type="string", length=50)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=50)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="formeJuridique", type="string", length=50)
     */
    private $formeJuridique;

    /**
     * @var string
     *
     * @ORM\Column(name="cri", type="string", length=50)
     */
    private $cri;

    /**
     * @var string
     *
     * @ORM\Column(name="centreDeRattachement", type="string", length=50)
     */
    private $centreDeRattachement;

    /**
     * @var string
     *
     * @ORM\Column(name="regionAdministration", type="string", length=50)
     */
    private $regionAdministration;

    /**
     * @var string
     *
     * @ORM\Column(name="departement", type="string", length=50)
     */
    private $departement;

    /**
     * @var string
     *
     * @ORM\Column(name="ville", type="string", length=50)
     */
    private $ville;

    /**
     * @var string
     *
     * @ORM\Column(name="commune", type="string", length=50)
     */
    private $commune;

    /**
     * @var string
     *
     * @ORM\Column(name="quartier", type="string", length=50)
     */
    private $quartier;

    /**
     * @var string
     *
     * @ORM\Column(name="lieuxDit", type="string", length=50)
     */
    private $lieuxDit;

    /**
     * @var string
     *
     * @ORM\Column(name="etatNiu", type="string", length=50)
     */
    private $etatNiu;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="fournisseurHabilite")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 1;// 0=suspendu // 1= Actif 2=exclu
        $this->telephone = '+237';
        $this->etatNiu = '';
        $this->niu = '';
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set raisonSociale
     *
     * @param string $raisonSociale
     *
     * @return FournisseurHabilite
     */
    public function setRaisonSociale($raisonSociale)
    {
        $this->raisonSociale = $raisonSociale;

        return $this;
    }

    /**
     * Get raisonSociale
     *
     * @return string
     */
    public function getRaisonSociale()
    {
        return $this->raisonSociale;
    }

    /**
     * Set sigle
     *
     * @param string $sigle
     *
     * @return FournisseurHabilite
     */
    public function setSigle($sigle)
    {
        $this->sigle = $sigle;

        return $this;
    }

    /**
     * Get sigle
     *
     * @return string
     */
    public function getSigle()
    {
        return $this->sigle;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return FournisseurHabilite
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set activitePrincipale
     *
     * @param string $activitePrincipale
     *
     * @return FournisseurHabilite
     */
    public function setActivitePrincipale($activitePrincipale)
    {
        $this->activitePrincipale = $activitePrincipale;

        return $this;
    }

    /**
     * Get activitePrincipale
     *
     * @return string
     */
    public function getActivitePrincipale()
    {
        return $this->activitePrincipale;
    }

    /**
     * Set regime
     *
     * @param string $regime
     *
     * @return FournisseurHabilite
     */
    public function setRegime($regime)
    {
        $this->regime = $regime;

        return $this;
    }

    /**
     * Get regime
     *
     * @return string
     */
    public function getRegime()
    {
        return $this->regime;
    }

    /**
     * Set boitePostale
     *
     * @param string $boitePostale
     *
     * @return FournisseurHabilite
     */
    public function setBoitePostale($boitePostale)
    {
        $this->boitePostale = $boitePostale;

        return $this;
    }

    /**
     * Get boitePostale
     *
     * @return string
     */
    public function getBoitePostale()
    {
        return $this->boitePostale;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     *
     * @return FournisseurHabilite
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return FournisseurHabilite
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set formeJuridique
     *
     * @param string $formeJuridique
     *
     * @return FournisseurHabilite
     */
    public function setFormeJuridique($formeJuridique)
    {
        $this->formeJuridique = $formeJuridique;

        return $this;
    }

    /**
     * Get formeJuridique
     *
     * @return string
     */
    public function getFormeJuridique()
    {
        return $this->formeJuridique;
    }

    /**
     * Set cri
     *
     * @param string $cri
     *
     * @return FournisseurHabilite
     */
    public function setCri($cri)
    {
        $this->cri = $cri;

        return $this;
    }

    /**
     * Get cri
     *
     * @return string
     */
    public function getCri()
    {
        return $this->cri;
    }

    /**
     * Set centreDeRattachement
     *
     * @param string $centreDeRattachement
     *
     * @return FournisseurHabilite
     */
    public function setCentreDeRattachement($centreDeRattachement)
    {
        $this->centreDeRattachement = $centreDeRattachement;

        return $this;
    }

    /**
     * Get centreDeRattachement
     *
     * @return string
     */
    public function getCentreDeRattachement()
    {
        return $this->centreDeRattachement;
    }

    /**
     * Set regionAdministration
     *
     * @param string $regionAdministration
     *
     * @return FournisseurHabilite
     */
    public function setRegionAdministration($regionAdministration)
    {
        $this->regionAdministration = $regionAdministration;

        return $this;
    }

    /**
     * Get regionAdministration
     *
     * @return string
     */
    public function getRegionAdministration()
    {
        return $this->regionAdministration;
    }

    /**
     * Set departement
     *
     * @param string $departement
     *
     * @return FournisseurHabilite
     */
    public function setDepartement($departement)
    {
        $this->departement = $departement;

        return $this;
    }

    /**
     * Get departement
     *
     * @return string
     */
    public function getDepartement()
    {
        return $this->departement;
    }

    /**
     * Set ville
     *
     * @param string $ville
     *
     * @return FournisseurHabilite
     */
    public function setVille($ville)
    {
        $this->ville = $ville;

        return $this;
    }

    /**
     * Get ville
     *
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * Set commune
     *
     * @param string $commune
     *
     * @return FournisseurHabilite
     */
    public function setCommune($commune)
    {
        $this->commune = $commune;

        return $this;
    }

    /**
     * Get commune
     *
     * @return string
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * Set quartier
     *
     * @param string $quartier
     *
     * @return FournisseurHabilite
     */
    public function setQuartier($quartier)
    {
        $this->quartier = $quartier;

        return $this;
    }

    /**
     * Get quartier
     *
     * @return string
     */
    public function getQuartier()
    {
        return $this->quartier;
    }

    /**
     * Set lieuxDit
     *
     * @param string $lieuxDit
     *
     * @return FournisseurHabilite
     */
    public function setLieuxDit($lieuxDit)
    {
        $this->lieuxDit = $lieuxDit;

        return $this;
    }

    /**
     * Get lieuxDit
     *
     * @return string
     */
    public function getLieuxDit()
    {
        return $this->lieuxDit;
    }

    /**
     * Set etatNiu
     *
     * @param string $etatNiu
     *
     * @return FournisseurHabilite
     */
    public function setEtatNiu($etatNiu)
    {
        $this->etatNiu = $etatNiu;

        return $this;
    }

    /**
     * Get etatNiu
     *
     * @return string
     */
    public function getEtatNiu()
    {
        return $this->etatNiu;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return FournisseurHabilite
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return FournisseurHabilite
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return FournisseurHabilite
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }
}
