<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FournisseurBanqueAccess
 *
 * @ORM\Table(name="fournisseur_banque_access")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FournisseurBanqueAccessRepository")
 */
class FournisseurBanqueAccess
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="fournisseurBanqueAccessFournisseur")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="fournisseurBanqueAccessBanque")
     * @ORM\JoinColumn(name="banque_associe_id", referencedColumnName="id")
     */
    private $banque;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="integer")
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;// 0=En attente // 1= valide // 2=rejete (avec ou sans motif)
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fournisseur
     *
     * @param integer $fournisseur
     *
     * @return FournisseurBanqueAccess
     */
    public function setFournisseur($fournisseur)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return int
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set banque
     *
     * @param integer $banque
     *
     * @return FournisseurBanqueAccess
     */
    public function setBanque($banque)
    {
        $this->banque = $banque;

        return $this;
    }

    /**
     * Get banque
     *
     * @return int
     */
    public function getBanque()
    {
        return $this->banque;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return FournisseurBanqueAccess
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return int
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return FournisseurBanqueAccess
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
}
