<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FournisseurBanque
 *
 * @ORM\Table(name="fournisseur_banque")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FournisseurBanqueRepository")
 */
class FournisseurBanque
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="fournisseurbanque")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @ORM\ManyToOne(targetEntity="BanqueAssocie", inversedBy="fournisseurbanque")
     * @ORM\JoinColumn(name="banque_associe_id", referencedColumnName="id")
     */
    private $banque;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return FournisseurBanque
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return FournisseurBanque
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set banque
     *
     * @param \AMLA\SqrBundle\Entity\BanqueAssocie $banque
     *
     * @return FournisseurBanque
     */
    public function setBanque(\AMLA\SqrBundle\Entity\BanqueAssocie $banque = null)
    {
        $this->banque = $banque;

        return $this;
    }

    /**
     * Get banque
     *
     * @return \AMLA\SqrBundle\Entity\BanqueAssocie
     */
    public function getBanque()
    {
        return $this->banque;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return FournisseurBanque
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }
}
