<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FineItem
 *
 * @ORM\Table(name="fine_item")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FineItemRepository")
 */
class FineItem
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="codification", type="string", length=50)
     */
    private $codification;

    /**
     * @ORM\ManyToOne(targetEntity="FineCategory", inversedBy="fineItem")
     * @ORM\JoinColumn(name="fine_category_item", referencedColumnName="id")
     */
    private $fineCategory;

    /**
     * @var string
     *
     * @ORM\Column(name="intitule", type="string", length=255)
     */
    private $intitule;

    /**
     * @var float
     *
     * @ORM\Column(name="amount", type="float")
     */
    private $amount;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="Fine", mappedBy="fineItemMotif1")
     */
    private $fineMotif1;

    /**
     * @ORM\OneToMany(targetEntity="Fine", mappedBy="fineItemMotif2")
     */
    private $fineMotif2;

    /**
     * @ORM\OneToMany(targetEntity="Fine", mappedBy="fineItemMotif3")
     */
    private $fineMotif3;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->fineMotif1 = new \Doctrine\Common\Collections\ArrayCollection();
        $this->fineMotif2 = new \Doctrine\Common\Collections\ArrayCollection();
        $this->fineMotif3 = new \Doctrine\Common\Collections\ArrayCollection();
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;// 0=En attente // 1= validée // 2=rejetée (avec ou sans motif)
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codification
     *
     * @param string $codification
     *
     * @return FineItem
     */
    public function setCodification($codification)
    {
        $this->codification = $codification;

        return $this;
    }

    /**
     * Get codification
     *
     * @return string
     */
    public function getCodification()
    {
        return $this->codification;
    }

    /**
     * Set intitule
     *
     * @param string $intitule
     *
     * @return FineItem
     */
    public function setIntitule($intitule)
    {
        $this->intitule = $intitule;

        return $this;
    }

    /**
     * Get intitule
     *
     * @return string
     */
    public function getIntitule()
    {
        return $this->intitule;
    }

    /**
     * Set amount
     *
     * @param float $amount
     *
     * @return FineItem
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return FineItem
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return FineItem
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set fineCategory
     *
     * @param \AMLA\SqrBundle\Entity\FineCategory $fineCategory
     *
     * @return FineItem
     */
    public function setFineCategory(\AMLA\SqrBundle\Entity\FineCategory $fineCategory = null)
    {
        $this->fineCategory = $fineCategory;

        return $this;
    }

    /**
     * Get fineCategory
     *
     * @return \AMLA\SqrBundle\Entity\FineCategory
     */
    public function getFineCategory()
    {
        return $this->fineCategory;
    }

    /**
     * Add fineMotif1
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fineMotif1
     *
     * @return FineItem
     */
    public function addFineMotif1(\AMLA\SqrBundle\Entity\Fine $fineMotif1)
    {
        $this->fineMotif1[] = $fineMotif1;

        return $this;
    }

    /**
     * Remove fineMotif1
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fineMotif1
     */
    public function removeFineMotif1(\AMLA\SqrBundle\Entity\Fine $fineMotif1)
    {
        $this->fineMotif1->removeElement($fineMotif1);
    }

    /**
     * Get fineMotif1
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFineMotif1()
    {
        return $this->fineMotif1;
    }

    /**
     * Add fineMotif2
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fineMotif2
     *
     * @return FineItem
     */
    public function addFineMotif2(\AMLA\SqrBundle\Entity\Fine $fineMotif2)
    {
        $this->fineMotif2[] = $fineMotif2;

        return $this;
    }

    /**
     * Remove fineMotif2
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fineMotif2
     */
    public function removeFineMotif2(\AMLA\SqrBundle\Entity\Fine $fineMotif2)
    {
        $this->fineMotif2->removeElement($fineMotif2);
    }

    /**
     * Get fineMotif2
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFineMotif2()
    {
        return $this->fineMotif2;
    }

    /**
     * Add fineMotif3
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fineMotif3
     *
     * @return FineItem
     */
    public function addFineMotif3(\AMLA\SqrBundle\Entity\Fine $fineMotif3)
    {
        $this->fineMotif3[] = $fineMotif3;

        return $this;
    }

    /**
     * Remove fineMotif3
     *
     * @param \AMLA\SqrBundle\Entity\Fine $fineMotif3
     */
    public function removeFineMotif3(\AMLA\SqrBundle\Entity\Fine $fineMotif3)
    {
        $this->fineMotif3->removeElement($fineMotif3);
    }

    /**
     * Get fineMotif3
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFineMotif3()
    {
        return $this->fineMotif3;
    }
}
