<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FineCategory
 *
 * @ORM\Table(name="fine_category")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FineCategoryRepository")
 */
class FineCategory
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="codification", type="string", length=50)
     */
    private $codification;

    /**
     * @var string
     *
     * @ORM\Column(name="intitule", type="string", length=255)
     */
    private $intitule;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="integer")
     */
    private $statut;

    /**
     * @ORM\OneToMany(targetEntity="FineItem", mappedBy="fineCategory")
     */
    private $fineItem;


    function __construct()
    {
        $this->fineItem = new \Doctrine\Common\Collections\ArrayCollection();
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;// 0=En attente // 1= validée // 2=rejetée (avec ou sans motif)
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codification
     *
     * @param string $codification
     *
     * @return FineCategory
     */
    public function setCodification($codification)
    {
        $this->codification = $codification;

        return $this;
    }

    /**
     * Get codification
     *
     * @return string
     */
    public function getCodification()
    {
        return $this->codification;
    }

    /**
     * Set intitule
     *
     * @param string $intitule
     *
     * @return FineCategory
     */
    public function setIntitule($intitule)
    {
        $this->intitule = $intitule;

        return $this;
    }

    /**
     * Get intitule
     *
     * @return string
     */
    public function getIntitule()
    {
        return $this->intitule;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return FineCategory
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return int
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Add fineItem
     *
     * @param \AMLA\SqrBundle\Entity\FineITem $fineItem
     *
     * @return FineCategory
     */
    public function addFineItem(\AMLA\SqrBundle\Entity\FineITem $fineItem)
    {
        $this->fineItem[] = $fineItem;

        return $this;
    }

    /**
     * Remove fineItem
     *
     * @param \AMLA\SqrBundle\Entity\FineITem $fineItem
     */
    public function removeFineItem(\AMLA\SqrBundle\Entity\FineITem $fineItem)
    {
        $this->fineItem->removeElement($fineItem);
    }

    /**
     * Get fineItem
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFineItem()
    {
        return $this->fineItem;
    }
}
