<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Fine
 *
 * @ORM\Table(name="fine")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FineRepository")
 */
class Fine
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="fine")
     * @ORM\JoinColumn(name="qrcode_transaction_number_id", referencedColumnName="id")
     */
    private $transactionNumber;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;
    
    /**
     * @var string
     *
     * @ORM\Column(name="sqrId", type="string", length=50)
     */
    private $sqrId;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=50)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="typePiece", type="string", length=50)
     */
    private $typePiece;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone", type="string", length=50)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="pieceNumber", type="string", length=50)
     */
    private $pieceNumber;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateIssuedPiece", type="date")
     */
    private $dateIssuedPiece;

    /**
     * @var string
     *
     * @ORM\Column(name="placeIssuedPiece", type="string", length=50)
     */
    private $placeIssuedPiece;

    /**
     * @ORM\ManyToOne(targetEntity="FineItem", inversedBy="fineMotif1")
     * @ORM\JoinColumn(name="fine_item_motif1", referencedColumnName="id")
     */
    private $fineItemMotif1;

    /**
     * @var string
     *
     * @ORM\Column(name="localite1", type="string", length=255)
     */
    private $localite1;

    /**
     * @ORM\ManyToOne(targetEntity="FineItem", inversedBy="fineMotif2")
     * @ORM\JoinColumn(name="fine_item_motif3", referencedColumnName="id")
     */
    private $fineItemMotif2;

    /**
     * @var string
     *
     * @ORM\Column(name="localite2", type="string", length=255, nullable=true)
     */
    private $localite2;

    /**
     * @ORM\ManyToOne(targetEntity="FineItem", inversedBy="fineMotif3")
     * @ORM\JoinColumn(name="fine_item_motif3", referencedColumnName="id")
     */
    private $fineItemMotif3;

    /**
     * @var string
     *
     * @ORM\Column(name="localite3", type="string", length=255, nullable=true)
     */
    private $localite3;

    /**
     * @var float
     *
     * @ORM\Column(name="frais", type="float")
     */
    private $frais;

    /**
     * @var float
     *
     * @ORM\Column(name="total", type="float")
     */
    private $total;

    /**
     * @var string
     *
     * @ORM\Column(name="matriculeVerbaliseur", type="string", length=50, nullable=true)
     */
    private $matriculeVerbaliseur;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * @var bool
     *
     * @ORM\Column(name="isPaid", type="boolean")
     */
    private $isPaid;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="fine")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity="Quittance", inversedBy="fine")
     * @ORM\JoinColumn(name="quittance_id", referencedColumnName="id")
     */
    private $quittance;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;// 0=En attente // 1= validée // 2=rejetée (avec ou sans motif)
        $this->isPaid = 0; //0=non payé 1 = payé
        $this->frais = 1200; 
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Fine
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set sqrId
     *
     * @param integer $sqrId
     *
     * @return Fine
     */
    public function setSqrId($sqrId)
    {
        $this->sqrId = $sqrId;

        return $this;
    }

    /**
     * Get sqrId
     *
     * @return integer
     */
    public function getSqrId()
    {
        return $this->sqrId;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return Fine
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set typePiece
     *
     * @param string $typePiece
     *
     * @return Fine
     */
    public function setTypePiece($typePiece)
    {
        $this->typePiece = $typePiece;

        return $this;
    }

    /**
     * Get typePiece
     *
     * @return string
     */
    public function getTypePiece()
    {
        return $this->typePiece;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     *
     * @return Fine
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set pieceNumber
     *
     * @param string $pieceNumber
     *
     * @return Fine
     */
    public function setPieceNumber($pieceNumber)
    {
        $this->pieceNumber = $pieceNumber;

        return $this;
    }

    /**
     * Get pieceNumber
     *
     * @return string
     */
    public function getPieceNumber()
    {
        return $this->pieceNumber;
    }

    /**
     * Set dateIssuedPiece
     *
     * @param \DateTime $dateIssuedPiece
     *
     * @return Fine
     */
    public function setDateIssuedPiece($dateIssuedPiece)
    {
        $this->dateIssuedPiece = $dateIssuedPiece;

        return $this;
    }

    /**
     * Get dateIssuedPiece
     *
     * @return \DateTime
     */
    public function getDateIssuedPiece()
    {
        return $this->dateIssuedPiece;
    }

    /**
     * Set placeIssuedPiece
     *
     * @param string $placeIssuedPiece
     *
     * @return Fine
     */
    public function setPlaceIssuedPiece($placeIssuedPiece)
    {
        $this->placeIssuedPiece = $placeIssuedPiece;

        return $this;
    }

    /**
     * Get placeIssuedPiece
     *
     * @return string
     */
    public function getPlaceIssuedPiece()
    {
        return $this->placeIssuedPiece;
    }

    /**
     * Set localite1
     *
     * @param string $localite1
     *
     * @return Fine
     */
    public function setLocalite1($localite1)
    {
        $this->localite1 = $localite1;

        return $this;
    }

    /**
     * Get localite1
     *
     * @return string
     */
    public function getLocalite1()
    {
        return $this->localite1;
    }

    /**
     * Set localite2
     *
     * @param string $localite2
     *
     * @return Fine
     */
    public function setLocalite2($localite2)
    {
        $this->localite2 = $localite2;

        return $this;
    }

    /**
     * Get localite2
     *
     * @return string
     */
    public function getLocalite2()
    {
        return $this->localite2;
    }

    /**
     * Set localite3
     *
     * @param string $localite3
     *
     * @return Fine
     */
    public function setLocalite3($localite3)
    {
        $this->localite3 = $localite3;

        return $this;
    }

    /**
     * Get localite3
     *
     * @return string
     */
    public function getLocalite3()
    {
        return $this->localite3;
    }

    /**
     * Set frais
     *
     * @param float $frais
     *
     * @return Fine
     */
    public function setFrais($frais)
    {
        $this->frais = $frais;

        return $this;
    }

    /**
     * Get frais
     *
     * @return float
     */
    public function getFrais()
    {
        return $this->frais;
    }

    /**
     * Set total
     *
     * @param float $total
     *
     * @return Fine
     */
    public function setTotal(/*$total*/ $frais)
    {
        $total = 0;
        if (!empty($this->getFineItemMotif1())) 
        {
            $total = $total + $this->getFineItemMotif1()->getAmount();
        }

        if (!empty($this->getFineItemMotif2())) 
        {
            $total = $total + $this->getFineItemMotif2()->getAmount();
        }

        if (!empty($this->getFineItemMotif3())) 
        {
            $total = $total + $this->getFineItemMotif3()->getAmount();
        }

        $total = $total+$frais;

        $this->total = $total;

        return $this;
    }

    /**
     * Get total
     *
     * @return float
     */
    public function getTotal()
    {
        return $this->total;
    }

    /**
     * Set matriculeVerbaliseur
     *
     * @param string $matriculeVerbaliseur
     *
     * @return Fine
     */
    public function setMatriculeVerbaliseur($matriculeVerbaliseur)
    {
        $this->matriculeVerbaliseur = $matriculeVerbaliseur;

        return $this;
    }

    /**
     * Get matriculeVerbaliseur
     *
     * @return string
     */
    public function getMatriculeVerbaliseur()
    {
        return $this->matriculeVerbaliseur;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return Fine
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set isPaid
     *
     * @param boolean $isPaid
     *
     * @return Fine
     */
    public function setIsPaid($isPaid)
    {
        $this->isPaid = $isPaid;

        return $this;
    }

    /**
     * Get isPaid
     *
     * @return boolean
     */
    public function getIsPaid()
    {
        return $this->isPaid;
    }

    /**
     * Set transactionNumber
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $transactionNumber
     *
     * @return Fine
     */
    public function setTransactionNumber(\AMLA\SqrBundle\Entity\CheckQr $transactionNumber = null)
    {
        $this->transactionNumber = $transactionNumber;

        return $this;
    }

    /**
     * Get transactionNumber
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getTransactionNumber()
    {
        return $this->transactionNumber;
    }

    /**
     * Set fineItemMotif1
     *
     * @param \AMLA\SqrBundle\Entity\FineItem $fineItemMotif1
     *
     * @return Fine
     */
    public function setFineItemMotif1(\AMLA\SqrBundle\Entity\FineItem $fineItemMotif1 = null)
    {
        $this->fineItemMotif1 = $fineItemMotif1;

        return $this;
    }

    /**
     * Get fineItemMotif1
     *
     * @return \AMLA\SqrBundle\Entity\FineItem
     */
    public function getFineItemMotif1()
    {
        return $this->fineItemMotif1;
    }

    /**
     * Set fineItemMotif2
     *
     * @param \AMLA\SqrBundle\Entity\FineItem $fineItemMotif2
     *
     * @return Fine
     */
    public function setFineItemMotif2(\AMLA\SqrBundle\Entity\FineItem $fineItemMotif2 = null)
    {
        $this->fineItemMotif2 = $fineItemMotif2;

        return $this;
    }

    /**
     * Get fineItemMotif2
     *
     * @return \AMLA\SqrBundle\Entity\FineItem
     */
    public function getFineItemMotif2()
    {
        return $this->fineItemMotif2;
    }

    /**
     * Set fineItemMotif3
     *
     * @param \AMLA\SqrBundle\Entity\FineItem $fineItemMotif3
     *
     * @return Fine
     */
    public function setFineItemMotif3(\AMLA\SqrBundle\Entity\FineItem $fineItemMotif3 = null)
    {
        $this->fineItemMotif3 = $fineItemMotif3;

        return $this;
    }

    /**
     * Get fineItemMotif3
     *
     * @return \AMLA\SqrBundle\Entity\FineItem
     */
    public function getFineItemMotif3()
    {
        return $this->fineItemMotif3;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return Fine
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set quittance
     *
     * @param \AMLA\SqrBundle\Entity\Quittance $quittance
     *
     * @return Fine
     */
    public function setQuittance(\AMLA\SqrBundle\Entity\Quittance $quittance = null)
    {
        $this->quittance = $quittance;

        return $this;
    }

    /**
     * Get quittance
     *
     * @return \AMLA\SqrBundle\Entity\Quittance
     */
    public function getQuittance()
    {
        return $this->quittance;
    }
}
