<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Financier
 *
 * @ORM\Table(name="financier")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FinancierRepository")
 */
class Financier
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=255)
     */
    private $reference;

    /**
     * @ORM\ManyToOne(targetEntity="SoummissionOffre", inversedBy="financiers")
     * @ORM\JoinColumn(name="soummission_offre_id", referencedColumnName="id", nullable=true)
     */
    private $soumission;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="financier")
     */
    private $documents;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return Financier
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return Financier
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return int
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Financier
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
    /**
     * Constructor
     */
    public function __construct()
    {
        $this->documents = new \Doctrine\Common\Collections\ArrayCollection();
        $this->reference = 'DOC_FINANC_'.date('Ymd',time()).mt_rand(0,10);
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 1;
    }

    /**
     * Set soumission
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumission
     *
     * @return Financier
     */
    public function setSoumission(\AMLA\SqrBundle\Entity\SoummissionOffre $soumission = null)
    {
        $this->soumission = $soumission;

        return $this;
    }

    /**
     * Get soumission
     *
     * @return \AMLA\SqrBundle\Entity\SoummissionOffre
     */
    public function getSoumission()
    {
        return $this->soumission;
    }

    /**
     * Add document
     *
     * @param \AMLA\SqrBundle\Entity\Document $document
     *
     * @return Financier
     */
    public function addDocument(\AMLA\SqrBundle\Entity\Document $document)
    {
        $this->documents[] = $document;

        return $this;
    }

    /**
     * Remove document
     *
     * @param \AMLA\SqrBundle\Entity\Document $document
     */
    public function removeDocument(\AMLA\SqrBundle\Entity\Document $document)
    {
        $this->documents->removeElement($document);
    }

    /**
     * Get documents
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getDocuments()
    {
        return $this->documents;
    }
}
