<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FactureSpontaneService
 *
 * @ORM\Table(name="facture_spontane_service")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FactureSpontaneServiceRepository")
 */
class FactureSpontaneService
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="FactureSpontane", inversedBy="factureSpontaneService")
     * @ORM\JoinColumn(name="facture_spontane_id", referencedColumnName="id")
     */
    private $factureSpontane;

    /**
     * @var int
     *
     * @ORM\Column(name="quantite", type="integer")
     */
    private $quantite;

    /**
     * @var string
     *
     * @ORM\Column(name="codeService", type="string", length=50, nullable=true)
     */
    private $codeService;

    /**
     * @var string
     *
     * @ORM\Column(name="designation", type="text")
     */
    private $designation;

    /**
     * @var string
     *
     * @ORM\Column(name="codeMercuriale", type="string", length=50, nullable=true)
     */
    private $codeMercuriale;

    /**
     * @var float
     *
     * @ORM\Column(name="prix", type="float")
     */
    private $prix=0;

    /**
     * @var float
     *
     * @ORM\Column(name="prixHt", type="float")
     */
    private $prixHt=0;

    /**
     * @var float
     *
     * @ORM\Column(name="prixTtc", type="float")
     */
    private $prixTtc=0;

    /**
     * @var float|null
     *
     * @ORM\Column(name="tva", type="float", nullable=true)
     */
    private $tva=0;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
    }


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set quantite.
     *
     * @param int $quantite
     *
     * @return FactureSpontaneService
     */
    public function setQuantite($quantite)
    {
        $this->quantite = $quantite;

        return $this;
    }

    /**
     * Get quantite.
     *
     * @return int
     */
    public function getQuantite()
    {
        return $this->quantite;
    }

    /**
     * Set codeService.
     *
     * @param string $codeService
     *
     * @return FactureSpontaneService
     */
    public function setCodeService($codeService)
    {
        $this->codeService = $codeService;

        return $this;
    }

    /**
     * Get codeService.
     *
     * @return string
     */
    public function getCodeService()
    {
        return $this->codeService;
    }

    /**
     * Set designation.
     *
     * @param string $designation
     *
     * @return FactureSpontaneService
     */
    public function setDesignation($designation)
    {
        $this->designation = $designation;

        return $this;
    }

    /**
     * Get designation.
     *
     * @return string
     */
    public function getDesignation()
    {
        return $this->designation;
    }

    /**
     * Set codeMercuriale.
     *
     * @param string $codeMercuriale
     *
     * @return FactureSpontaneService
     */
    public function setCodeMercuriale($codeMercuriale)
    {
        $this->codeMercuriale = $codeMercuriale;

        return $this;
    }

    /**
     * Get codeMercuriale.
     *
     * @return string
     */
    public function getCodeMercuriale()
    {
        return $this->codeMercuriale;
    }

    /**
     * Set prix.
     *
     * @param float $prix
     *
     * @return FactureSpontaneService
     */
    public function setPrix($prix)
    {
        $this->prix = $prix;

        return $this;
    }

    /**
     * Get prix.
     *
     * @return float
     */
    public function getPrix()
    {
        return $this->prix;
    }

    /**
     * Set prixHt.
     *
     * @param float $prixHt
     *
     * @return FactureSpontaneService
     */
    public function setPrixHt($prixHt)
    {
        $this->prixHt = $prixHt;

        return $this;
    }

    /**
     * Get prixHt.
     *
     * @return float
     */
    public function getPrixHt()
    {
        return $this->prixHt;
    }

    /**
     * Set prixTtc.
     *
     * @param float $prixTtc
     *
     * @return FactureSpontaneService
     */
    public function setPrixTtc($prixTtc)
    {
        $this->prixTtc = $prixTtc;

        return $this;
    }

    /**
     * Get prixTtc.
     *
     * @return float
     */
    public function getPrixTtc()
    {
        return $this->prixTtc;
    }

    /**
     * Set tva.
     *
     * @param float|null $tva
     *
     * @return FactureSpontaneService
     */
    public function setTva($tva = null)
    {
        $this->tva = $tva;

        return $this;
    }

    /**
     * Get tva.
     *
     * @return float|null
     */
    public function getTva()
    {
        return $this->tva;
    }

    /**
     * Set dateCreated.
     *
     * @param \DateTime $dateCreated
     *
     * @return FactureSpontaneService
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated.
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set factureSpontane.
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane|null $factureSpontane
     *
     * @return FactureSpontaneService
     */
    public function setFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane = null)
    {
        $this->factureSpontane = $factureSpontane;

        return $this;
    }

    /**
     * Get factureSpontane.
     *
     * @return \AMLA\SqrBundle\Entity\FactureSpontane|null
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }
}
