<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FactureSpontaneCommentaire
 *
 * @ORM\Table(name="facture_spontane_commentaire")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FactureSpontaneCommentaireRepository")
 */
class FactureSpontaneCommentaire
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="factureSpontane", type="integer")
     */
    private $factureSpontane;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var string
     *
     * @ORM\Column(name="commentaire", type="text")
     */
    private $commentaire;

    /**
     * @var int
     *
     * @ORM\Column(name="account", type="integer")
     */
    private $account;


    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set factureSpontane.
     *
     * @param int $factureSpontane
     *
     * @return FactureSpontaneCommentaire
     */
    public function setFactureSpontane($factureSpontane)
    {
        $this->factureSpontane = $factureSpontane;

        return $this;
    }

    /**
     * Get factureSpontane.
     *
     * @return int
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }

    /**
     * Set dateCreated.
     *
     * @param \DateTime $dateCreated
     *
     * @return FactureSpontaneCommentaire
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated.
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set commentaire.
     *
     * @param string $commentaire
     *
     * @return FactureSpontaneCommentaire
     */
    public function setCommentaire($commentaire)
    {
        $this->commentaire = $commentaire;

        return $this;
    }

    /**
     * Get commentaire.
     *
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * Set account.
     *
     * @param int $account
     *
     * @return FactureSpontaneCommentaire
     */
    public function setAccount($account)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account.
     *
     * @return int
     */
    public function getAccount()
    {
        return $this->account;
    }
}
