<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FactureSpontaneArticle
 *
 * @ORM\Table(name="facture_spontane_article")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FactureSpontaneArticleRepository")
 */
class FactureSpontaneArticle
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="FactureSpontane", inversedBy="factureSpontaneArticle")
     * @ORM\JoinColumn(name="facture_spontane_id", referencedColumnName="id")
     */
    private $factureSpontane;

    /**
     * @var string
     *
     * @ORM\Column(name="nom_article", type="string", length=255)
     */
    private $nomArticle;

    /**
     * @var int
     *
     * @ORM\Column(name="quantite", type="integer")
     */
    private $quantite;

    /**
     * @var string
     *
     * @ORM\Column(name="codeProduit", type="string", length=50, nullable=true)
     */
    private $codeProduit;

    /**
     * @var string
     *
     * @ORM\Column(name="codeMercuriale", type="string", length=50, nullable=true)
     */
    private $codeMercuriale;

    /**
     * @var float
     *
     * @ORM\Column(name="prix", type="float")
     */
    private $prix=0;

    /**
     * @var float
     *
     * @ORM\Column(name="prix_ht", type="float")
     */
    private $prixHt=0;

    /**
     * @var float
     *
     * @ORM\Column(name="prix_ttc", type="float")
     */
    private $prixTtc=0;

    /**
     * @var float
     *
     * @ORM\Column(name="tva", type="float")
     */
    private $tva=0;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set nomArticle
     *
     * @param string $nomArticle
     *
     * @return FactureSpontaneArticle
     */
    public function setNomArticle($nomArticle)
    {
        $this->nomArticle = $nomArticle;

        return $this;
    }

    /**
     * Get nomArticle
     *
     * @return string
     */
    public function getNomArticle()
    {
        return $this->nomArticle;
    }

    /**
     * Set quantite
     *
     * @param integer $quantite
     *
     * @return FactureSpontaneArticle
     */
    public function setQuantite($quantite)
    {
        $this->quantite = $quantite;

        return $this;
    }

    /**
     * Get quantite
     *
     * @return integer
     */
    public function getQuantite()
    {
        return $this->quantite;
    }

    /**
     * Set prix
     *
     * @param float $prix
     *
     * @return FactureSpontaneArticle
     */
    public function setPrix($prix)
    {
        $this->prix = $prix;

        return $this;
    }

    /**
     * Get prix
     *
     * @return float
     */
    public function getPrix()
    {
        return $this->prix;
    }

    /**
     * Set prixHt
     *
     * @param float $prixHt
     *
     * @return FactureSpontaneArticle
     */
    public function setPrixHt($prixHt)
    {
        $this->prixHt = $prixHt;

        return $this;
    }

    /**
     * Get prixHt
     *
     * @return float
     */
    public function getPrixHt()
    {
        return $this->prixHt;
    }

    /**
     * Set prixTtc
     *
     * @param float $prixTtc
     *
     * @return FactureSpontaneArticle
     */
    public function setPrixTtc($prixTtc)
    {
        $this->prixTtc = $prixTtc;

        return $this;
    }

    /**
     * Get prixTtc
     *
     * @return float
     */
    public function getPrixTtc()
    {
        return $this->prixTtc;
    }

    /**
     * Set tva
     *
     * @param float $tva
     *
     * @return FactureSpontaneArticle
     */
    public function setTva($tva)
    {
        $this->tva = $tva;

        return $this;
    }

    /**
     * Get tva
     *
     * @return float
     */
    public function getTva()
    {
        return $this->tva;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return FactureSpontaneArticle
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set factureSpontane
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane
     *
     * @return FactureSpontaneArticle
     */
    public function setFactureSpontane(\AMLA\SqrBundle\Entity\FactureSpontane $factureSpontane = null)
    {
        $this->factureSpontane = $factureSpontane;

        return $this;
    }

    /**
     * Get factureSpontane
     *
     * @return \AMLA\SqrBundle\Entity\FactureSpontane
     */
    public function getFactureSpontane()
    {
        return $this->factureSpontane;
    }

    /**
     * Set codeProduit
     *
     * @param string $codeProduit
     *
     * @return FactureSpontaneArticle
     */
    public function setCodeProduit($codeProduit)
    {
        $this->codeProduit = $codeProduit;

        return $this;
    }

    /**
     * Get codeProduit
     *
     * @return string
     */
    public function getCodeProduit()
    {
        return $this->codeProduit;
    }

    /**
     * Set codeMercuriale
     *
     * @param string $codeMercuriale
     *
     * @return FactureSpontaneArticle
     */
    public function setCodeMercuriale($codeMercuriale)
    {
        $this->codeMercuriale = $codeMercuriale;

        return $this;
    }

    /**
     * Get codeMercuriale
     *
     * @return string
     */
    public function getCodeMercuriale()
    {
        return $this->codeMercuriale;
    }
}
