<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FactureSpontane
 *
 * @ORM\Table(name="facture_spontane")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FactureSpontaneRepository")
 */
class FactureSpontane
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="factureSpontane")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="factureSpontane")
     * @ORM\JoinColumn(name="fournisseur_id", referencedColumnName="id")
     */
    private $fournisseur; 

    /**
     * @ORM\ManyToOne(targetEntity="InBill", inversedBy="factureSpontane")
     * @ORM\JoinColumn(name="in_billt_id", referencedColumnName="id")
     */
    private $inBill;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="factureSpontane")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var string
     *
     * @ORM\Column(name="beneficiaireNiu", type="string", length=255, nullable=true)
     */
    private $beneficiaireNiu;

    /**
     * @var bool
     *
     * @ORM\Column(name="$is_secured", type="boolean", nullable=true)
     */
    private $isSecured;//1=reporté 0 = new

    /**
     * @var bool
     *
     * @ORM\Column(name="$is_Payment_Accepted", type="boolean", nullable=true)
     */
    private $isPaymentAccepted;//1=reporté 0 = new

    /**
     * @var bool
     *
     * @ORM\Column(name="isSecteurPublique", type="boolean", nullable=true)
     */
    private $isSecteurPublique;//1=oui 0 = non
 
    /**
     * @var string
     *
     * @ORM\Column(name="referenceFacture", type="string", length=50, nullable=true)
     */
    private $referenceFacture;
 
    /**
     * @var DateTime
     *
     * @ORM\Column(name="dateFacture", type="datetime", nullable=true)
     */
    private $dateFacture;
 
    /**
     * @var string
     *
     * @ORM\Column(name="referenceImpot", type="string", length=50, nullable=true)
     */
    private $referenceImpot;

    /**
     * @var string
     *
     * @ORM\Column(name="beneficiaireEmail", type="string", length=50)
     */
    private $beneficiaireEmail;

    /**
     * @var string
     *
     * @ORM\Column(name="beneficiaireSocialReason", type="string", length=255, nullable=true)
     */
    private $beneficiaireSocialReason;

    /**
     * @var string
     *
     * @ORM\Column(name="beneficiaireTelephone", type="string", length=20, nullable=true)
     */
    private $beneficiaireTelephone;

    /**
     * @var string
     *
     * @ORM\Column(name="emetteurTelephone", type="string", length=20, nullable=true)
     */
    private $emetteurTelephone;

    /**
     * @var string
     *
     * @ORM\Column(name="modeReglement", type="string", length=20, nullable=true)
     */
    private $modeReglement;

    /**
     * @var string
     *
     * @ORM\Column(name="telephoneMomoReglement", type="string", length=20, nullable=true)
     */
    private $telephoneMomoReglement;

    /**
     * @var string
     *
     * @ORM\Column(name="banqueReglement", type="string", length=20, nullable=true)
     */
    private $banqueReglement;

    /**
     * @var string
     *
     * @ORM\Column(name="numcomptebanqueReglement", type="string", length=20, nullable=true)
     */
    private $numcomptebanqueReglement;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=255, nullable=true)
     */
    private $reference;
    
    /**
     * @var string
     *
     * @ORM\Column(name="objet", type="string", length=255)
     */
    private $objet;

    /**
     * @var string
     *
     * @ORM\Column(name="attn", type="string", length=255)
     */
    private $attn;

    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=255)
     */
    private $pdf;

    /**
     * @ORM\OneToMany(targetEntity="FactureSpontaneArticle", mappedBy="factureSpontane")
    */
    private $factureSpontaneArticle;

    /**
     * @ORM\OneToMany(targetEntity="FactureSpontaneService", mappedBy="factureSpontane")
    */
    private $factureSpontaneService;

    /**
     * @var float
     *
     * @ORM\Column(name="montant_total_ht", type="float")
     */
    private $montantTotalHt=0;

    /**
     * @var float
     *
     * @ORM\Column(name="montant_total_ttc", type="float")
     */
    private $montantTotalTtc=0;

    /**
     * @var float
     *
     * @ORM\Column(name="reste_a_payer", type="float")
     */
    private $resteAPayer=0;

    /**
     * @var float
     *
     * @ORM\Column(name="netApayer", type="float")
     */
    private $netApayer=0;

    /**
     * @var float
     *
     * @ORM\Column(name="tva", type="float")
     */
    private $tva=0;

    /**
     * @var float
     *
     * @ORM\Column(name="montantTotalTva", type="float")
     */
    private $montantTotalTva=0;    

    /**
     * @var float
     *
     * @ORM\Column(name="ir", type="float")
     */
    private $ir=0;

    /**
     * @var float
     *
     * @ORM\Column(name="irMontant", type="float")
     */
    private $irMontant=0;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="integer")
     */
    private $statut;

    /**
     * @ORM\OneToMany(targetEntity="TvaHistory", mappedBy="factureSpontane")
     */
    private $tvaHistory;

    /**
     * @ORM\OneToMany(targetEntity="Quittance", mappedBy="factureSpontane")
     */
    private $quittance;

    /**
     * @ORM\OneToMany(targetEntity="PlanifierPaiement", mappedBy="factureSpontane")
     */
    private $planifierPaiement;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var boolean
     *
     * @ORM\Column(name="isInBillFacture", type="smallint", nullable=true)
     */
    private $isInBillFacture; // si c'est un une facture ou pas

    /**
     * @var boolean
     *
     * @ORM\Column(name="isInBillDevis", type="smallint", nullable=true)
     */
    private $isInBillDevis; // si c'est un devis ou pas
    
    /**
     * @var string
     *
     * @ORM\Column(name="categorie", type="string", length=20, nullable=true)
     */
    private $categorie; // public / privée
    
    /**
     * @var string
     *
     * @ORM\Column(name="type", type="string", length=20, nullable=true)
     */
    private $type;// ceci défini les différents types devis facture inbill ou pas

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;//0=En attente // 1= Payée // 2=rejetée (avec ou sans motif)
        //$this->reference = 'SP_'.$this->randomString();
        $this->tva = "19.25";
    }

    /*
     * Create a random string
     * @author  Cedric Rio
     * @param $length the length of the string to create
     * @return $str the string
     */
    function randomString($length = 3)
    {
        $str = "";
        //$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
        $characters = array_merge(range('A','Z'), range('0','9'));
        $max = count($characters) - 1;

        date_default_timezone_set('Africa/Douala');
        $date = date('hiy', time());

        for ($i = 0; $i < $length; $i++)
        {
            $rand = mt_rand(0, $max);
            $str .= $characters[$rand];
        }
        $codeUnique=$str.''.$date;
        return $codeUnique;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set beneficiaireNiu
     *
     * @param string $beneficiaireNiu
     *
     * @return FactureSpontane
     */
    public function setBeneficiaireNiu($beneficiaireNiu)
    {
        $this->beneficiaireNiu = $beneficiaireNiu;

        return $this;
    }

    /**
     * Get beneficiaireNiu
     *
     * @return string
     */
    public function getBeneficiaireNiu()
    {
        return $this->beneficiaireNiu;
    }

    /**
     * Set beneficiaireEmail
     *
     * @param string $beneficiaireEmail
     *
     * @return FactureSpontane
     */
    public function setBeneficiaireEmail($beneficiaireEmail)
    {
        $this->beneficiaireEmail = $beneficiaireEmail;

        return $this;
    }

    /**
     * Get beneficiaireEmail
     *
     * @return string
     */
    public function getBeneficiaireEmail()
    {
        return $this->beneficiaireEmail;
    }

    /**
     * Set beneficiaireSocialReason
     *
     * @param string $beneficiaireSocialReason
     *
     * @return FactureSpontane
     */
    public function setBeneficiaireSocialReason($beneficiaireSocialReason)
    {
        $this->beneficiaireSocialReason = $beneficiaireSocialReason;

        return $this;
    }

    /**
     * Get beneficiaireSocialReason
     *
     * @return string
     */
    public function getBeneficiaireSocialReason()
    {
        return $this->beneficiaireSocialReason;
    }

    /**
     * Set beneficiaireTelephone
     *
     * @param string $beneficiaireTelephone
     *
     * @return FactureSpontane
     */
    public function setBeneficiaireTelephone($beneficiaireTelephone)
    {
        $this->beneficiaireTelephone = $beneficiaireTelephone;

        return $this;
    }

    /**
     * Get beneficiaireTelephone
     *
     * @return string
     */
    public function getBeneficiaireTelephone()
    {
        return $this->beneficiaireTelephone;
    }

    /**
     * Set emetteurTelephone
     *
     * @param string $emetteurTelephone
     *
     * @return FactureSpontane
     */
    public function setEmetteurTelephone($emetteurTelephone)
    {
        $this->emetteurTelephone = $emetteurTelephone;

        return $this;
    }

    /**
     * Get emetteurTelephone
     *
     * @return string
     */
    public function getEmetteurTelephone()
    {
        return $this->emetteurTelephone;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return FactureSpontane
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set objet
     *
     * @param string $objet
     *
     * @return FactureSpontane
     */
    public function setObjet($objet)
    {
        $this->objet = $objet;

        return $this;
    }

    /**
     * Get objet
     *
     * @return string
     */
    public function getObjet()
    {
        return $this->objet;
    }

    /**
     * Set attn
     *
     * @param string $attn
     *
     * @return FactureSpontane
     */
    public function setAttn($attn)
    {
        $this->attn = $attn;

        return $this;
    }

    /**
     * Get attn
     *
     * @return string
     */
    public function getAttn()
    {
        return $this->attn;
    }

    /**
     * Set montantTotalHt
     *
     * @param float $montantTotalHt
     *
     * @return FactureSpontane
     */
    public function setMontantTotalHt($montantTotalHt)
    {
        $this->montantTotalHt = $montantTotalHt;

        return $this;
    }

    /**
     * Get montantTotalHt
     *
     * @return float
     */
    public function getMontantTotalHt()
    {
        return $this->montantTotalHt;
    }

    /**
     * Set montantTotalTtc
     *
     * @param integer $montantTotalTtc
     *
     * @return FactureSpontane
     */
    public function setMontantTotalTtc($montantTotalTtc)
    {
        $this->montantTotalTtc = $montantTotalTtc;

        return $this;
    }

    /**
     * Get montantTotalTtc
     *
     * @return integer
     */
    public function getMontantTotalTtc()
    {
        return $this->montantTotalTtc;
    }

    /**
     * Set tva
     *
     * @param float $tva
     *
     * @return FactureSpontane
     */
    public function setTva($tva)
    {
        $this->tva = $tva;

        return $this;
    }

    /**
     * Get tva
     *
     * @return float
     */
    public function getTva()
    {
        return $this->tva;
    }

    /**
     * Set ir
     *
     * @param float $ir
     *
     * @return FactureSpontane
     */
    public function setIr($ir)
    {
        $this->ir = $ir;

        return $this;
    }

    /**
     * Get ir
     *
     * @return float
     */
    public function getIr()
    {
        return $this->ir;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return FactureSpontane
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return FactureSpontane
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return FactureSpontane
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Add factureSpontaneArticle
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontaneArticle $factureSpontaneArticle
     *
     * @return FactureSpontane
     */
    public function addFactureSpontaneArticle(\AMLA\SqrBundle\Entity\FactureSpontaneArticle $factureSpontaneArticle)
    {
        $this->factureSpontaneArticle[] = $factureSpontaneArticle;

        return $this;
    }

    /**
     * Remove factureSpontaneArticle
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontaneArticle $factureSpontaneArticle
     */
    public function removeFactureSpontaneArticle(\AMLA\SqrBundle\Entity\FactureSpontaneArticle $factureSpontaneArticle)
    {
        $this->factureSpontaneArticle->removeElement($factureSpontaneArticle);
    }

    /**
     * Get factureSpontaneArticle
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactureSpontaneArticle()
    {
        return $this->factureSpontaneArticle;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return FactureSpontane
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set netApayer
     *
     * @param float $netApayer
     *
     * @return FactureSpontane
     */
    public function setNetApayer($netApayer)
    {
        $this->netApayer = $netApayer;

        return $this;
    }

    /**
     * Get netApayer
     *
     * @return float
     */
    public function getNetApayer()
    {
        return $this->netApayer;
    }

    /**
     * Set irMontant
     *
     * @param float $irMontant
     *
     * @return FactureSpontane
     */
    public function setIrMontant($irMontant)
    {
        $this->irMontant = $irMontant;

        return $this;
    }

    /**
     * Get irMontant
     *
     * @return float
     */
    public function getIrMontant()
    {
        return $this->irMontant;
    }

    /**
     * Set montantTotalTva
     *
     * @param float $montantTotalTva
     *
     * @return FactureSpontane
     */
    public function setMontantTotalTva($montantTotalTva)
    {
        $this->montantTotalTva = $montantTotalTva;

        return $this;
    }

    /**
     * Get montantTotalTva
     *
     * @return float
     */
    public function getMontantTotalTva()
    {
        return $this->montantTotalTva;
    }

    /**
     * Set pdf
     *
     * @param string $pdf
     *
     * @return FactureSpontane
     */
    public function setPdf($pdf)
    {
        $this->pdf = $pdf;

        return $this;
    }

    /**
     * Get pdf
     *
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }

    /**
     * Set modeReglement
     *
     * @param string $modeReglement
     *
     * @return FactureSpontane
     */
    public function setModeReglement($modeReglement)
    {
        $this->modeReglement = $modeReglement;

        return $this;
    }

    /**
     * Get modeReglement
     *
     * @return string
     */
    public function getModeReglement()
    {
        return $this->modeReglement;
    }

    /**
     * Set telephoneMomoReglement
     *
     * @param string $telephoneMomoReglement
     *
     * @return FactureSpontane
     */
    public function setTelephoneMomoReglement($telephoneMomoReglement)
    {
        $this->telephoneMomoReglement = $telephoneMomoReglement;

        return $this;
    }

    /**
     * Get telephoneMomoReglement
     *
     * @return string
     */
    public function getTelephoneMomoReglement()
    {
        return $this->telephoneMomoReglement;
    }

    /**
     * Set banqueReglement
     *
     * @param string $banqueReglement
     *
     * @return FactureSpontane
     */
    public function setBanqueReglement($banqueReglement)
    {
        $this->banqueReglement = $banqueReglement;

        return $this;
    }

    /**
     * Get banqueReglement
     *
     * @return string
     */
    public function getBanqueReglement()
    {
        return $this->banqueReglement;
    }

    /**
     * Set numcomptebanqueReglement
     *
     * @param string $numcomptebanqueReglement
     *
     * @return FactureSpontane
     */
    public function setNumcomptebanqueReglement($numcomptebanqueReglement)
    {
        $this->numcomptebanqueReglement = $numcomptebanqueReglement;

        return $this;
    }

    /**
     * Get numcomptebanqueReglement
     *
     * @return string
     */
    public function getNumcomptebanqueReglement()
    {
        return $this->numcomptebanqueReglement;
    }

    /**
     * Set referenceFacture
     *
     * @param string $referenceFacture
     *
     * @return FactureSpontane
     */
    public function setReferenceFacture($referenceFacture)
    {
        $this->referenceFacture = $referenceFacture;

        return $this;
    }

    /**
     * Get referenceFacture
     *
     * @return string
     */
    public function getReferenceFacture()
    {
        return $this->referenceFacture;
    }

    /**
     * Set dateFacture
     *
     * @param \DateTime $dateFacture
     *
     * @return FactureSpontane
     */
    public function setDateFacture($dateFacture)
    {
        $this->dateFacture = $dateFacture;

        return $this;
    }

    /**
     * Get dateFacture
     *
     * @return \DateTime
     */
    public function getDateFacture()
    {
        return $this->dateFacture;
    }

    /**
     * Set referenceImpot
     *
     * @param string $referenceImpot
     *
     * @return FactureSpontane
     */
    public function setReferenceImpot($referenceImpot)
    {
        $this->referenceImpot = $referenceImpot;

        return $this;
    }

    /**
     * Get referenceImpot
     *
     * @return string
     */
    public function getReferenceImpot()
    {
        return $this->referenceImpot;
    }

    /**
     * Set isSecured
     *
     * @param boolean $isSecured
     *
     * @return FactureSpontane
     */
    public function setIsSecured($isSecured)
    {
        $this->isSecured = $isSecured;

        return $this;
    }

    /**
     * Get isSecured
     *
     * @return boolean
     */
    public function getIsSecured()
    {
        return $this->isSecured;
    }

    /**
     * Add tvaHistory
     *
     * @param \AMLA\SqrBundle\Entity\TvaHistory $tvaHistory
     *
     * @return FactureSpontane
     */
    public function addTvaHistory(\AMLA\SqrBundle\Entity\TvaHistory $tvaHistory)
    {
        $this->tvaHistory[] = $tvaHistory;

        return $this;
    }

    /**
     * Remove tvaHistory
     *
     * @param \AMLA\SqrBundle\Entity\TvaHistory $tvaHistory
     */
    public function removeTvaHistory(\AMLA\SqrBundle\Entity\TvaHistory $tvaHistory)
    {
        $this->tvaHistory->removeElement($tvaHistory);
    }

    /**
     * Get tvaHistory
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getTvaHistory()
    {
        return $this->tvaHistory;
    }

    /**
     * Add quittance
     *
     * @param \AMLA\SqrBundle\Entity\Quittance $quittance
     *
     * @return FactureSpontane
     */
    public function addQuittance(\AMLA\SqrBundle\Entity\Quittance $quittance)
    {
        $this->quittance[] = $quittance;

        return $this;
    }

    /**
     * Remove quittance
     *
     * @param \AMLA\SqrBundle\Entity\Quittance $quittance
     */
    public function removeQuittance(\AMLA\SqrBundle\Entity\Quittance $quittance)
    {
        $this->quittance->removeElement($quittance);
    }

    /**
     * Get quittance
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getQuittance()
    {
        return $this->quittance;
    }

    /**
     * Set resteAPayer
     *
     * @param float $resteAPayer
     *
     * @return FactureSpontane
     */
    public function setResteAPayer($resteAPayer)
    {
        $this->resteAPayer = $resteAPayer;

        return $this;
    }

    /**
     * Get resteAPayer
     *
     * @return float
     */
    public function getResteAPayer()
    {
        return $this->resteAPayer;
    }


    /**
     * Set isPaymentAccepted
     *
     * @param boolean $isPaymentAccepted
     *
     * @return FactureSpontane
     */
    public function setIsPaymentAccepted($isPaymentAccepted)
    {
        $this->isPaymentAccepted = $isPaymentAccepted;

        return $this;
    }

    /**
     * Get isPaymentAccepted
     *
     * @return boolean
     */
    public function getIsPaymentAccepted()
    {
        return $this->isPaymentAccepted;
    }

    /**
     * Set isSecteurPublique
     *
     * @param boolean $isSecteurPublique
     *
     * @return FactureSpontane
     */
    public function setIsSecteurPublique($isSecteurPublique)
    {
        $this->isSecteurPublique = $isSecteurPublique;

        return $this;
    }

    /**
     * Get isSecteurPublique
     *
     * @return boolean
     */
    public function getIsSecteurPublique()
    {
        return $this->isSecteurPublique;
    }

    /**
     * Add planifierPaiement
     *
     * @param \AMLA\SqrBundle\Entity\PlanifierPaiement $planifierPaiement
     *
     * @return FactureSpontane
     */
    public function addPlanifierPaiement(\AMLA\SqrBundle\Entity\PlanifierPaiement $planifierPaiement)
    {
        $this->planifierPaiement[] = $planifierPaiement;

        return $this;
    }

    /**
     * Remove planifierPaiement
     *
     * @param \AMLA\SqrBundle\Entity\PlanifierPaiement $planifierPaiement
     */
    public function removePlanifierPaiement(\AMLA\SqrBundle\Entity\PlanifierPaiement $planifierPaiement)
    {
        $this->planifierPaiement->removeElement($planifierPaiement);
    }

    /**
     * Get planifierPaiement
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPlanifierPaiement()
    {
        return $this->planifierPaiement;
    }

    /**
     * Add factureSpontaneService.
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontaneService $factureSpontaneService
     *
     * @return FactureSpontane
     */
    public function addFactureSpontaneService(\AMLA\SqrBundle\Entity\FactureSpontaneService $factureSpontaneService)
    {
        $this->factureSpontaneService[] = $factureSpontaneService;

        return $this;
    }

    /**
     * Remove factureSpontaneService.
     *
     * @param \AMLA\SqrBundle\Entity\FactureSpontaneService $factureSpontaneService
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removeFactureSpontaneService(\AMLA\SqrBundle\Entity\FactureSpontaneService $factureSpontaneService)
    {
        return $this->factureSpontaneService->removeElement($factureSpontaneService);
    }

    /**
     * Get factureSpontaneService.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getFactureSpontaneService()
    {
        return $this->factureSpontaneService;
    }

    /**
     * Set inBill.
     *
     * @param \AMLA\SqrBundle\Entity\InBill|null $inBill
     *
     * @return FactureSpontane
     */
    public function setInBill(\AMLA\SqrBundle\Entity\InBill $inBill = null)
    {
        $this->inBill = $inBill;

        return $this;
    }

    /**
     * Get inBill.
     *
     * @return \AMLA\SqrBundle\Entity\InBill|null
     */
    public function getInBill()
    {
        return $this->inBill;
    }

    /**
     * Set fournisseur.
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur|null $fournisseur
     *
     * @return FactureSpontane
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur.
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur|null
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set isInBillFacture.
     *
     * @param int|null $isInBillFacture
     *
     * @return FactureSpontane
     */
    public function setIsInBillFacture($isInBillFacture = null)
    {
        $this->isInBillFacture = $isInBillFacture;

        return $this;
    }

    /**
     * Get isInBillFacture.
     *
     * @return int|null
     */
    public function getIsInBillFacture()
    {
        return $this->isInBillFacture;
    }

    /**
     * Set isInBillDevis.
     *
     * @param int|null $isInBillDevis
     *
     * @return FactureSpontane
     */
    public function setIsInBillDevis($isInBillDevis = null)
    {
        $this->isInBillDevis = $isInBillDevis;

        return $this;
    }

    /**
     * Get isInBillDevis.
     *
     * @return int|null
     */
    public function getIsInBillDevis()
    {
        return $this->isInBillDevis;
    }

    /**
     * Set categorie.
     *
     * @param string|null $categorie
     *
     * @return FactureSpontane
     */
    public function setCategorie($categorie = null)
    {
        $this->categorie = $categorie;

        return $this;
    }

    /**
     * Get categorie.
     *
     * @return string|null
     */
    public function getCategorie()
    {
        return $this->categorie;
    }

    /**
     * Set type.
     *
     * @param string|null $type
     *
     * @return FactureSpontane
     */
    public function setType($type = null)
    {
        $this->type = $type;

        return $this;
    }

    /**
     * Get type.
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
}
