<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FactureSimple
 *
 * @ORM\Table(name="facture_simple")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FactureSimpleRepository")
 */
class FactureSimple
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="factureSimple")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @var string
     *
     * @ORM\Column(name="number", type="string", length=100)
     */
    private $number;

    /**
     * @var float
     *
     * @ORM\Column(name="amount", type="float")
     */
    private $amount;

    /**
     * @var string
     *
     * @ORM\Column(name="canal", type="string", length=255)
     */
    private $canal;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=50, nullable=true)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="niuName", type="string", length=50, nullable=true)
     */
    private $niuName;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=255)
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="factureSimple")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;
 
    /**
     * @var string
     *
     * @ORM\Column(name="beneficiaireNiu", type="string", length=50, nullable=true)
     */
    private $referenceImpot;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;    

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="datePaid", type="datetime", nullable=true)
     */
    private $datePaid;   
 
    /**
     * @var string
     *
     * @ORM\Column(name="payRef", type="string", length=50, nullable=true)
     */
    private $payRef; 

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;//0=En attente // 1= Payée // 2=rejetée (avec ou sans motif)
        //$this->reference = 'SP_'.$this->randomString(); 
        //les différents taux l'accompte 'IS à parametrer 'IS :   2,2% , 5,5%, 11%, 15,4%, et 22%.
        $this->number = "+237";
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set number
     *
     * @param string $number
     *
     * @return FactureSimple
     */
    public function setNumber($number)
    {
        $this->number = $number;
        //$this->number = str_replace("+", "", $number);
        return $this;
    }

    /**
     * Get number
     *
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * Set amount
     *
     * @param float $amount
     *
     * @return FactureSimple
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set canal
     *
     * @param string $canal
     *
     * @return FactureSimple
     */
    public function setCanal($canal)
    {
        $this->canal = $canal;
        return $this;
    }

    /**
     * Get canal
     *
     * @return string
     */
    public function getCanal()
    {
        return $this->canal;
    }

    /**
     * Set status
     *
     * @param string $status
     *
     * @return FactureSimple
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * Get status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return FactureSimple
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;
        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return FactureSimple
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return FactureSimple
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set datePaid
     *
     * @param \DateTime $datePaid
     *
     * @return FactureSimple
     */
    public function setDatePaid($datePaid)
    {
        $this->datePaid = $datePaid;

        return $this;
    }

    /**
     * Get datePaid
     *
     * @return \DateTime
     */
    public function getDatePaid()
    {
        return $this->datePaid;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return FactureSimple
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set referenceImpot
     *
     * @param string $referenceImpot
     *
     * @return FactureSimple
     */
    public function setReferenceImpot($referenceImpot)
    {
        $this->referenceImpot = $referenceImpot;

        return $this;
    }

    /**
     * Get referenceImpot
     *
     * @return string
     */
    public function getReferenceImpot()
    {
        return $this->referenceImpot;
    }

    /**
     * Set payRef
     *
     * @param string $payRef
     *
     * @return FactureSimple
     */
    public function setPayRef($payRef)
    {
        $this->payRef = $payRef;

        return $this;
    }

    /**
     * Get payRef
     *
     * @return string
     */
    public function getPayRef()
    {
        return $this->payRef;
    }

    /**
     * Set niuName
     *
     * @param string $niuName
     *
     * @return FactureSimple
     */
    public function setNiuName($niuName)
    {
        $this->niuName = $niuName;

        return $this;
    }

    /**
     * Get niuName
     *
     * @return string
     */
    public function getNiuName()
    {
        return $this->niuName;
    }
}
