<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Facture
 *
 * @ORM\Table(name="facture")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\FactureRepository")
 */
class Facture
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="ReceptionTravaux", inversedBy="facture")
     * @ORM\JoinColumn(name="reception_travaux_id", referencedColumnName="id")
     */
    private $receptionTravaux;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="factures")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=255)
     */
    private $reference;

    /**
     * @var int
     *
     * @ORM\Column(name="montant", type="integer")
     */
    private $montant;

    /**
     * @var int
     *
     * @ORM\Column(name="statut", type="smallint")
     */
    private $statut; 

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\OneToMany(targetEntity="PaiementValidation", mappedBy="facture")
     */
    private $paiement;

    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=150, nullable=true)
     */
    private $pdf;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;// 0=En attente // 1= validée // 2=rejetée (avec ou sans motif)
        $this->reference = 'FCT_'.$this->randomString();
    }

    /*
     * Create a random string
     * @author	Cedric Rio
     * @param $length the length of the string to create
     * @return $str the string
     */
    function randomString($length = 3)
    {
        $str = "";
        //$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
        $characters = array_merge(range('A','Z'), range('0','9'));
        $max = count($characters) - 1;

        date_default_timezone_set('Africa/Douala');
        $date = date('hiy', time());

        for ($i = 0; $i < $length; $i++)
        {
            $rand = mt_rand(0, $max);
            $str .= $characters[$rand];
        }
        $codeUnique=$str.''.$date;
        return $codeUnique;
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set reference
     *
     * @param string $reference
     *
     * @return Facture
     */
    public function setReference($reference)
    {
        $this->reference = $reference;

        return $this;
    }

    /**
     * Get reference
     *
     * @return string
     */
    public function getReference()
    {
        return $this->reference;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return Facture
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return int
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Facture
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set bonCommande
     *
     * @param \AMLA\SqrBundle\Entity\BonCommande $bonCommande
     *
     * @return Facture
     */
    public function setBonCommande(\AMLA\SqrBundle\Entity\BonCommande $bonCommande = null)
    {
        $this->bonCommande = $bonCommande;

        return $this;
    }

    /**
     * Get bonCommande
     *
     * @return \AMLA\SqrBundle\Entity\BonCommande
     */
    public function getBonCommande()
    {
        return $this->bonCommande;
    }

    /**
     * Set receptionTravaux
     *
     * @param \AMLA\SqrBundle\Entity\ReceptionTravaux $receptionTravaux
     *
     * @return Facture
     */
    public function setReceptionTravaux(\AMLA\SqrBundle\Entity\ReceptionTravaux $receptionTravaux = null)
    {
        $this->receptionTravaux = $receptionTravaux;

        return $this;
    }

    /**
     * Get receptionTravaux
     *
     * @return \AMLA\SqrBundle\Entity\ReceptionTravaux
     */
    public function getReceptionTravaux()
    {
        return $this->receptionTravaux;
    }

    /**
     * Set montant
     *
     * @param integer $montant
     *
     * @return Facture
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return integer
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Add paiement
     *
     * @param \AMLA\SqrBundle\Entity\Facture $paiement
     *
     * @return Facture
     */
    public function addPaiement(\AMLA\SqrBundle\Entity\Facture $paiement)
    {
        $this->paiement[] = $paiement;

        return $this;
    }

    /**
     * Remove paiement
     *
     * @param \AMLA\SqrBundle\Entity\Facture $paiement
     */
    public function removePaiement(\AMLA\SqrBundle\Entity\Facture $paiement)
    {
        $this->paiement->removeElement($paiement);
    }

    /**
     * Get paiement
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPaiement()
    {
        return $this->paiement;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return Facture
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set pdf
     *
     * @param string $pdf
     *
     * @return Facture
     */
    public function setPdf($pdf)
    {
        $this->pdf = $pdf;

        return $this;
    }

    /**
     * Get pdf
     *
     * @return string
     */
    public function getPdf()
    {
        return $this->pdf;
    }
}
