<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Exchange
 *
 * @ORM\Table(name="exchange")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ExchangeRepository")
 */
class Exchange
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="numberToSend", type="string", length=20)
     */
    private $numberToSend;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="exchange")
     * @ORM\JoinColumn(name="fournissseur_id", referencedColumnName="id")
     */
    private $fournisseur;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="exchange")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @var string
     *
     * @ORM\Column(name="numberToPay", type="string", length=20)
     */
    private $numberToPay;

    /**
     * @var float
     *
     * @ORM\Column(name="amount", type="float")
     */
    private $amount;

    /**
     * @var string
     *
     * @ORM\Column(name="operator", type="string", length=20)
     */
    private $operator; //MTN - ORANGE - NEXXTEL - CAMTEL/ 

    /**
     * @var string
     *
     * @ORM\Column(name="operation", type="string", length=20)
     */
    private $operation;    

    /**
     * @var string
     *
     * @ORM\Column(name="paymentMode", type="string", length=20)
     */
    private $paymentMode;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * @var string
     *
     * @ORM\Column(name="comment", type="text", nullable=true)
     */
    private $comment;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;// 1=Pending; 0=Success
        $this->operation = 'CREDIT';// 1=Pending; 0=Success
        //$this->numberToSend = '+237';// 1=Pending; 0=Success
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set numberToSend
     *
     * @param string $numberToSend
     *
     * @return Exchange
     */
    public function setNumberToSend($numberToSend)
    {
        $this->numberToSend = $numberToSend;

        return $this;
    }

    /**
     * Get numberToSend
     *
     * @return string
     */
    public function getNumberToSend()
    {
        return $this->numberToSend;
    }

    /**
     * Set numberToPay
     *
     * @param string $numberToPay
     *
     * @return Exchange
     */
    public function setNumberToPay($numberToPay)
    {
        $this->numberToPay = $numberToPay;

        return $this;
    }

    /**
     * Get numberToPay
     *
     * @return string
     */
    public function getNumberToPay()
    {
        return $this->numberToPay;
    }

    /**
     * Set amount
     *
     * @param float $amount
     *
     * @return Exchange
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * Get amount
     *
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * Set operator
     *
     * @param string $operator
     *
     * @return Exchange
     */
    public function setOperator($operator)
    {
        $this->operator = $operator;

        return $this;
    }

    /**
     * Get operator
     *
     * @return string
     */
    public function getOperator()
    {
        return $this->operator;
    }

    /**
     * Set operation
     *
     * @param string $operation
     *
     * @return Exchange
     */
    public function setOperation($operation)
    {
        $this->operation = $operation;

        return $this;
    }

    /**
     * Get operation
     *
     * @return string
     */
    public function getOperation()
    {
        return $this->operation;
    }

    /**
     * Set paymentMode
     *
     * @param string $paymentMode
     *
     * @return Exchange
     */
    public function setPaymentMode($paymentMode)
    {
        $this->paymentMode = $paymentMode;

        return $this;
    }

    /**
     * Get paymentMode
     *
     * @return string
     */
    public function getPaymentMode()
    {
        return $this->paymentMode;
    }

    /**
     * Set dateCreated
     *
     * @param string $dateCreated
     *
     * @return Exchange
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return string
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return Exchange
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set comment
     *
     * @param string $comment
     *
     * @return Exchange
     */
    public function setComment($comment)
    {
        $this->comment = $comment;

        return $this;
    }

    /**
     * Get comment
     *
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return Exchange
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return Exchange
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }
}
