<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EntrepriseActivite
 *
 * @ORM\Table(name="entreprise_activite")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\EntrepriseActiviteRepository")
 */
class EntrepriseActivite
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

     /**
     * @ORM\ManyToOne(targetEntity="Fournissseur")
     */
    private $fournisseur;

    /**
     * @ORM\ManyToOne(targetEntity="Activite")
     */
    private $activite;

     /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     * {0 = non publié, 1 = en cours}
     */
    private $statut;

     /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); 
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return EntrepriseActivite
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set dateLimite
     *
     * @param \DateTime $dateLimite
     *
     * @return EntrepriseActivite
     */
    public function setDateLimite($dateLimite)
    {
        $this->dateLimite = $dateLimite;

        return $this;
    }

    /**
     * Get dateLimite
     *
     * @return \DateTime
     */
    public function getDateLimite()
    {
        return $this->dateLimite;
    }

    /**
     * Set fournisseur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseur
     *
     * @return EntrepriseActivite
     */
    public function setFournisseur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseur = null)
    {
        $this->fournisseur = $fournisseur;

        return $this;
    }

    /**
     * Get fournisseur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseur()
    {
        return $this->fournisseur;
    }

    /**
     * Set activite
     *
     * @param \AMLA\SqrBundle\Entity\Activite $activite
     *
     * @return EntrepriseActivite
     */
    public function setActivite(\AMLA\SqrBundle\Entity\Activite $activite = null)
    {
        $this->activite = $activite;

        return $this;
    }

    /**
     * Get activite
     *
     * @return \AMLA\SqrBundle\Entity\Activite
     */
    public function getActivite()
    {
        return $this->activite;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return EntrepriseActivite
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }
}
