<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EnregistrementPp
 *
 * @ORM\Table(name="enregistrement_pp")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\EnregistrementPpRepository")
 */
class EnregistrementPp
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;


    /***************** PErsonne Physique************/

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=150)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="prenom", type="string", length=150, nullable=true)
     */
    private $prenom;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateNaissance", type="date")
     */
    private $dateNaissance;

    /**
     * @var string
     *
     * @ORM\Column(name="lieuNaissance", type="string", length=150)
     */
    private $lieuNaissance;

    /**
     * @var string
     *
     * @ORM\Column(name="nomMere", type="string", length=150)
     */
    private $nomMere;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomMere", type="string", length=150, nullable=true)
     */
    private $prenomMere;

    /**
     * @var string
     *
     * @ORM\Column(name="nomPere", type="string", length=150)
     */
    private $nomPere;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomPere", type="string", length=150, nullable=true)
     */
    private $prenomPere;

    /**
     * @var string
     *
     * @ORM\Column(name="sexe", type="string", length=10, nullable=true)
     */
    private $sexe;

    /**
     * @var string
     *
     * @ORM\Column(name="situationMatrimoniale", type="string", length=100)
     */
    private $situationMatrimoniale;

    /******************************** Fin PErsonne physique*****************/

    /**
     * @var string
     *
     * @ORM\Column(name="regime", type="string", length=50, nullable=true)
     */
    private $regime;
    
    /**
     * @var string
     *
     * @ORM\Column(name="activiteDeclaree", type="string", length=255)
     */
    private $activiteDeclaree;

    /**
     * @var string
     *
     * @ORM\Column(name="pays", type="string", length=150)
     */
    private $pays;

    /**
     * @var string
     *
     * @ORM\Column(name="regionAdministration", type="string", length=50)
     */
    private $regionAdministration;

    /**
     * @var string
     *
     * @ORM\Column(name="departement", type="string", length=50)
     */
    private $departement;

    /**
     * @var string
     *
     * @ORM\Column(name="ville", type="string", length=50)
     */
    private $ville;

    /**
     * @var string
     *
     * @ORM\Column(name="commune", type="string", length=50)
     */
    private $commune;

    /**
     * @var string
     *
     * @ORM\Column(name="quartier", type="string", length=50)
     */
    private $quartier;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=50, nullable=true)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=50)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone", type="string", length=50)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="boitePostale", type="string", length=50, nullable=true)
     */
    private $boitePostale;

    /**
     * @var string
     *
     * @ORM\Column(name="cri", type="string", length=50, nullable=true)
     */
    private $cri;

    /**
     * @var string
     *
     * @ORM\Column(name="centreDeRattachement", type="string", length=50, nullable=true)
     */
    private $centreDeRattachement;

    /**
     * @var string
     *
     * @ORM\Column(name="etatNiu", type="string", length=50, nullable=true)
     */
    private $etatNiu;

    /**
     * @var string
     *
     * @ORM\Column(name="numeroPiece", type="string", length=150)
     */
    private $numeroPiece;

    /**
     * @var string
     *
     * @ORM\Column(name="imagePiece1", type="string", length=150, nullable=true)
     */
    private $imagePiece1;

    /**
     * @var string
     *
     * @ORM\Column(name="imagePiece2", type="string", length=150, nullable=true)
     */
    private $imagePiece2;

    /**
     * @var string
     *
     * @ORM\Column(name="lieuDit", type="string", length=150)
     */
    private $lieuDit;

    /**
     * @var string
     *
     * @ORM\Column(name="observation", type="text", nullable=true)
     */
    private $observation;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="enregistrementPp")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var string
     *
     * @ORM\Column(name="typePiece", type="text", nullable=true)
     */
    private $typePiece;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;// 0=En attente // 1= valide // 2=rejete (avec ou sans motif)
        $this->telephone = '+237';
        $this->etatNiu = '';
        $this->niu = '';
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set regionAdministration
     *
     * @param string $regionAdministration
     *
     * @return EnregistrementPp
     */
    public function setRegionAdministration($regionAdministration)
    {
        $this->regionAdministration = $regionAdministration;

        return $this;
    }

    /**
     * Get regionAdministration
     *
     * @return string
     */
    public function getRegionAdministration()
    {
        return $this->regionAdministration;
    }

    /**
     * Set departement
     *
     * @param string $departement
     *
     * @return EnregistrementPp
     */
    public function setDepartement($departement)
    {
        $this->departement = $departement;

        return $this;
    }

    /**
     * Get departement
     *
     * @return string
     */
    public function getDepartement()
    {
        return $this->departement;
    }

    /**
     * Set boitePostale
     *
     * @param string $boitePostale
     *
     * @return EnregistrementPp
     */
    public function setBoitePostale($boitePostale)
    {
        $this->boitePostale = $boitePostale;

        return $this;
    }

    /**
     * Get boitePostale
     *
     * @return string
     */
    public function getBoitePostale()
    {
        return $this->boitePostale;
    }

    /**
     * Set cri
     *
     * @param string $cri
     *
     * @return EnregistrementPp
     */
    public function setCri($cri)
    {
        $this->cri = $cri;

        return $this;
    }

    /**
     * Get cri
     *
     * @return string
     */
    public function getCri()
    {
        return $this->cri;
    }

    /**
     * Set centreDeRattachement
     *
     * @param string $centreDeRattachement
     *
     * @return EnregistrementPp
     */
    public function setCentreDeRattachement($centreDeRattachement)
    {
        $this->centreDeRattachement = $centreDeRattachement;

        return $this;
    }

    /**
     * Get centreDeRattachement
     *
     * @return string
     */
    public function getCentreDeRattachement()
    {
        return $this->centreDeRattachement;
    }

    /**
     * Set etatNiu
     *
     * @param string $etatNiu
     *
     * @return EnregistrementPp
     */
    public function setEtatNiu($etatNiu)
    {
        $this->etatNiu = $etatNiu;

        return $this;
    }

    /**
     * Get etatNiu
     *
     * @return string
     */
    public function getEtatNiu()
    {
        return $this->etatNiu;
    }

    /**
     * Set nom
     *
     * @param string $nom
     *
     * @return EnregistrementPp
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set prenom
     *
     * @param string $prenom
     *
     * @return EnregistrementPp
     */
    public function setPrenom($prenom)
    {
        $this->prenom = $prenom;

        return $this;
    }

    /**
     * Get prenom
     *
     * @return string
     */
    public function getPrenom()
    {
        return $this->prenom;
    }

    /**
     * Set dateNaissance
     *
     * @param \DateTime $dateNaissance
     *
     * @return EnregistrementPp
     */
    public function setDateNaissance($dateNaissance)
    {
        $this->dateNaissance = $dateNaissance;

        return $this;
    }

    /**
     * Get dateNaissance
     *
     * @return \DateTime
     */
    public function getDateNaissance()
    {
        return $this->dateNaissance;
    }

    /**
     * Set lieuNaissance
     *
     * @param string $lieuNaissance
     *
     * @return EnregistrementPp
     */
    public function setLieuNaissance($lieuNaissance)
    {
        $this->lieuNaissance = $lieuNaissance;

        return $this;
    }

    /**
     * Get lieuNaissance
     *
     * @return string
     */
    public function getLieuNaissance()
    {
        return $this->lieuNaissance;
    }

    /**
     * Set nomMere
     *
     * @param string $nomMere
     *
     * @return EnregistrementPp
     */
    public function setNomMere($nomMere)
    {
        $this->nomMere = $nomMere;

        return $this;
    }

    /**
     * Get nomMere
     *
     * @return string
     */
    public function getNomMere()
    {
        return $this->nomMere;
    }

    /**
     * Set prenomMere
     *
     * @param string $prenomMere
     *
     * @return EnregistrementPp
     */
    public function setPrenomMere($prenomMere)
    {
        $this->prenomMere = $prenomMere;

        return $this;
    }

    /**
     * Get prenomMere
     *
     * @return string
     */
    public function getPrenomMere()
    {
        return $this->prenomMere;
    }

    /**
     * Set nomPere
     *
     * @param string $nomPere
     *
     * @return EnregistrementPp
     */
    public function setNomPere($nomPere)
    {
        $this->nomPere = $nomPere;

        return $this;
    }

    /**
     * Get nomPere
     *
     * @return string
     */
    public function getNomPere()
    {
        return $this->nomPere;
    }

    /**
     * Set prenomPere
     *
     * @param string $prenomPere
     *
     * @return EnregistrementPp
     */
    public function setPrenomPere($prenomPere)
    {
        $this->prenomPere = $prenomPere;

        return $this;
    }

    /**
     * Get prenomPere
     *
     * @return string
     */
    public function getPrenomPere()
    {
        return $this->prenomPere;
    }

    /**
     * Set sexe
     *
     * @param string $sexe
     *
     * @return EnregistrementPp
     */
    public function setSexe($sexe)
    {
        $this->sexe = $sexe;

        return $this;
    }

    /**
     * Get sexe
     *
     * @return string
     */
    public function getSexe()
    {
        return $this->sexe;
    }

    /**
     * Set situationMatrimoniale
     *
     * @param string $situationMatrimoniale
     *
     * @return EnregistrementPp
     */
    public function setSituationMatrimoniale($situationMatrimoniale)
    {
        $this->situationMatrimoniale = $situationMatrimoniale;

        return $this;
    }

    /**
     * Get situationMatrimoniale
     *
     * @return string
     */
    public function getSituationMatrimoniale()
    {
        return $this->situationMatrimoniale;
    }

    /**
     * Set activiteDeclaree
     *
     * @param string $activiteDeclaree
     *
     * @return EnregistrementPp
     */
    public function setActiviteDeclaree($activiteDeclaree)
    {
        $this->activiteDeclaree = $activiteDeclaree;

        return $this;
    }

    /**
     * Get activiteDeclaree
     *
     * @return string
     */
    public function getActiviteDeclaree()
    {
        return $this->activiteDeclaree;
    }

    /**
     * Set pays
     *
     * @param string $pays
     *
     * @return EnregistrementPp
     */
    public function setPays($pays)
    {
        $this->pays = $pays;

        return $this;
    }

    /**
     * Get pays
     *
     * @return string
     */
    public function getPays()
    {
        return $this->pays;
    }

    /**
     * Set ville
     *
     * @param string $ville
     *
     * @return EnregistrementPp
     */
    public function setVille($ville)
    {
        $this->ville = $ville;

        return $this;
    }

    /**
     * Get ville
     *
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * Set commune
     *
     * @param string $commune
     *
     * @return EnregistrementPp
     */
    public function setCommune($commune)
    {
        $this->commune = $commune;

        return $this;
    }

    /**
     * Get commune
     *
     * @return string
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * Set quartier
     *
     * @param string $quartier
     *
     * @return EnregistrementPp
     */
    public function setQuartier($quartier)
    {
        $this->quartier = $quartier;

        return $this;
    }

    /**
     * Get quartier
     *
     * @return string
     */
    public function getQuartier()
    {
        return $this->quartier;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return EnregistrementPp
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return EnregistrementPp
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     *
     * @return EnregistrementPp
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set numeroPiece
     *
     * @param string $numeroPiece
     *
     * @return EnregistrementPp
     */
    public function setNumeroPiece($numeroPiece)
    {
        $this->numeroPiece = $numeroPiece;

        return $this;
    }

    /**
     * Get numeroPiece
     *
     * @return string
     */
    public function getNumeroPiece()
    {
        return $this->numeroPiece;
    }

    /**
     * Set imagePiece1
     *
     * @param string $imagePiece1
     *
     * @return EnregistrementPp
     */
    public function setImagePiece1($imagePiece1)
    {
        $this->imagePiece1 = $imagePiece1;

        return $this;
    }

    /**
     * Get imagePiece1
     *
     * @return string
     */
    public function getImagePiece1()
    {
        return $this->imagePiece1;
    }

    /**
     * Set imagePiece2
     *
     * @param string $imagePiece2
     *
     * @return EnregistrementPp
     */
    public function setImagePiece2($imagePiece2)
    {
        $this->imagePiece2 = $imagePiece2;

        return $this;
    }

    /**
     * Get imagePiece2
     *
     * @return string
     */
    public function getImagePiece2()
    {
        return $this->imagePiece2;
    }

    /**
     * Set lieuDit
     *
     * @param string $lieuDit
     *
     * @return EnregistrementPp
     */
    public function setLieuDit($lieuDit)
    {
        $this->lieuDit = $lieuDit;

        return $this;
    }

    /**
     * Get lieuDit
     *
     * @return string
     */
    public function getLieuDit()
    {
        return $this->lieuDit;
    }

    /**
     * Set observation
     *
     * @param string $observation
     *
     * @return EnregistrementPp
     */
    public function setObservation($observation)
    {
        $this->observation = $observation;

        return $this;
    }

    /**
     * Get observation
     *
     * @return string
     */
    public function getObservation()
    {
        return $this->observation;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return EnregistrementPp
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set password
     *
     * @param string $password
     *
     * @return EnregistrementPp
     */
    public function setPassword($password)
    {
        $this->password = $password;

        return $this;
    }

    /**
     * Get password
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Set login
     *
     * @param string $login
     *
     * @return EnregistrementPp
     */
    public function setLogin($login)
    {
        $this->login = $login;

        return $this;
    }

    /**
     * Get login
     *
     * @return string
     */
    public function getLogin()
    {
        return $this->login;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return EnregistrementPp
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return EnregistrementPp
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set regime
     *
     * @param string $regime
     *
     * @return EnregistrementPp
     */
    public function setRegime($regime)
    {
        $this->regime = $regime;

        return $this;
    }

    /**
     * Get regime
     *
     * @return string
     */
    public function getRegime()
    {
        return $this->regime;
    }

    /**
     * Set typePiece
     *
     * @param string $typePiece
     *
     * @return EnregistrementPp
     */
    public function setTypePiece($typePiece)
    {
        $this->typePiece = $typePiece;

        return $this;
    }

    /**
     * Get typePiece
     *
     * @return string
     */
    public function getTypePiece()
    {
        return $this->typePiece;
    }
}
