<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * EnregistrementPm
 *
 * @ORM\Table(name="enregistrement_pm")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\EnregistrementPmRepository")
 */
class EnregistrementPm
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /***************** PErsonne Physique************/

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=150, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="prenom", type="string", length=150, nullable=true)
     */
    private $prenom;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateNaissance", type="date", nullable=true)
     */
    private $dateNaissance;

    /**
     * @var string
     *
     * @ORM\Column(name="lieuNaissance", type="string", length=150, nullable=true)
     */
    private $lieuNaissance;

    /**
     * @var string
     *
     * @ORM\Column(name="nomMere", type="string", length=150, nullable=true)
     */
    private $nomMere;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomMere", type="string", length=150, nullable=true)
     */
    private $prenomMere;

    /**
     * @var string
     *
     * @ORM\Column(name="nomPere", type="string", length=150, nullable=true)
     */
    private $nomPere;

    /**
     * @var string
     *
     * @ORM\Column(name="prenomPere", type="string", length=150, nullable=true)
     */
    private $prenomPere;

    /**
     * @var string
     *
     * @ORM\Column(name="sexe", type="string", length=10, nullable=true)
     */
    private $sexe;

    /**
     * @var string
     *
     * @ORM\Column(name="situationMatrimoniale", type="string", length=100, nullable=true)
     */
    private $situationMatrimoniale;

    /******************************** Fin PErsonne physique*****************/

    /*********** PErsonne Morale **************************/
    /**
     * @var string
     *
     * @ORM\Column(name="raisonSociale", type="string", length=150, nullable=true)
     */
    private $raisonSociale;

    /**
     * @var string
     *
     * @ORM\Column(name="sigle", type="string", length=100, nullable=true)
     */
    private $sigle;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreation", type="datetime", nullable=true)
     */
    private $dateCreation;

    /**
     * @var string
     *
     * @ORM\Column(name="lieuCreation", type="string", length=50, nullable=true)
     */
    private $lieuCreation;

    /**
     * @var string
     *
     * @ORM\Column(name="nomDirigeant", type="string", length=150, nullable=true)
     */
    private $nomDirigeant;

    /**
     * @var string
     *
     * @ORM\Column(name="formeJuridique", type="string", length=50, nullable=true)
     */
    private $formeJuridique;

    /**
     * @var string
     *
     * @ORM\Column(name="regime", type="string", length=50, nullable=true)
     */
    private $regime;
    /***************** Fin PErsonne morale ********/

    /**
     * @var string
     *
     * @ORM\Column(name="activiteDeclaree", type="string", length=255)
     */
    private $activiteDeclaree;

    /**
     * @var string
     *
     * @ORM\Column(name="pays", type="string", length=150)
     */
    private $pays;

    /**
     * @var string
     *
     * @ORM\Column(name="regionAdministration", type="string", length=50)
     */
    private $regionAdministration;

    /**
     * @var string
     *
     * @ORM\Column(name="departement", type="string", length=50)
     */
    private $departement;

    /**
     * @var string
     *
     * @ORM\Column(name="ville", type="string", length=50)
     */
    private $ville;

    /**
     * @var string
     *
     * @ORM\Column(name="commune", type="string", length=50)
     */
    private $commune;

    /**
     * @var string
     *
     * @ORM\Column(name="quartier", type="string", length=50)
     */
    private $quartier;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=50)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=50)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone", type="string", length=50)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="boitePostale", type="string", length=50, nullable=true)
     */
    private $boitePostale;

    /**
     * @var string
     *
     * @ORM\Column(name="cri", type="string", length=50, nullable=true)
     */
    private $cri;

    /**
     * @var string
     *
     * @ORM\Column(name="centreDeRattachement", type="string", length=50, nullable=true)
     */
    private $centreDeRattachement;

    /**
     * @var string
     *
     * @ORM\Column(name="etatNiu", type="string", length=50, nullable=true)
     */
    private $etatNiu;

    /**
     * @var string
     *
     * @ORM\Column(name="numeroPiece", type="string", length=150)
     */
    private $numeroPiece;

    /**
     * @var string
     *
     * @ORM\Column(name="imagePiece1", type="string", length=150, nullable=true)
     */
    private $imagePiece1;
    
    /**
     * @var string
     *
     * @ORM\Column(name="imagePiece2", type="string", length=150, nullable=true)
     */
    private $imagePiece2;

    /**
     * @var string
     *
     * @ORM\Column(name="lieuDit", type="string", length=150)
     */
    private $lieuDit;


    /**
     * @var string
     *
     * @ORM\Column(name="observation", type="text", nullable=true)
     */
    private $observation;


    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="enregistrementPm")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * @var string
     *
     * @ORM\Column(name="typePiece", type="text", nullable=true)
     */
    private $typePiece;

    /**
     * @var int
     *
     * @ORM\Column(name="isEntreprise", type="integer")
     */
    private $isEntreprise;

    function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;// 0=En attente // 1= validée // 2=rejetée (avec ou sans motif)
        $this->telephone = '+237';
        $this->etatNiu = '';
        $this->niu = '';
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set raisonSociale
     *
     * @param string $raisonSociale
     *
     * @return EnregistrementPm
     */
    public function setRaisonSociale($raisonSociale)
    {
        $this->raisonSociale = $raisonSociale;

        return $this;
    }

    /**
     * Set nom
     *
     * @param string $nom
     *
     * @return EnregistrementPm
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set prenom
     *
     * @param string $prenom
     *
     * @return EnregistrementPm
     */
    public function setPrenom($prenom)
    {
        $this->prenom = $prenom;

        return $this;
    }

    /**
     * Get prenom
     *
     * @return string
     */
    public function getPrenom()
    {
        return $this->prenom;
    }

    /**
     * Set dateNaissance
     *
     * @param \DateTime $dateNaissance
     *
     * @return EnregistrementPm
     */
    public function setDateNaissance($dateNaissance)
    {
        $this->dateNaissance = $dateNaissance;

        return $this;
    }

    /**
     * Get dateNaissance
     *
     * @return \DateTime
     */
    public function getDateNaissance()
    {
        return $this->dateNaissance;
    }

    /**
     * Set lieuNaissance
     *
     * @param string $lieuNaissance
     *
     * @return EnregistrementPm
     */
    public function setLieuNaissance($lieuNaissance)
    {
        $this->lieuNaissance = $lieuNaissance;

        return $this;
    }

    /**
     * Get lieuNaissance
     *
     * @return string
     */
    public function getLieuNaissance()
    {
        return $this->lieuNaissance;
    }

    /**
     * Set nomMere
     *
     * @param string $nomMere
     *
     * @return EnregistrementPm
     */
    public function setNomMere($nomMere)
    {
        $this->nomMere = $nomMere;

        return $this;
    }

    /**
     * Get nomMere
     *
     * @return string
     */
    public function getNomMere()
    {
        return $this->nomMere;
    }

    /**
     * Set prenomMere
     *
     * @param string $prenomMere
     *
     * @return EnregistrementPm
     */
    public function setPrenomMere($prenomMere)
    {
        $this->prenomMere = $prenomMere;

        return $this;
    }

    /**
     * Get prenomMere
     *
     * @return string
     */
    public function getPrenomMere()
    {
        return $this->prenomMere;
    }

    /**
     * Set nomPere
     *
     * @param string $nomPere
     *
     * @return EnregistrementPm
     */
    public function setNomPere($nomPere)
    {
        $this->nomPere = $nomPere;

        return $this;
    }

    /**
     * Get nomPere
     *
     * @return string
     */
    public function getNomPere()
    {
        return $this->nomPere;
    }

    /**
     * Get raisonSociale
     *
     * @return string
     */
    public function getRaisonSociale()
    {
        return $this->raisonSociale;
    }

    /**
     * Set sigle
     *
     * @param string $sigle
     *
     * @return EnregistrementPm
     */
    public function setSigle($sigle)
    {
        $this->sigle = $sigle;

        return $this;
    }

    /**
     * Get sigle
     *
     * @return string
     */
    public function getSigle()
    {
        return $this->sigle;
    }

    /**
     * Set dateCreation
     *
     * @param \DateTime $dateCreation
     *
     * @return EnregistrementPm
     */
    public function setDateCreation($dateCreation)
    {
        $this->dateCreation = $dateCreation;

        return $this;
    }

    /**
     * Get dateCreation
     *
     * @return \DateTime
     */
    public function getDateCreation()
    {
        return $this->dateCreation;
    }

    /**
     * Set lieuCreation
     *
     * @param string $lieuCreation
     *
     * @return EnregistrementPm
     */
    public function setLieuCreation($lieuCreation)
    {
        $this->lieuCreation = $lieuCreation;

        return $this;
    }

    /**
     * Get lieuCreation
     *
     * @return string
     */
    public function getLieuCreation()
    {
        return $this->lieuCreation;
    }

    /**
     * Set nomDirigeant
     *
     * @param string $nomDirigeant
     *
     * @return EnregistrementPm
     */
    public function setNomDirigeant($nomDirigeant)
    {
        $this->nomDirigeant = $nomDirigeant;

        return $this;
    }

    /**
     * Get nomDirigeant
     *
     * @return string
     */
    public function getNomDirigeant()
    {
        return $this->nomDirigeant;
    }

    /**
     * Set formeJuridique
     *
     * @param string $formeJuridique
     *
     * @return EnregistrementPm
     */
    public function setFormeJuridique($formeJuridique)
    {
        $this->formeJuridique = $formeJuridique;

        return $this;
    }

    /**
     * Get formeJuridique
     *
     * @return string
     */
    public function getFormeJuridique()
    {
        return $this->formeJuridique;
    }

    /**
     * Set regime
     *
     * @param string $regime
     *
     * @return EnregistrementPm
     */
    public function setRegime($regime)
    {
        $this->regime = $regime;

        return $this;
    }

    /**
     * Get regime
     *
     * @return string
     */
    public function getRegime()
    {
        return $this->regime;
    }

    /**
     * Set activiteDeclaree
     *
     * @param string $activiteDeclaree
     *
     * @return EnregistrementPm
     */
    public function setActiviteDeclaree($activiteDeclaree)
    {
        $this->activiteDeclaree = $activiteDeclaree;

        return $this;
    }

    /**
     * Get activiteDeclaree
     *
     * @return string
     */
    public function getActiviteDeclaree()
    {
        return $this->activiteDeclaree;
    }

    /**
     * Set pays
     *
     * @param string $pays
     *
     * @return EnregistrementPm
     */
    public function setPays($pays)
    {
        $this->pays = $pays;

        return $this;
    }

    /**
     * Get pays
     *
     * @return string
     */
    public function getPays()
    {
        return $this->pays;
    }

    /**
     * Set regionAdministration
     *
     * @param string $regionAdministration
     *
     * @return EnregistrementPm
     */
    public function setRegionAdministration($regionAdministration)
    {
        $this->regionAdministration = $regionAdministration;

        return $this;
    }

    /**
     * Get regionAdministration
     *
     * @return string
     */
    public function getRegionAdministration()
    {
        return $this->regionAdministration;
    }

    /**
     * Set departement
     *
     * @param string $departement
     *
     * @return EnregistrementPm
     */
    public function setDepartement($departement)
    {
        $this->departement = $departement;

        return $this;
    }

    /**
     * Get departement
     *
     * @return string
     */
    public function getDepartement()
    {
        return $this->departement;
    }

    /**
     * Set ville
     *
     * @param string $ville
     *
     * @return EnregistrementPm
     */
    public function setVille($ville)
    {
        $this->ville = $ville;

        return $this;
    }

    /**
     * Get ville
     *
     * @return string
     */
    public function getVille()
    {
        return $this->ville;
    }

    /**
     * Set commune
     *
     * @param string $commune
     *
     * @return EnregistrementPm
     */
    public function setCommune($commune)
    {
        $this->commune = $commune;

        return $this;
    }

    /**
     * Get commune
     *
     * @return string
     */
    public function getCommune()
    {
        return $this->commune;
    }

    /**
     * Set quartier
     *
     * @param string $quartier
     *
     * @return EnregistrementPm
     */
    public function setQuartier($quartier)
    {
        $this->quartier = $quartier;

        return $this;
    }

    /**
     * Get quartier
     *
     * @return string
     */
    public function getQuartier()
    {
        return $this->quartier;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return EnregistrementPm
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return EnregistrementPm
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     *
     * @return EnregistrementPm
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set boitePostale
     *
     * @param string $boitePostale
     *
     * @return EnregistrementPm
     */
    public function setBoitePostale($boitePostale)
    {
        $this->boitePostale = $boitePostale;

        return $this;
    }

    /**
     * Get boitePostale
     *
     * @return string
     */
    public function getBoitePostale()
    {
        return $this->boitePostale;
    }

    /**
     * Set cri
     *
     * @param string $cri
     *
     * @return EnregistrementPm
     */
    public function setCri($cri)
    {
        $this->cri = $cri;

        return $this;
    }

    /**
     * Get cri
     *
     * @return string
     */
    public function getCri()
    {
        return $this->cri;
    }

    /**
     * Set centreDeRattachement
     *
     * @param string $centreDeRattachement
     *
     * @return EnregistrementPm
     */
    public function setCentreDeRattachement($centreDeRattachement)
    {
        $this->centreDeRattachement = $centreDeRattachement;

        return $this;
    }

    /**
     * Get centreDeRattachement
     *
     * @return string
     */
    public function getCentreDeRattachement()
    {
        return $this->centreDeRattachement;
    }

    /**
     * Set etatNiu
     *
     * @param string $etatNiu
     *
     * @return EnregistrementPm
     */
    public function setEtatNiu($etatNiu)
    {
        $this->etatNiu = $etatNiu;

        return $this;
    }

    /**
     * Get etatNiu
     *
     * @return string
     */
    public function getEtatNiu()
    {
        return $this->etatNiu;
    }

    /**
     * Set numeroPiece
     *
     * @param string $numeroPiece
     *
     * @return EnregistrementPm
     */
    public function setNumeroPiece($numeroPiece)
    {
        $this->numeroPiece = $numeroPiece;

        return $this;
    }

    /**
     * Get numeroPiece
     *
     * @return string
     */
    public function getNumeroPiece()
    {
        return $this->numeroPiece;
    }

    /**
     * Set imagePiece1
     *
     * @param string $imagePiece1
     *
     * @return EnregistrementPm
     */
    public function setImagePiece1($imagePiece1)
    {
        $this->imagePiece1 = $imagePiece1;

        return $this;
    }

    /**
     * Get imagePiece1
     *
     * @return string
     */
    public function getImagePiece1()
    {
        return $this->imagePiece1;
    }

    /**
     * Set imagePiece2
     *
     * @param string $imagePiece2
     *
     * @return EnregistrementPm
     */
    public function setImagePiece2($imagePiece2)
    {
        $this->imagePiece2 = $imagePiece2;

        return $this;
    }

    /**
     * Get imagePiece2
     *
     * @return string
     */
    public function getImagePiece2()
    {
        return $this->imagePiece2;
    }

    /**
     * Set lieuDit
     *
     * @param string $lieuDit
     *
     * @return EnregistrementPm
     */
    public function setLieuDit($lieuDit)
    {
        $this->lieuDit = $lieuDit;

        return $this;
    }

    /**
     * Get lieuDit
     *
     * @return string
     */
    public function getLieuDit()
    {
        return $this->lieuDit;
    }

    /**
     * Set observation
     *
     * @param string $observation
     *
     * @return EnregistrementPm
     */
    public function setObservation($observation)
    {
        $this->observation = $observation;

        return $this;
    }

    /**
     * Get observation
     *
     * @return string
     */
    public function getObservation()
    {
        return $this->observation;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return EnregistrementPm
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return EnregistrementPm
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return EnregistrementPm
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }

    /**
     * Set prenomPere
     *
     * @param string $prenomPere
     *
     * @return EnregistrementPm
     */
    public function setPrenomPere($prenomPere)
    {
        $this->prenomPere = $prenomPere;

        return $this;
    }

    /**
     * Get prenomPere
     *
     * @return string
     */
    public function getPrenomPere()
    {
        return $this->prenomPere;
    }

    /**
     * Set sexe
     *
     * @param string $sexe
     *
     * @return EnregistrementPm
     */
    public function setSexe($sexe)
    {
        $this->sexe = $sexe;

        return $this;
    }

    /**
     * Get sexe
     *
     * @return string
     */
    public function getSexe()
    {
        return $this->sexe;
    }

    /**
     * Set situationMatrimoniale
     *
     * @param string $situationMatrimoniale
     *
     * @return EnregistrementPm
     */
    public function setSituationMatrimoniale($situationMatrimoniale)
    {
        $this->situationMatrimoniale = $situationMatrimoniale;

        return $this;
    }

    /**
     * Get situationMatrimoniale
     *
     * @return string
     */
    public function getSituationMatrimoniale()
    {
        return $this->situationMatrimoniale;
    }

    /**
     * Set isEntreprise
     *
     * @param integer $isEntreprise
     *
     * @return EnregistrementPm
     */
    public function setIsEntreprise($isEntreprise)
    {
        $this->isEntreprise = $isEntreprise;

        return $this;
    }

    /**
     * Get isEntreprise
     *
     * @return integer
     */
    public function getIsEntreprise()
    {
        return $this->isEntreprise;
    }

    /**
     * Set typePiece
     *
     * @param string $typePiece
     *
     * @return EnregistrementPm
     */
    public function setTypePiece($typePiece)
    {
        $this->typePiece = $typePiece;

        return $this;
    }

    /**
     * Get typePiece
     *
     * @return string
     */
    public function getTypePiece()
    {
        return $this->typePiece;
    }
}
