<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Document
 *
 * @ORM\Table(name="document")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\DocumentRepository")
 */
class Document
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="path", type="string", length=255)
     */
    private $path;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255)
     */
    private $name;

    /**
     * @var int
     *
     * @ORM\Column(name="size", type="integer")
     */
    private $size;

    /**
     * @var string
     *
     * @ORM\Column(name="thumb", type="string", length=255)
     */
    private $thumb;

    /** 
     * @ORM\ManyToOne(targetEntity="SoummissionOffre", inversedBy="documents", cascade={"persist"})
     * @ORM\JoinColumn(name="soumission_id", referencedColumnName="id", nullable=true)
     */
    private $soumission;

    /** 
     * @ORM\ManyToOne(targetEntity="Offre", inversedBy="cahierCharge", cascade={"persist"})
     * @ORM\JoinColumn(name="offre_id", referencedColumnName="id", nullable=true)
     */
    private $offre;

    /** 
     * @ORM\ManyToOne(targetEntity="Atd", inversedBy="documents", cascade={"persist"})
     * @ORM\JoinColumn(name="atd_id", referencedColumnName="id", nullable=true)
     */
    private $atd;

    /** 
     * @ORM\ManyToOne(targetEntity="Administratif", inversedBy="documents", cascade={"persist"})
     * @ORM\JoinColumn(name="administratif_id", referencedColumnName="id", nullable=true)
     */
    private $administratif;

    /** 
     * @ORM\ManyToOne(targetEntity="Annexe", inversedBy="documents", cascade={"persist"})
     * @ORM\JoinColumn(name="annexe_id", referencedColumnName="id", nullable=true)
     */
    private $annexe;

    /** 
     * @ORM\ManyToOne(targetEntity="Financier", inversedBy="documents", cascade={"persist"})
     * @ORM\JoinColumn(name="financier_id", referencedColumnName="id", nullable=true)
     */
    private $financier;

    /** 
     * @ORM\ManyToOne(targetEntity="Technique", inversedBy="documents", cascade={"persist"})
     * @ORM\JoinColumn(name="technique_id", referencedColumnName="id", nullable=true)
     */
    private $technique;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set path
     *
     * @param string $path
     *
     * @return Document
     */
    public function setPath($path)
    {
        $this->path = $path;

        return $this;
    }

    /**
     * Get path
     *
     * @return string
     */
    public function getPath()
    {
        return $this->getUploadDir().'/'.$this->path;
    }

    /**
     * Get path
     *
     * @return string
     */
    public function getRealPath()
    {
        return $this->path;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Document
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        //return $this->getQrUploadDir().'/'.$this->name;
        return $this->getUploadDir().'/'.$this->name;
    }

    public function getThumbsUploadDir()
	{
		// Upload directory
		return 'image_thumbs';
		// This means /web/uploads/documents/
    }
    
    public function getUploadDir()
	{
		// Upload directory
		return 'uploads/documents';
		// This means /web/uploads/documents/
    }

    public function getUploadRootDir()
	{
		// On retourne le chemin relatif vers l'image pour notre code PHP
		// Image location (PHP)
		return __DIR__.'/../../../../web/'.$this->getUploadDir();
	}

    /**
     * Set size
     *
     * @param string $size
     *
     * @return Document
     */
    public function setSize($size)
    {
        $this->size = $size;

        return $this;
    }

    /**
     * Get size
     *
     * @return string
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Set thumb
     *
     * @param string $thumb
     *
     * @return Document
     */
    public function setThumb($thumb)
    {
        $this->thumb = $thumb;

        return $this;
    }

    /**
     * Get thumb
     *
     * @return string
     */
    public function getThumb()
    {
        return $this->getThumbsUploadDir().'/'.$this->thumb;
    }

    /**
     * Set soumission
     *
     * @param \AMLA\SqrBundle\Entity\SoummissionOffre $soumission
     *
     * @return Document
     */
    public function setSoumission(\AMLA\SqrBundle\Entity\SoummissionOffre $soumission = null)
    {
        $this->soumission = $soumission;

        return $this;
    }

    /**
     * Get soumission
     *
     * @return \AMLA\SqrBundle\Entity\SoummissionOffre
     */
    public function getSoumission()
    {
        return $this->soumission;
    }

    /**
     * Set atd
     *
     * @param \AMLA\SqrBundle\Entity\Atd $atd
     *
     * @return Document
     */
    public function setAtd(\AMLA\SqrBundle\Entity\Atd $atd = null)
    {
        $this->atd = $atd;

        return $this;
    }

    /**
     * Get atd
     *
     * @return \AMLA\SqrBundle\Entity\Atd
     */
    public function getAtd()
    {
        return $this->atd;
    }

    /**
     * Set offre
     *
     * @param \AMLA\SqrBundle\Entity\Offre $offre
     *
     * @return Document
     */
    public function setOffre(\AMLA\SqrBundle\Entity\Offre $offre = null)
    {
        $this->offre = $offre;

        return $this;
    }

    /**
     * Get offre
     *
     * @return \AMLA\SqrBundle\Entity\Offre
     */
    public function getOffre()
    {
        return $this->offre;
    }

    /**
     * Set bonCommande
     *
     * @param \AMLA\SqrBundle\Entity\BonCommande $bonCommande
     *
     * @return Document
     */
    public function setBonCommande(\AMLA\SqrBundle\Entity\BonCommande $bonCommande = null)
    {
        $this->bonCommande = $bonCommande;

        return $this;
    }

    /**
     * Get bonCommande
     *
     * @return \AMLA\SqrBundle\Entity\BonCommande
     */
    public function getBonCommande()
    {
        return $this->bonCommande;
    }

    /**
     * Set administratif
     *
     * @param \AMLA\SqrBundle\Entity\Administratif $administratif
     *
     * @return Document
     */
    public function setAdministratif(\AMLA\SqrBundle\Entity\Administratif $administratif = null)
    {
        $this->administratif = $administratif;

        return $this;
    }

    /**
     * Get administratif
     *
     * @return \AMLA\SqrBundle\Entity\Administratif
     */
    public function getAdministratif()
    {
        return $this->administratif;
    }

    /**
     * Set annexe
     *
     * @param \AMLA\SqrBundle\Entity\Annexe $annexe
     *
     * @return Document
     */
    public function setAnnexe(\AMLA\SqrBundle\Entity\Annexe $annexe = null)
    {
        $this->annexe = $annexe;

        return $this;
    }

    /**
     * Get annexe
     *
     * @return \AMLA\SqrBundle\Entity\Annexe
     */
    public function getAnnexe()
    {
        return $this->annexe;
    }

    /**
     * Set financier
     *
     * @param \AMLA\SqrBundle\Entity\Financier $financier
     *
     * @return Document
     */
    public function setFinancier(\AMLA\SqrBundle\Entity\Financier $financier = null)
    {
        $this->financier = $financier;

        return $this;
    }

    /**
     * Get financier
     *
     * @return \AMLA\SqrBundle\Entity\Financier
     */
    public function getFinancier()
    {
        return $this->financier;
    }

    /**
     * Set technique
     *
     * @param \AMLA\SqrBundle\Entity\Technique $technique
     *
     * @return Document
     */
    public function setTechnique(\AMLA\SqrBundle\Entity\Technique $technique = null)
    {
        $this->technique = $technique;

        return $this;
    }

    /**
     * Get technique
     *
     * @return \AMLA\SqrBundle\Entity\Technique
     */
    public function getTechnique()
    {
        return $this->technique;
    }
}
