<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Debour
 *
 * @ORM\Table(name="debour")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\DebourRepository")
 */
class Debour
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="debourEmetteur")
     * @ORM\JoinColumn(name="fournisseur_emetteur_id", referencedColumnName="id")
     */
    private $fournisseurEmetteur;

    /**
     * @ORM\ManyToOne(targetEntity="Fournissseur", inversedBy="debourRecepteur")
     * @ORM\JoinColumn(name="fournisseur_recepteur_id", referencedColumnName="id")
     */
    private $fournisseurRecepteur;

    /**
     * @var float
     *
     * @ORM\Column(name="montant", type="float")
     */
    private $montant;

    /**
     * @var string
     *
     * @ORM\Column(name="referenceFacture", type="string", length=50)
     */
    private $referenceFacture;

    /**
     * @var string
     *
     * @ORM\Column(name="commentaire", type="text")
     */
    private $commentaire;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @ORM\ManyToOne(targetEntity="CheckQr", inversedBy="debour")
     * @ORM\JoinColumn(name="qrcode_id", referencedColumnName="id")
     */
    private $qrCode;

    /**
     * @var int
     *
     * @ORM\Column(name="status", type="integer")
     */
    private $status;

    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->status = 0;//1=non trait 1 trait
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }
    

    /**
     * Set montant
     *
     * @param float $montant
     *
     * @return Debour
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return float
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set referenceFacture
     *
     * @param string $referenceFacture
     *
     * @return Debour
     */
    public function setReferenceFacture($referenceFacture)
    {
        $this->referenceFacture = $referenceFacture;

        return $this;
    }

    /**
     * Get referenceFacture
     *
     * @return string
     */
    public function getReferenceFacture()
    {
        return $this->referenceFacture;
    }

    /**
     * Set commentaire
     *
     * @param string $commentaire
     *
     * @return Debour
     */
    public function setCommentaire($commentaire)
    {
        $this->commentaire = $commentaire;

        return $this;
    }

    /**
     * Get commentaire
     *
     * @return string
     */
    public function getCommentaire()
    {
        return $this->commentaire;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Debour
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return Debour
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set fournisseurEmetteur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseurEmetteur
     *
     * @return Debour
     */
    public function setFournisseurEmetteur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseurEmetteur = null)
    {
        $this->fournisseurEmetteur = $fournisseurEmetteur;

        return $this;
    }

    /**
     * Get fournisseurEmetteur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseurEmetteur()
    {
        return $this->fournisseurEmetteur;
    }

    /**
     * Set fournisseurRecepteur
     *
     * @param \AMLA\SqrBundle\Entity\Fournissseur $fournisseurRecepteur
     *
     * @return Debour
     */
    public function setFournisseurRecepteur(\AMLA\SqrBundle\Entity\Fournissseur $fournisseurRecepteur = null)
    {
        $this->fournisseurRecepteur = $fournisseurRecepteur;

        return $this;
    }

    /**
     * Get fournisseurRecepteur
     *
     * @return \AMLA\SqrBundle\Entity\Fournissseur
     */
    public function getFournisseurRecepteur()
    {
        return $this->fournisseurRecepteur;
    }

    /**
     * Set qrCode
     *
     * @param \AMLA\SqrBundle\Entity\CheckQr $qrCode
     *
     * @return Debour
     */
    public function setQrCode(\AMLA\SqrBundle\Entity\CheckQr $qrCode = null)
    {
        $this->qrCode = $qrCode;

        return $this;
    }

    /**
     * Get qrCode
     *
     * @return \AMLA\SqrBundle\Entity\CheckQr
     */
    public function getQrCode()
    {
        return $this->qrCode;
    }
}
