<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ContratAvenant
 *
 * @ORM\Table(name="contrat_avenant")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ContratAvenantRepository")
 */
class ContratAvenant
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var int
     *
     * @ORM\Column(name="contrat", type="integer")
     */
    private $contrat;

    /**
     * @var string
     *
     * @ORM\Column(name="versionElectronique", type="text")
     */
    private $versionElectronique;

    /**
     * @var string
     *
     * @ORM\Column(name="nomMarche", type="string", length=255)
     */
    private $nomMarche;

    /**
     * @var string
     *
     * @ORM\Column(name="numeroMarche", type="string", length=255)
     */
    private $numeroMarche;

    /**
     * @var string
     *
     * @ORM\Column(name="Ium", type="string", length=255)
     */
    private $ium;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateCreated", type="datetime")
     */
    private $dateCreated;

    /**
     * @var int
     *
     * @ORM\Column(name="account", type="integer")
     */
    private $account;


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set contrat
     *
     * @param integer $contrat
     *
     * @return ContratAvenant
     */
    public function setContrat($contrat)
    {
        $this->contrat = $contrat;

        return $this;
    }

    /**
     * Get contrat
     *
     * @return int
     */
    public function getContrat()
    {
        return $this->contrat;
    }

    /**
     * Set versionElectronique
     *
     * @param string $versionElectronique
     *
     * @return ContratAvenant
     */
    public function setVersionElectronique($versionElectronique)
    {
        $this->versionElectronique = $versionElectronique;

        return $this;
    }

    /**
     * Get versionElectronique
     *
     * @return string
     */
    public function getVersionElectronique()
    {
        return $this->versionElectronique;
    }

    /**
     * Set nomMarche
     *
     * @param string $nomMarche
     *
     * @return ContratAvenant
     */
    public function setNomMarche($nomMarche)
    {
        $this->nomMarche = $nomMarche;

        return $this;
    }

    /**
     * Get nomMarche
     *
     * @return string
     */
    public function getNomMarche()
    {
        return $this->nomMarche;
    }

    /**
     * Set numeroMarche
     *
     * @param string $numeroMarche
     *
     * @return ContratAvenant
     */
    public function setNumeroMarche($numeroMarche)
    {
        $this->numeroMarche = $numeroMarche;

        return $this;
    }

    /**
     * Get numeroMarche
     *
     * @return string
     */
    public function getNumeroMarche()
    {
        return $this->numeroMarche;
    }

    /**
     * Set ium
     *
     * @param string $ium
     *
     * @return ContratAvenant
     */
    public function setIum($ium)
    {
        $this->ium = $ium;

        return $this;
    }

    /**
     * Get ium
     *
     * @return string
     */
    public function getIum()
    {
        return $this->ium;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return ContratAvenant
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set account
     *
     * @param integer $account
     *
     * @return ContratAvenant
     */
    public function setAccount($account)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return int
     */
    public function getAccount()
    {
        return $this->account;
    }
}
