<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Contrat
 *
 * @ORM\Table(name="contrat")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ContratRepository")
 */
class Contrat
{   
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;
    
    /**
     * @var string
     *
     * @ORM\Column(name="terme_detail", type="text")
     */
    private $termeDetail;
    
    /**
     * @var string
     *
     * @ORM\Column(name="terme_detail_scan", type="text")
     */
    private $termeDetailScan; 
    
    /**
     * @var string
     *
     * @ORM\Column(name="niu_prestataire", type="string", length=255)
     */
    private $niuPrestataire;
    
    /**
     * @var string
     *
     * @ORM\Column(name="niu_commanditaire", type="string", length=255)
     */
    private $niuCommanditaire;
    
    /**
     * @var string
     *
     * @ORM\Column(name="nom_prestataire", type="string", length=255)
     */
    private $nomPrestataire;

    /**
     * @var string
     *
     * @ORM\Column(name="nom_commanditaire", type="string", length=255)
     */
    private $nomCommanditaire;

    /**
     * @var string
     *
     * @ORM\Column(name="sigle_structure_prestataire", type="string", length=255)
     */
    private $sigleStructurePrestataire;

    /**
     * @var string
     *
     * @ORM\Column(name="sigle_structure_commanditaire", type="string", length=255)
     */
    private $sigleStructureCommanditaire;

    /**
     * @var string
     *
     * @ORM\Column(name="nom_signature_prestataire", type="string", length=255)
     */
    private $nomSignaturePrestataire;

    /**
     * @var string
     *
     * @ORM\Column(name="nom_signature_commanditaire", type="string", length=255)
     */
    private $nomSignatureCommanditaire;

    /**
     * @var string
     *
     * @ORM\Column(name="duree_contrat", type="string", length=255)
     */
    private $dureeContrat;

    /**
     * @var int
     *
     * @ORM\Column(name="offre", type="integer")
     */
    private $offre;

    /**
     * @var int
     *
     * @ORM\Column(name="montant_ht_local", type="integer")
     */
    private $montantHtLocal;

    /**
     * @var int
     *
     * @ORM\Column(name="montant_ht_exterieur", type="integer")
     */
    private $montantHtExterieur;

    /**
     * @var string
     *
     * @ORM\Column(name="etablissement", type="string", length=255)
     */
    private $etablissement;

    /**
     * @var string
     *
     * @ORM\Column(name="droit_fixe", type="string", length=255)
     */
    private $droitFixe;

    /**
     * @var string
     *
     * @ORM\Column(name="resident", type="string", length=255)
     */
    private $resident;

    /**
     * @var string
     *
     * @ORM\Column(name="moyen_paiement", type="string", length=255)
     */
    private $moyenPaiement;

    /**
     * @var string
     *
     * @ORM\Column(name="banque_paiement", type="string", length=255)
     */
    private $banquePaiement;

    /**
     * @var string
     *
     * @ORM\Column(name="rib_paiement", type="string", length=255)
     */
    private $ribPaiement;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=255)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_marche", type="string", length=255)
     */
    private $numeroMarche;

    /**
     * @var string
     *
     * @ORM\Column(name="nom_marche", type="string", length=255)
     */
    private $nomMarche;

    /**
     * @ORM\ManyToOne(targetEntity="MaitreOuvrage", inversedBy="contrat")
     * @ORM\JoinColumn(name="maitre_ouvrage_id", referencedColumnName="id")
     */
    private $idMaitreOuvrage;

    /**
     * @var string
     *
     * @ORM\Column(name="maitre_ouvrage", type="string", length=255)
     */
    private $maitreOuvrage;

    /**
     * @ORM\ManyToOne(targetEntity="CelluleEnregistrement", inversedBy="contrat")
     * @ORM\JoinColumn(name="cellule_enregistrement_id", referencedColumnName="id")
     */
    private $idCelluleEnregistrement;

    /**
     * @ORM\ManyToOne(targetEntity="OrganismeFinancement", inversedBy="contrat")
     * @ORM\JoinColumn(name="organisme_financement_id", referencedColumnName="id")
     */
    private $idOrganismeFinancement;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_signature", type="datetime")
     */
    private $dateSignature;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_visa", type="datetime")
     */
    private $dateVisa;

    /**
     * @var int
     *
     * @ORM\Column(name="nombre_exemplaire", type="integer")
     */
    private $nombreExemplaire;

    /**
     * @var int
     *
     * @ORM\Column(name="nombre_page_exemplaire", type="integer")
     */
    private $nombrePageExemplaire;

    /**
     * @var int
     *
     * @ORM\Column(name="nombre_annexe", type="integer")
     */
    private $nombreAnnexe;

    /**
     * @var int
     *
     * @ORM\Column(name="pourcent_garantie", type="integer")
     */
    private $pourcentGarantie;

    /**
     * @var int
     *
     * @ORM\Column(name="pourcent_cautionnement", type="integer")
     */
    private $pourcentCautionnement;

    /**
     * @var int
     *
     * @ORM\Column(name="pourcent_nantissement", type="integer")
     */
    private $pourcentNantissement;

    /**
     * @var int
     *
     * @ORM\Column(name="caution_sur_ttc", type="integer")
     */
    private $cautionSurTtc;

    /**
     * @var int
     *
     * @ORM\Column(name="garantie_sur_ttc", type="integer")
     */
    private $garantieSurTtc;

    /**
     * @var int
     *
     * @ORM\Column(name="nantissement_sur_ttc", type="integer")
     */
    private $nantissementSurTtc;

    /**
     * @var int
     *
     * @ORM\Column(name="dossier_timbre", type="integer")
     */
    private $dossierTimbre;

    /**
     * @var int
     *
     * @ORM\Column(name="carburant", type="integer")
     */
    private $carburant;

    /**
     * @var int
     *
     * @ORM\Column(name="tva_ignoree", type="integer")
     */
    private $tvaIgnoree;

    /**
     * @var int
     *
     * @ORM\Column(name="enregistrement_gratis", type="integer")
     */
    private $enregistrementGratis;

    /**
     * @var string
     *
     * @ORM\Column(name="idshare_application", type="string", length=255)
     */
    private $idshareApplication;

    /**
     * @ORM\ManyToOne(targetEntity="Account", inversedBy="contrat")
     * @ORM\JoinColumn(name="account_id", referencedColumnName="id")
     */
    private $account;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var boolean
     *
     * @ORM\Column(name="status", type="smallint")
     * {0 = en cours, 1 = cloturé}
     */
    private $status;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateEmissionDgi", type="datetime")
     */
    private $dateEmissionDgi;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateGenerated", type="datetime")
     */
    private $dateGenerated;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dateLimitePaiement", type="datetime")
     */
    private $dateLimitePaiement;
  
    /**
     * @var string
     *
     * @ORM\Column(name="montant", type="string", length=255)
     */
    private $montant;

    /**
     * @var string
     *
     * @ORM\Column(name="numero_declaration", type="string", length=255)
     */
    private $numeroDeclaration;

    /**
     * @var string
     *
     * @ORM\Column(name="penalite", type="string", length=255)
     */
    private $penalite;

    /**
     * @var string
     *
     * @ORM\Column(name="penalite_future", type="string", length=255)
     */
    private $penaliteFuture;

    /**
     * @var string
     *
     * @ORM\Column(name="principal", type="string", length=255)
     */
    private $principal;
    
    /**
     * @var string
     *
     * @ORM\Column(name="reference_impot", type="string", length=50)
     */
    private $referenceImpot;
    
    /**
     * @var string
     *
     * @ORM\Column(name="reference_checktatoo", type="string", length=50)
     */
    private $referenceChecktatoo;
    
    /**
     * @var string
     *
     * @ORM\Column(name="type_marche", type="string", length=20)
     */
    private $typeMarche;
    
    /**
     * @var string
     *
     * @ORM\Column(name="result", type="string", length=20)
     */
    private $result;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date   
        $this->status = 0;     
        $this->idshareApplication = 'CHECKTOO';
        //http://www.rfi.fr/afrique/20191101-exclusion-cameroun-agoa-usa-trump
    }

    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }


    /**
     * Set termeDetail
     *
     * @param string $termeDetail
     *
     * @return Contrat
     */
    public function setTermeDetail($termeDetail)
    {
        $this->termeDetail = $termeDetail;

        return $this;
    }

    /**
     * Get termeDetail
     *
     * @return string
     */
    public function getTermeDetail()
    {
        return $this->termeDetail;
    }

    /**
     * Set niuPrestataire
     *
     * @param string $niuPrestataire
     *
     * @return Contrat
     */
    public function setNiuPrestataire($niuPrestataire)
    {
        $this->niuPrestataire = $niuPrestataire;

        return $this;
    }

    /**
     * Get niuPrestataire
     *
     * @return string
     */
    public function getNiuPrestataire()
    {
        return $this->niuPrestataire;
    }

    /**
     * Set niuCommanditaire
     *
     * @param string $niuCommanditaire
     *
     * @return Contrat
     */
    public function setNiuCommanditaire($niuCommanditaire)
    {
        $this->niuCommanditaire = $niuCommanditaire;

        return $this;
    }

    /**
     * Get niuCommanditaire
     *
     * @return string
     */
    public function getNiuCommanditaire()
    {
        return $this->niuCommanditaire;
    }

    /**
     * Set nomPrestataire
     *
     * @param string $nomPrestataire
     *
     * @return Contrat
     */
    public function setNomPrestataire($nomPrestataire)
    {
        $this->nomPrestataire = $nomPrestataire;

        return $this;
    }

    /**
     * Get nomPrestataire
     *
     * @return string
     */
    public function getNomPrestataire()
    {
        return $this->nomPrestataire;
    }

    /**
     * Set nomCommanditaire
     *
     * @param string $nomCommanditaire
     *
     * @return Contrat
     */
    public function setNomCommanditaire($nomCommanditaire)
    {
        $this->nomCommanditaire = $nomCommanditaire;

        return $this;
    }

    /**
     * Get nomCommanditaire
     *
     * @return string
     */
    public function getNomCommanditaire()
    {
        return $this->nomCommanditaire;
    }

    /**
     * Set sigleStructurePrestataire
     *
     * @param string $sigleStructurePrestataire
     *
     * @return Contrat
     */
    public function setSigleStructurePrestataire($sigleStructurePrestataire)
    {
        $this->sigleStructurePrestataire = $sigleStructurePrestataire;

        return $this;
    }

    /**
     * Get sigleStructurePrestataire
     *
     * @return string
     */
    public function getSigleStructurePrestataire()
    {
        return $this->sigleStructurePrestataire;
    }

    /**
     * Set sigleStructureCommanditaire
     *
     * @param string $sigleStructureCommanditaire
     *
     * @return Contrat
     */
    public function setSigleStructureCommanditaire($sigleStructureCommanditaire)
    {
        $this->sigleStructureCommanditaire = $sigleStructureCommanditaire;

        return $this;
    }

    /**
     * Get sigleStructureCommanditaire
     *
     * @return string
     */
    public function getSigleStructureCommanditaire()
    {
        return $this->sigleStructureCommanditaire;
    }

    /**
     * Set nomSignaturePrestataire
     *
     * @param string $nomSignaturePrestataire
     *
     * @return Contrat
     */
    public function setNomSignaturePrestataire($nomSignaturePrestataire)
    {
        $this->nomSignaturePrestataire = $nomSignaturePrestataire;

        return $this;
    }

    /**
     * Get nomSignaturePrestataire
     *
     * @return string
     */
    public function getNomSignaturePrestataire()
    {
        return $this->nomSignaturePrestataire;
    }

    /**
     * Set nomSignatureCommanditaire
     *
     * @param string $nomSignatureCommanditaire
     *
     * @return Contrat
     */
    public function setNomSignatureCommanditaire($nomSignatureCommanditaire)
    {
        $this->nomSignatureCommanditaire = $nomSignatureCommanditaire;

        return $this;
    }

    /**
     * Get nomSignatureCommanditaire
     *
     * @return string
     */
    public function getNomSignatureCommanditaire()
    {
        return $this->nomSignatureCommanditaire;
    }

    /**
     * Set dureeContrat
     *
     * @param string $dureeContrat
     *
     * @return Contrat
     */
    public function setDureeContrat($dureeContrat)
    {
        $this->dureeContrat = $dureeContrat;

        return $this;
    }

    /**
     * Get dureeContrat
     *
     * @return string
     */
    public function getDureeContrat()
    {
        return $this->dureeContrat;
    }

    /**
     * Set offre
     *
     * @param integer $offre
     *
     * @return Contrat
     */
    public function setOffre($offre)
    {
        $this->offre = $offre;

        return $this;
    }

    /**
     * Get offre
     *
     * @return integer
     */
    public function getOffre()
    {
        return $this->offre;
    }

    /**
     * Set montantHtLocal
     *
     * @param integer $montantHtLocal
     *
     * @return Contrat
     */
    public function setMontantHtLocal($montantHtLocal)
    {
        $this->montantHtLocal = $montantHtLocal;

        return $this;
    }

    /**
     * Get montantHtLocal
     *
     * @return integer
     */
    public function getMontantHtLocal()
    {
        return $this->montantHtLocal;
    }

    /**
     * Set montantHtExterieur
     *
     * @param integer $montantHtExterieur
     *
     * @return Contrat
     */
    public function setMontantHtExterieur($montantHtExterieur)
    {
        $this->montantHtExterieur = $montantHtExterieur;

        return $this;
    }

    /**
     * Get montantHtExterieur
     *
     * @return integer
     */
    public function getMontantHtExterieur()
    {
        return $this->montantHtExterieur;
    }

    /**
     * Set etablissement
     *
     * @param string $etablissement
     *
     * @return Contrat
     */
    public function setEtablissement($etablissement)
    {
        $this->etablissement = $etablissement;

        return $this;
    }

    /**
     * Get etablissement
     *
     * @return string
     */
    public function getEtablissement()
    {
        return $this->etablissement;
    }

    /**
     * Set droitFixe
     *
     * @param string $droitFixe
     *
     * @return Contrat
     */
    public function setDroitFixe($droitFixe)
    {
        $this->droitFixe = $droitFixe;

        return $this;
    }

    /**
     * Get droitFixe
     *
     * @return string
     */
    public function getDroitFixe()
    {
        return $this->droitFixe;
    }

    /**
     * Set resident
     *
     * @param string $resident
     *
     * @return Contrat
     */
    public function setResident($resident)
    {
        $this->resident = $resident;

        return $this;
    }

    /**
     * Get resident
     *
     * @return string
     */
    public function getResident()
    {
        return $this->resident;
    }

    /**
     * Set moyenPaiement
     *
     * @param string $moyenPaiement
     *
     * @return Contrat
     */
    public function setMoyenPaiement($moyenPaiement)
    {
        $this->moyenPaiement = $moyenPaiement;

        return $this;
    }

    /**
     * Get moyenPaiement
     *
     * @return string
     */
    public function getMoyenPaiement()
    {
        return $this->moyenPaiement;
    }

    /**
     * Set banquePaiement
     *
     * @param string $banquePaiement
     *
     * @return Contrat
     */
    public function setBanquePaiement($banquePaiement)
    {
        $this->banquePaiement = $banquePaiement;

        return $this;
    }

    /**
     * Get banquePaiement
     *
     * @return string
     */
    public function getBanquePaiement()
    {
        return $this->banquePaiement;
    }

    /**
     * Set ribPaiement
     *
     * @param string $ribPaiement
     *
     * @return Contrat
     */
    public function setRibPaiement($ribPaiement)
    {
        $this->ribPaiement = $ribPaiement;

        return $this;
    }

    /**
     * Get ribPaiement
     *
     * @return string
     */
    public function getRibPaiement()
    {
        return $this->ribPaiement;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return Contrat
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set numeroMarche
     *
     * @param string $numeroMarche
     *
     * @return Contrat
     */
    public function setNumeroMarche($numeroMarche)
    {
        $this->numeroMarche = $numeroMarche;

        return $this;
    }

    /**
     * Get numeroMarche
     *
     * @return string
     */
    public function getNumeroMarche()
    {
        return $this->numeroMarche;
    }

    /**
     * Set idMaitreOuvrage
     *
     * @param string $idMaitreOuvrage
     *
     * @return Contrat
     */
    public function setIdMaitreOuvrage($idMaitreOuvrage)
    {
        $this->idMaitreOuvrage = $idMaitreOuvrage;

        return $this;
    }

    /**
     * Get idMaitreOuvrage
     *
     * @return string
     */
    public function getIdMaitreOuvrage()
    {
        return $this->idMaitreOuvrage;
    }

    /**
     * Set maitreOuvrage
     *
     * @param string $maitreOuvrage
     *
     * @return Contrat
     */
    public function setMaitreOuvrage($maitreOuvrage)
    {
        $this->maitreOuvrage = $maitreOuvrage;

        return $this;
    }

    /**
     * Get maitreOuvrage
     *
     * @return string
     */
    public function getMaitreOuvrage()
    {
        return $this->maitreOuvrage;
    }

    /**
     * Set idCelluleEnregistrement
     *
     * @param string $idCelluleEnregistrement
     *
     * @return Contrat
     */
    public function setIdCelluleEnregistrement($idCelluleEnregistrement)
    {
        $this->idCelluleEnregistrement = $idCelluleEnregistrement;

        return $this;
    }

    /**
     * Get idCelluleEnregistrement
     *
     * @return string
     */
    public function getIdCelluleEnregistrement()
    {
        return $this->idCelluleEnregistrement;
    }

    /**
     * Set idOrganismeFinancement
     *
     * @param string $idOrganismeFinancement
     *
     * @return Contrat
     */
    public function setIdOrganismeFinancement($idOrganismeFinancement)
    {
        $this->idOrganismeFinancement = $idOrganismeFinancement;

        return $this;
    }

    /**
     * Get idOrganismeFinancement
     *
     * @return string
     */
    public function getIdOrganismeFinancement()
    {
        return $this->idOrganismeFinancement;
    }

    /**
     * Set dateSignature
     *
     * @param \DateTime $dateSignature
     *
     * @return Contrat
     */
    public function setDateSignature($dateSignature)
    {
        $this->dateSignature = $dateSignature;

        return $this;
    }

    /**
     * Get dateSignature
     *
     * @return \DateTime
     */
    public function getDateSignature()
    {
        return $this->dateSignature;
    }

    /**
     * Set dateVisa
     *
     * @param \DateTime $dateVisa
     *
     * @return Contrat
     */
    public function setDateVisa($dateVisa)
    {
        $this->dateVisa = $dateVisa;

        return $this;
    }

    /**
     * Get dateVisa
     *
     * @return \DateTime
     */
    public function getDateVisa()
    {
        return $this->dateVisa;
    }

    /**
     * Set nombreExemplaire
     *
     * @param integer $nombreExemplaire
     *
     * @return Contrat
     */
    public function setNombreExemplaire($nombreExemplaire)
    {
        $this->nombreExemplaire = $nombreExemplaire;

        return $this;
    }

    /**
     * Get nombreExemplaire
     *
     * @return integer
     */
    public function getNombreExemplaire()
    {
        return $this->nombreExemplaire;
    }

    /**
     * Set nombrePageExemplaire
     *
     * @param integer $nombrePageExemplaire
     *
     * @return Contrat
     */
    public function setNombrePageExemplaire($nombrePageExemplaire)
    {
        $this->nombrePageExemplaire = $nombrePageExemplaire;

        return $this;
    }

    /**
     * Get nombrePageExemplaire
     *
     * @return integer
     */
    public function getNombrePageExemplaire()
    {
        return $this->nombrePageExemplaire;
    }

    /**
     * Set nombreAnnexe
     *
     * @param integer $nombreAnnexe
     *
     * @return Contrat
     */
    public function setNombreAnnexe($nombreAnnexe)
    {
        $this->nombreAnnexe = $nombreAnnexe;

        return $this;
    }

    /**
     * Get nombreAnnexe
     *
     * @return integer
     */
    public function getNombreAnnexe()
    {
        return $this->nombreAnnexe;
    }

    /**
     * Set pourcentGarantie
     *
     * @param integer $pourcentGarantie
     *
     * @return Contrat
     */
    public function setPourcentGarantie($pourcentGarantie)
    {
        $this->pourcentGarantie = $pourcentGarantie;

        return $this;
    }

    /**
     * Get pourcentGarantie
     *
     * @return integer
     */
    public function getPourcentGarantie()
    {
        return $this->pourcentGarantie;
    }

    /**
     * Set pourcentCautionnement
     *
     * @param integer $pourcentCautionnement
     *
     * @return Contrat
     */
    public function setPourcentCautionnement($pourcentCautionnement)
    {
        $this->pourcentCautionnement = $pourcentCautionnement;

        return $this;
    }

    /**
     * Get pourcentCautionnement
     *
     * @return integer
     */
    public function getPourcentCautionnement()
    {
        return $this->pourcentCautionnement;
    }

    /**
     * Set pourcentNantissement
     *
     * @param integer $pourcentNantissement
     *
     * @return Contrat
     */
    public function setPourcentNantissement($pourcentNantissement)
    {
        $this->pourcentNantissement = $pourcentNantissement;

        return $this;
    }

    /**
     * Get pourcentNantissement
     *
     * @return integer
     */
    public function getPourcentNantissement()
    {
        return $this->pourcentNantissement;
    }

    /**
     * Set cautionSurTtc
     *
     * @param integer $cautionSurTtc
     *
     * @return Contrat
     */
    public function setCautionSurTtc($cautionSurTtc)
    {
        $this->cautionSurTtc = $cautionSurTtc;

        return $this;
    }

    /**
     * Get cautionSurTtc
     *
     * @return integer
     */
    public function getCautionSurTtc()
    {
        return $this->cautionSurTtc;
    }

    /**
     * Set garantieSurTtc
     *
     * @param integer $garantieSurTtc
     *
     * @return Contrat
     */
    public function setGarantieSurTtc($garantieSurTtc)
    {
        $this->garantieSurTtc = $garantieSurTtc;

        return $this;
    }

    /**
     * Get garantieSurTtc
     *
     * @return integer
     */
    public function getGarantieSurTtc()
    {
        return $this->garantieSurTtc;
    }

    /**
     * Set nantissementSurTtc
     *
     * @param integer $nantissementSurTtc
     *
     * @return Contrat
     */
    public function setNantissementSurTtc($nantissementSurTtc)
    {
        $this->nantissementSurTtc = $nantissementSurTtc;

        return $this;
    }

    /**
     * Get nantissementSurTtc
     *
     * @return integer
     */
    public function getNantissementSurTtc()
    {
        return $this->nantissementSurTtc;
    }

    /**
     * Set dossierTimbre
     *
     * @param integer $dossierTimbre
     *
     * @return Contrat
     */
    public function setDossierTimbre($dossierTimbre)
    {
        $this->dossierTimbre = $dossierTimbre;

        return $this;
    }

    /**
     * Get dossierTimbre
     *
     * @return integer
     */
    public function getDossierTimbre()
    {
        return $this->dossierTimbre;
    }

    /**
     * Set carburant
     *
     * @param integer $carburant
     *
     * @return Contrat
     */
    public function setCarburant($carburant)
    {
        $this->carburant = $carburant;

        return $this;
    }

    /**
     * Get carburant
     *
     * @return integer
     */
    public function getCarburant()
    {
        return $this->carburant;
    }

    /**
     * Set tvaIgnoree
     *
     * @param integer $tvaIgnoree
     *
     * @return Contrat
     */
    public function setTvaIgnoree($tvaIgnoree)
    {
        $this->tvaIgnoree = $tvaIgnoree;

        return $this;
    }

    /**
     * Get tvaIgnoree
     *
     * @return integer
     */
    public function getTvaIgnoree()
    {
        return $this->tvaIgnoree;
    }

    /**
     * Set enregistrementGratis
     *
     * @param integer $enregistrementGratis
     *
     * @return Contrat
     */
    public function setEnregistrementGratis($enregistrementGratis)
    {
        $this->enregistrementGratis = $enregistrementGratis;

        return $this;
    }

    /**
     * Get enregistrementGratis
     *
     * @return integer
     */
    public function getEnregistrementGratis()
    {
        return $this->enregistrementGratis;
    }

    /**
     * Set idshareApplication
     *
     * @param string $idshareApplication
     *
     * @return Contrat
     */
    public function setIdshareApplication($idshareApplication)
    {
        $this->idshareApplication = $idshareApplication;

        return $this;
    }

    /**
     * Get idshareApplication
     *
     * @return string
     */
    public function getIdshareApplication()
    {
        return $this->idshareApplication;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Contrat
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set status
     *
     * @param integer $status
     *
     * @return Contrat
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * Get status
     *
     * @return integer
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Set dateEmissionDgi
     *
     * @param \DateTime $dateEmissionDgi
     *
     * @return Contrat
     */
    public function setDateEmissionDgi($dateEmissionDgi)
    {
        $this->dateEmissionDgi = $dateEmissionDgi;

        return $this;
    }

    /**
     * Get dateEmissionDgi
     *
     * @return \DateTime
     */
    public function getDateEmissionDgi()
    {
        return $this->dateEmissionDgi;
    }

    /**
     * Set dateGenerated
     *
     * @param \DateTime $dateGenerated
     *
     * @return Contrat
     */
    public function setDateGenerated($dateGenerated)
    {
        $this->dateGenerated = $dateGenerated;

        return $this;
    }

    /**
     * Get dateGenerated
     *
     * @return \DateTime
     */
    public function getDateGenerated()
    {
        return $this->dateGenerated;
    }

    /**
     * Set dateLimitePaiement
     *
     * @param \DateTime $dateLimitePaiement
     *
     * @return Contrat
     */
    public function setDateLimitePaiement($dateLimitePaiement)
    {
        $this->dateLimitePaiement = $dateLimitePaiement;

        return $this;
    }

    /**
     * Get dateLimitePaiement
     *
     * @return \DateTime
     */
    public function getDateLimitePaiement()
    {
        return $this->dateLimitePaiement;
    }

    /**
     * Set montant
     *
     * @param string $montant
     *
     * @return Contrat
     */
    public function setMontant($montant)
    {
        $this->montant = $montant;

        return $this;
    }

    /**
     * Get montant
     *
     * @return string
     */
    public function getMontant()
    {
        return $this->montant;
    }

    /**
     * Set numeroDeclaration
     *
     * @param string $numeroDeclaration
     *
     * @return Contrat
     */
    public function setNumeroDeclaration($numeroDeclaration)
    {
        $this->numeroDeclaration = $numeroDeclaration;

        return $this;
    }

    /**
     * Get numeroDeclaration
     *
     * @return string
     */
    public function getNumeroDeclaration()
    {
        return $this->numeroDeclaration;
    }

    /**
     * Set penalite
     *
     * @param string $penalite
     *
     * @return Contrat
     */
    public function setPenalite($penalite)
    {
        $this->penalite = $penalite;

        return $this;
    }

    /**
     * Get penalite
     *
     * @return string
     */
    public function getPenalite()
    {
        return $this->penalite;
    }

    /**
     * Set penaliteFuture
     *
     * @param string $penaliteFuture
     *
     * @return Contrat
     */
    public function setPenaliteFuture($penaliteFuture)
    {
        $this->penaliteFuture = $penaliteFuture;

        return $this;
    }

    /**
     * Get penaliteFuture
     *
     * @return string
     */
    public function getPenaliteFuture()
    {
        return $this->penaliteFuture;
    }

    /**
     * Set principal
     *
     * @param string $principal
     *
     * @return Contrat
     */
    public function setPrincipal($principal)
    {
        $this->principal = $principal;

        return $this;
    }

    /**
     * Get principal
     *
     * @return string
     */
    public function getPrincipal()
    {
        return $this->principal;
    }

    /**
     * Set referenceImpot
     *
     * @param string $referenceImpot
     *
     * @return Contrat
     */
    public function setReferenceImpot($referenceImpot)
    {
        $this->referenceImpot = $referenceImpot;

        return $this;
    }

    /**
     * Get referenceImpot
     *
     * @return string
     */
    public function getReferenceImpot()
    {
        return $this->referenceImpot;
    }

    /**
     * Set referenceChecktatoo
     *
     * @param string $referenceChecktatoo
     *
     * @return Contrat
     */
    public function setReferenceChecktatoo($referenceChecktatoo)
    {
        $this->referenceChecktatoo = $referenceChecktatoo;

        return $this;
    }

    /**
     * Get referenceChecktatoo
     *
     * @return string
     */
    public function getReferenceChecktatoo()
    {
        return $this->referenceChecktatoo;
    }

    /**
     * Set typeMarche
     *
     * @param string $typeMarche
     *
     * @return Contrat
     */
    public function setTypeMarche($typeMarche)
    {
        $this->typeMarche = $typeMarche;

        return $this;
    }

    /**
     * Get typeMarche
     *
     * @return string
     */
    public function getTypeMarche()
    {
        return $this->typeMarche;
    }

    /**
     * Set result
     *
     * @param string $result
     *
     * @return Contrat
     */
    public function setResult($result)
    {
        $this->result = $result;

        return $this;
    }

    /**
     * Get result
     *
     * @return string
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * Set account
     *
     * @param \AMLA\SqrBundle\Entity\Account $account
     *
     * @return Contrat
     */
    public function setAccount(\AMLA\SqrBundle\Entity\Account $account = null)
    {
        $this->account = $account;

        return $this;
    }

    /**
     * Get account
     *
     * @return \AMLA\SqrBundle\Entity\Account
     */
    public function getAccount()
    {
        return $this->account;
    }

    /**
     * Set nomMarche
     *
     * @param string $nomMarche
     *
     * @return Contrat
     */
    public function setNomMarche($nomMarche)
    {
        $this->nomMarche = $nomMarche;

        return $this;
    }

    /**
     * Get nomMarche
     *
     * @return string
     */
    public function getNomMarche()
    {
        return $this->nomMarche;
    }

    /**
     * Set termeDetailScan
     *
     * @param string $termeDetailScan
     *
     * @return Contrat
     */
    public function setTermeDetailScan($termeDetailScan)
    {
        $this->termeDetailScan = $termeDetailScan;

        return $this;
    }

    /**
     * Get termeDetailScan
     *
     * @return string
     */
    public function getTermeDetailScan()
    {
        return $this->termeDetailScan;
    }
}
