<?php

namespace AMLA\SqrBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Conformite
 *
 * @ORM\Table(name="conformite")
 * @ORM\Entity(repositoryClass="AMLA\SqrBundle\Repository\ConformiteRepository")
 */
class Conformite
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="value1", type="string", length=100)
     */
    private $value1;

    /**
     * @var string
     *
     * @ORM\Column(name="value2", type="string", length=100)
     */
    private $value2;

    /**
     * @var string
     *
     * @ORM\Column(name="value3", type="string", length=100)
     */
    private $value3;
    /**
     * @var string
     *
     * @ORM\Column(name="operateur", type="string", length=100, nullable=true)
     */
    private $operateur;

    /**
     * @var string
     *
     * @ORM\Column(name="niu", type="string", length=50, nullable=true)
     */
    private $niu;

    /**
     * @var string
     *
     * @ORM\Column(name="nomRaisonSocialeClient", type="string", length=50, nullable=true)
     */
    private $nomRaisonSocialeClient;

    /**
     * @var string
     *
     * @ORM\Column(name="niu_name", type="string", length=50, nullable=true)
     */
    private $niuName;

    /**
     * @var string
     *
     * @ORM\Column(name="niuStatus", type="string", length=50, nullable=true)
     */
    private $niuStatus;

    /**
     * @var string
     *
     * @ORM\Column(name="mobileMoney", type="string", length=50, nullable=true)
     */
    private $mobileMoney;

    /**
     * @var string
     *
     * @ORM\Column(name="numeroClient", type="string", length=50, nullable=true)
     */
    private $numeroClient;

    /**
     * @var string
     *
     * @ORM\Column(name="nom", type="string", length=50, nullable=true)
     */
    private $nom;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=50, nullable=true)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="telephone", type="string", length=50, nullable=true)
     */
    private $telephone;

    /**
     * @var string
     *
     * @ORM\Column(name="boitePostale", type="string", length=50, nullable=true)
     */
    private $boitePostale;

    /**
     * @var string
     *
     * @ORM\Column(name="agence", type="string", length=50, nullable=true)
     */
    private $agence;

    /**
     * @var string
     *
     * @ORM\Column(name="numeroCompte", type="string", length=50, nullable=true)
     */
    private $numeroCompte;

    /**
     * @var string
     *
     * @ORM\Column(name="numeroCompteur", type="string", length=50, nullable=true)
     */
    private $numeroCompteur;

    /**
     * @var string
     *
     * @ORM\Column(name="numeroContrat", type="string", length=50, nullable=true)
     */
    private $numeroContrat;

    /**
     * @var string
     *
     * @ORM\Column(name="numeroFacture", type="string", length=50, nullable=true)
     */
    private $numeroFacture;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="date_created", type="datetime")
     */
    private $dateCreated;

    /**
     * @var boolean
     *
     * @ORM\Column(name="statut", type="smallint")
     *
     */
    private $statut;//{0 = en cours, 1 = confirm}

    /**
     * @var string
     *
     * @ORM\Column(name="source", type="string", length=50, nullable=true)
     *
     */
    private $source;//{1 = gnrique, 2 = ddi}

    /**
     * @ORM\ManyToOne(targetEntity="OperateurConformiteCategory", inversedBy="conformite")
     * @ORM\JoinColumn(name="operateur_conformite_category_id", referencedColumnName="id")
     */
    private $operateurConformiteCategory;

    /**
     * @ORM\ManyToOne(targetEntity="OperateurConformiteCategoryElement", inversedBy="conformite")
     * @ORM\JoinColumn(name="operateur_conformite_category_element_id", referencedColumnName="id")
     */
    private $operateurConformiteCategoryElement;
    
    /**
     * Constructor
     */
    public function __construct()
    {
        date_default_timezone_set('Africa/Douala');
        $this->dateCreated = new \Datetime(); // default date
        $this->statut = 0;// 1=Pending; 0=Success
    }


    /**
     * Get id
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set operateur
     *
     * @param string $operateur
     *
     * @return Conformite
     */
    public function setOperateur($operateur)
    {
        $this->operateur = $operateur;

        return $this;
    }

    /**
     * Get operateur
     *
     * @return string
     */
    public function getOperateur()
    {
        return $this->operateur;
    }

    /**
     * Set niu
     *
     * @param string $niu
     *
     * @return Conformite
     */
    public function setNiu($niu)
    {
        $this->niu = $niu;

        return $this;
    }

    /**
     * Get niu
     *
     * @return string
     */
    public function getNiu()
    {
        return $this->niu;
    }

    /**
     * Set mobileMoney
     *
     * @param string $mobileMoney
     *
     * @return Conformite
     */
    public function setMobileMoney($mobileMoney)
    {
        $this->mobileMoney = $mobileMoney;

        return $this;
    }

    /**
     * Get mobileMoney
     *
     * @return string
     */
    public function getMobileMoney()
    {
        return $this->mobileMoney;
    }

    /**
     * Set numeroClient
     *
     * @param string $numeroClient
     *
     * @return Conformite
     */
    public function setNumeroClient($numeroClient)
    {
        $this->numeroClient = $numeroClient;

        return $this;
    }

    /**
     * Get numeroClient
     *
     * @return string
     */
    public function getNumeroClient()
    {
        return $this->numeroClient;
    }

    /**
     * Set nom
     *
     * @param string $nom
     *
     * @return Conformite
     */
    public function setNom($nom)
    {
        $this->nom = $nom;

        return $this;
    }

    /**
     * Get nom
     *
     * @return string
     */
    public function getNom()
    {
        return $this->nom;
    }

    /**
     * Set email
     *
     * @param string $email
     *
     * @return Conformite
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set telephone
     *
     * @param string $telephone
     *
     * @return Conformite
     */
    public function setTelephone($telephone)
    {
        $this->telephone = $telephone;

        return $this;
    }

    /**
     * Get telephone
     *
     * @return string
     */
    public function getTelephone()
    {
        return $this->telephone;
    }

    /**
     * Set boitePostale
     *
     * @param string $boitePostale
     *
     * @return Conformite
     */
    public function setBoitePostale($boitePostale)
    {
        $this->boitePostale = $boitePostale;

        return $this;
    }

    /**
     * Get boitePostale
     *
     * @return string
     */
    public function getBoitePostale()
    {
        return $this->boitePostale;
    }

    /**
     * Set agence
     *
     * @param string $agence
     *
     * @return Conformite
     */
    public function setAgence($agence)
    {
        $this->agence = $agence;

        return $this;
    }

    /**
     * Get agence
     *
     * @return string
     */
    public function getAgence()
    {
        return $this->agence;
    }

    /**
     * Set numeroCompte
     *
     * @param string $numeroCompte
     *
     * @return Conformite
     */
    public function setNumeroCompte($numeroCompte)
    {
        $this->numeroCompte = $numeroCompte;

        return $this;
    }

    /**
     * Get numeroCompte
     *
     * @return string
     */
    public function getNumeroCompte()
    {
        return $this->numeroCompte;
    }

    /**
     * Set numeroCompteur
     *
     * @param string $numeroCompteur
     *
     * @return Conformite
     */
    public function setNumeroCompteur($numeroCompteur)
    {
        $this->numeroCompteur = $numeroCompteur;

        return $this;
    }

    /**
     * Get numeroCompteur
     *
     * @return string
     */
    public function getNumeroCompteur()
    {
        return $this->numeroCompteur;
    }

    /**
     * Set numeroContrat
     *
     * @param string $numeroContrat
     *
     * @return Conformite
     */
    public function setNumeroContrat($numeroContrat)
    {
        $this->numeroContrat = $numeroContrat;

        return $this;
    }

    /**
     * Get numeroContrat
     *
     * @return string
     */
    public function getNumeroContrat()
    {
        return $this->numeroContrat;
    }

    /**
     * Set numeroFacture
     *
     * @param string $numeroFacture
     *
     * @return Conformite
     */
    public function setNumeroFacture($numeroFacture)
    {
        $this->numeroFacture = $numeroFacture;

        return $this;
    }

    /**
     * Get numeroFacture
     *
     * @return string
     */
    public function getNumeroFacture()
    {
        return $this->numeroFacture;
    }

    /**
     * Set dateCreated
     *
     * @param \DateTime $dateCreated
     *
     * @return Conformite
     */
    public function setDateCreated($dateCreated)
    {
        $this->dateCreated = $dateCreated;

        return $this;
    }

    /**
     * Get dateCreated
     *
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    /**
     * Set statut
     *
     * @param integer $statut
     *
     * @return Conformite
     */
    public function setStatut($statut)
    {
        $this->statut = $statut;

        return $this;
    }

    /**
     * Get statut
     *
     * @return integer
     */
    public function getStatut()
    {
        return $this->statut;
    }

    /**
     * Set niuStatus
     *
     * @param string $niuStatus
     *
     * @return Conformite
     */
    public function setNiuStatus($niuStatus)
    {
        $this->niuStatus = $niuStatus;

        return $this;
    }

    /**
     * Get niuStatus
     *
     * @return string
     */
    public function getNiuStatus()
    {
        return $this->niuStatus;
    }

    /**
     * Set operateurConformiteCategory
     *
     * @param \AMLA\SqrBundle\Entity\OperateurConformiteCategory $operateurConformiteCategory
     *
     * @return Conformite
     */
    public function setOperateurConformiteCategory(\AMLA\SqrBundle\Entity\OperateurConformiteCategory $operateurConformiteCategory = null)
    {
        $this->operateurConformiteCategory = $operateurConformiteCategory;

        return $this;
    }

    /**
     * Get operateurConformiteCategory
     *
     * @return \AMLA\SqrBundle\Entity\OperateurConformiteCategory
     */
    public function getOperateurConformiteCategory()
    {
        return $this->operateurConformiteCategory;
    }

    /**
     * Set operateurConformiteCategoryElement
     *
     * @param \AMLA\SqrBundle\Entity\operateurConformiteCategoryElement $operateurConformiteCategoryElement
     *
     * @return Conformite
     */
    public function setOperateurConformiteCategoryElement(\AMLA\SqrBundle\Entity\operateurConformiteCategoryElement $operateurConformiteCategoryElement = null)
    {
        $this->operateurConformiteCategoryElement = $operateurConformiteCategoryElement;

        return $this;
    }

    /**
     * Get operateurConformiteCategoryElement
     *
     * @return \AMLA\SqrBundle\Entity\operateurConformiteCategoryElement
     */
    public function getOperateurConformiteCategoryElement()
    {
        return $this->operateurConformiteCategoryElement;
    }

    /**
     * Set value1
     *
     * @param string $value1
     *
     * @return Conformite
     */
    public function setValue1($value1)
    {
        $this->value1 = $value1;

        return $this;
    }

    /**
     * Get value1
     *
     * @return string
     */
    public function getValue1()
    {
        return $this->value1;
    }

    /**
     * Set value2
     *
     * @param string $value2
     *
     * @return Conformite
     */
    public function setValue2($value2)
    {
        $this->value2 = $value2;

        return $this;
    }

    /**
     * Get value2
     *
     * @return string
     */
    public function getValue2()
    {
        return $this->value2;
    }

    /**
     * Set value3
     *
     * @param string $value3
     *
     * @return Conformite
     */
    public function setValue3($value3)
    {
        $this->value3 = $value3;

        return $this;
    }

    /**
     * Get value3
     *
     * @return string
     */
    public function getValue3()
    {
        return $this->value3;
    }

    /**
     * Set niuName
     *
     * @param string $niuName
     *
     * @return Conformite
     */
    public function setNiuName($niuName)
    {
        $this->niuName = $niuName;

        return $this;
    }

    /**
     * Get niuName
     *
     * @return string
     */
    public function getNiuName()
    {
        return $this->niuName;
    }

    /**
     * Set nomRaisonSocialeClient
     *
     * @param string $nomRaisonSocialeClient
     *
     * @return Conformite
     */
    public function setNomRaisonSocialeClient($nomRaisonSocialeClient)
    {
        $this->nomRaisonSocialeClient = $nomRaisonSocialeClient;

        return $this;
    }

    /**
     * Get nomRaisonSocialeClient
     *
     * @return string
     */
    public function getNomRaisonSocialeClient()
    {
        return $this->nomRaisonSocialeClient;
    }

    /**
     * Set source
     *
     * @param string $source
     *
     * @return Conformite
     */
    public function setSource($source)
    {
        $this->source = $source;

        return $this;
    }

    /**
     * Get source
     *
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }
}
